/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.check;

import java.text.MessageFormat;
import org.eclipse.wb.internal.core.utils.check.AssertionFailedException;

public final class Assert {
    private Assert() {
    }

    public static boolean isLegal(boolean expression) {
        return Assert.isLegal(expression, "");
    }

    public static boolean isLegal(boolean expression, String message) {
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
        return expression;
    }

    public static void isNull(Object object) {
        Assert.isNull(object, "");
    }

    public static void isNull(Object object, String message) {
        if (object != null) {
            throw new AssertionFailedException("null argument expected: " + message);
        }
    }

    public static void isNull(Object object, String errorFormat, Object ... args) {
        if (object != null) {
            Assert.fail("null argument expected: " + String.format(errorFormat, args));
        }
    }

    public static void isNull2(Object object, String errorFormat, Object ... args) {
        if (object != null) {
            String message = "null argument expected: " + MessageFormat.format(errorFormat, args);
            Assert.fail(message);
        }
    }

    public static void isNotNull(Object object) {
        Assert.isNotNull(object, "");
    }

    public static void isNotNull(Object object, String message) {
        if (object == null) {
            Assert.fail("null argument: " + message);
        }
    }

    public static void isNotNull(Object object, String errorFormat, Object ... args) {
        if (object == null) {
            Assert.fail("null argument: " + String.format(errorFormat, args));
        }
    }

    public static void isNotNull2(Object object, String errorFormat, Object ... args) {
        if (object == null) {
            String message = "null argument: " + MessageFormat.format(errorFormat, args);
            Assert.fail(message);
        }
    }

    public static void fail(String message) {
        throw new AssertionFailedException(message);
    }

    public static void fail(String errorFormat, Object ... args) {
        String message = MessageFormat.format(errorFormat, args);
        throw new AssertionFailedException(message);
    }

    public static boolean isTrue(boolean expression) {
        return Assert.isTrue(expression, "");
    }

    public static boolean isTrue(boolean expression, String message) {
        if (!expression) {
            Assert.fail("assertion failed: " + message);
        }
        return expression;
    }

    public static boolean isTrue(boolean expression, String errorFormat, Object ... args) {
        if (!expression) {
            Assert.fail("assertion failed: " + String.format(errorFormat, args));
        }
        return expression;
    }

    public static boolean isTrue2(boolean expression, String errorFormat, Object ... args) {
        if (!expression) {
            Assert.fail(errorFormat, args);
        }
        return expression;
    }

    public static void equals(int expected, int actual) {
        Assert.equals(expected, actual, expected + " expected, but " + actual + " found");
    }

    public static void equals(int expected, int actual, String message) {
        if (expected != actual) {
            Assert.fail("assertation failed: " + message);
        }
    }

    public static void instanceOf(Class<?> expectedClass, Object o) {
        if (o == null) {
            Assert.fail(expectedClass.getName() + " expected, but 'null' found.");
        }
        if (!expectedClass.isAssignableFrom(o.getClass())) {
            Assert.fail(expectedClass.getName() + " expected, but " + o.getClass().getName() + " found.");
        }
    }
}

