/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.editor.string;

import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.AbstractTextPropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.presentation.ButtonPropertyEditorPresentation;
import org.eclipse.wb.internal.core.model.property.editor.presentation.PropertyEditorPresentation;
import org.eclipse.wb.internal.core.model.property.editor.string.StringPropertyDialog;
import org.eclipse.wb.internal.core.model.property.table.PropertyTable;

public class StringPropertyEditor
extends AbstractTextPropertyEditor {
    public static final PropertyEditor INSTANCE = new StringPropertyEditor();
    private final PropertyEditorPresentation m_presentation = new ButtonPropertyEditorPresentation(){

        @Override
        protected void onClick(PropertyTable propertyTable, Property property) throws Exception {
            StringPropertyEditor.this.openDialog(propertyTable, property);
        }
    };

    private StringPropertyEditor() {
    }

    @Override
    public PropertyEditorPresentation getPresentation() {
        return this.m_presentation;
    }

    @Override
    public String getText(Property property) throws Exception {
        Object value = property.getValue();
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    @Override
    protected String getEditorText(Property property) throws Exception {
        return this.getText(property);
    }

    @Override
    protected boolean setEditorText(Property property, String text) throws Exception {
        property.setValue(text);
        return true;
    }

    private void openDialog(PropertyTable propertyTable, Property property) throws Exception {
        StringPropertyDialog dialog = new StringPropertyDialog(propertyTable.getShell(), property);
        if (dialog.open() == 0) {
            // empty if block
        }
    }
}

