/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.editor.string;

import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.ModelMessages;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.dialogs.ResizableDialog;

public class StringPropertyDialog
extends ResizableDialog {
    private final Property m_property;
    private Text m_valueText;

    public StringPropertyDialog(Shell parentShell, Property property) throws Exception {
        super(parentShell, DesignerPlugin.getDefault());
        this.m_property = property;
    }

    public void create() {
        super.create();
        this.m_valueText.selectAll();
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        if (this.isMultiLine()) {
            this.m_valueText = new Text(area, 2114);
            GridDataFactory.create((Control)this.m_valueText).grab().hintC(80, 8).fill();
        } else {
            this.m_valueText = new Text(area, 2052);
            GridDataFactory.create((Control)this.m_valueText).grab().hintC(50, 1).fill();
        }
        ExecutionUtils.runLog(new RunnableEx(){

            @Override
            public void run() throws Exception {
                Object value = StringPropertyDialog.this.m_property.getValue();
                if (value instanceof String) {
                    StringPropertyDialog.this.m_valueText.setText((String)value);
                }
            }
        });
        this.m_valueText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.stateMask == 262144 && e.keyCode == 13) {
                    StringPropertyDialog.this.okPressed();
                }
            }
        });
        return area;
    }

    protected boolean isMultiLine() {
        return true;
    }

    @Override
    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(ModelMessages.StringPropertyDialog_title);
    }

    protected void okPressed() {
        final String value = this.m_valueText.getText();
        ExecutionUtils.runLog(new RunnableEx(){

            @Override
            public void run() throws Exception {
                StringPropertyDialog.this.m_property.setValue(value);
            }
        });
        super.okPressed();
    }
}

