/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.editor;

import com.google.common.base.Joiner;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.ModelMessages;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.TextDialogPropertyEditor;
import org.eclipse.wb.internal.core.utils.ui.dialogs.StringsDialog;

public final class StringArrayPropertyEditor
extends TextDialogPropertyEditor {
    public static final PropertyEditor INSTANCE = new StringArrayPropertyEditor();

    private StringArrayPropertyEditor() {
    }

    @Override
    protected String getText(Property property) throws Exception {
        Object[] items = StringArrayPropertyEditor.getItems(property);
        return "[" + Joiner.on((String)", ").join(items) + "]";
    }

    private static String[] getItems(Property property) throws Exception {
        Object value = property.getValue();
        if (value instanceof String[]) {
            return (String[])value;
        }
        return new String[0];
    }

    @Override
    protected void openDialog(Property property) throws Exception {
        StringsDialog itemsDialog = new StringsDialog(DesignerPlugin.getShell(), DesignerPlugin.getDefault(), property.getTitle(), ModelMessages.StringArrayPropertyEditor_itemsLabel, ModelMessages.StringArrayPropertyEditor_hint);
        itemsDialog.setItems(StringArrayPropertyEditor.getItems(property));
        if (itemsDialog.open() == 0) {
            property.setValue(itemsDialog.getItems());
        }
    }
}

