/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.editor;

import com.google.common.base.Objects;
import org.eclipse.wb.core.controls.CCombo3;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.AbstractComboPropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.IValueSourcePropertyEditor;

public class EnumerationValuesPropertyEditor
extends AbstractComboPropertyEditor
implements IValueSourcePropertyEditor {
    private final String[] m_names;
    private final Object[] m_values;
    private final String[] m_sources;

    public EnumerationValuesPropertyEditor(Object attributeValue) {
        Object[] enumElements = (Object[])attributeValue;
        int items = enumElements.length / 3;
        this.m_names = new String[items];
        this.m_values = new Object[items];
        this.m_sources = new String[items];
        for (int i = 0; i < items; ++i) {
            this.m_names[i] = (String)enumElements[3 * i + 0];
            this.m_values[i] = enumElements[3 * i + 1];
            this.m_sources[i] = (String)enumElements[3 * i + 2];
        }
    }

    @Override
    public String getText(Property property) throws Exception {
        Object value = property.getValue();
        if (value != Property.UNKNOWN_VALUE) {
            for (int i = 0; i < this.m_values.length; ++i) {
                if (!Objects.equal((Object)this.m_values[i], (Object)value)) continue;
                return this.m_names[i];
            }
        }
        return null;
    }

    @Override
    public String getValueSource(Object value) throws Exception {
        if (value != Property.UNKNOWN_VALUE) {
            for (int i = 0; i < this.m_values.length; ++i) {
                if (!Objects.equal((Object)this.m_values[i], (Object)value)) continue;
                return this.m_sources[i];
            }
        }
        return null;
    }

    @Override
    protected void addItems(Property property, CCombo3 combo) throws Exception {
        for (String title : this.m_names) {
            combo.add(title);
        }
    }

    @Override
    protected void selectItem(Property property, CCombo3 combo) throws Exception {
        combo.setText(this.getText(property));
    }

    @Override
    protected void toPropertyEx(Property property, CCombo3 combo, int index) throws Exception {
        Object value = this.m_values[index];
        property.setValue(value);
    }
}

