/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.editor;

import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener;
import org.eclipse.jface.fieldassist.IContentProposalListener2;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.TextControlActionsManager;
import org.eclipse.wb.internal.core.model.property.editor.TextDisplayPropertyEditor;
import org.eclipse.wb.internal.core.model.property.table.PropertyTable;

public abstract class AbstractTextPropertyEditor
extends TextDisplayPropertyEditor {
    private Text m_textControl;
    private boolean m_ignoreFocusLost;
    private String m_currentText;

    @Override
    public boolean activate(final PropertyTable propertyTable, final Property property, Point location) throws Exception {
        this.m_textControl = new Text((Composite)propertyTable, 0);
        TextControlActionsManager manager = new TextControlActionsManager(this.m_textControl);
        this.m_textControl.setEditable(this.isEditable());
        IContentProposalProvider completion = property.getAdapter(IContentProposalProvider.class);
        if (completion != null) {
            ImmediateProposalAdapter adapter = new ImmediateProposalAdapter(this.m_textControl, (IControlContentAdapter)new TextContentAdapter(), completion, null, null, propertyTable);
            adapter.setFilterStyle(1);
            adapter.setProposalAcceptanceStyle(2);
            ILabelProvider labelProvider = property.getAdapter(ILabelProvider.class);
            if (labelProvider != null) {
                adapter.setLabelProvider(labelProvider);
            }
        }
        this.m_textControl.setFocus();
        this.m_textControl.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                try {
                    AbstractTextPropertyEditor.this.handleKeyPressed(propertyTable, property, e);
                }
                catch (Throwable ex) {
                    propertyTable.deactivateEditor(false);
                    propertyTable.handleException(ex);
                }
            }
        });
        this.m_textControl.addListener(16, new Listener(){

            public void handleEvent(Event event) {
                if (!AbstractTextPropertyEditor.this.m_ignoreFocusLost) {
                    propertyTable.deactivateEditor(true);
                }
            }
        });
        this.toWidget(property);
        return true;
    }

    @Override
    public final void setBounds(Rectangle bounds) {
        this.m_textControl.setBounds(bounds);
    }

    @Override
    public final void deactivate(PropertyTable propertyTable, Property property, boolean save) {
        if (save) {
            try {
                this.toProperty(property);
            }
            catch (Throwable e) {
                propertyTable.deactivateEditor(false);
                propertyTable.handleException(e);
            }
        }
        if (this.m_textControl != null) {
            this.m_textControl.dispose();
            this.m_textControl = null;
        }
    }

    @Override
    public void keyDown(PropertyTable propertyTable, Property property, KeyEvent event) throws Exception {
        boolean withCtrl;
        boolean withAlt = (event.stateMask & 0x10000) != 0;
        boolean bl = withCtrl = (event.stateMask & 0x40000) != 0;
        if (event.character != '\u0000' && !withAlt && !withCtrl) {
            propertyTable.activateEditor(property, null);
            AbstractTextPropertyEditor.postKeyEvent(1, event);
            AbstractTextPropertyEditor.postKeyEvent(2, event);
        }
    }

    private static void postKeyEvent(int type, KeyEvent event) {
        Event lowEvent = new Event();
        lowEvent.type = type;
        lowEvent.keyCode = event.keyCode;
        lowEvent.character = event.character;
        Display.getCurrent().post(lowEvent);
    }

    private void handleKeyPressed(PropertyTable propertyTable, Property property, KeyEvent e) throws Exception {
        if (e.keyCode == 13) {
            this.toProperty(property);
            propertyTable.deactivateEditor(true);
        } else if (e.keyCode == 27) {
            propertyTable.deactivateEditor(false);
        } else if (e.keyCode == 0x1000001 || e.keyCode == 0x1000002) {
            e.doit = false;
            boolean success = this.toProperty(property);
            if (!success) {
                return;
            }
            propertyTable.deactivateEditor(true);
            propertyTable.navigate(e);
        }
    }

    private void toWidget(Property property) throws Exception {
        String text = this.getEditorText(property);
        if (text == null) {
            text = "";
        }
        this.m_currentText = text;
        this.m_textControl.setText(text);
        this.m_textControl.selectAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean toProperty(Property property) throws Exception {
        if (this.m_textControl == null) {
            return false;
        }
        String text = this.m_textControl.getText();
        if (!this.m_currentText.equals(text)) {
            this.m_ignoreFocusLost = true;
            try {
                boolean success = this.setEditorText(property, text);
                if (!success) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.m_ignoreFocusLost = false;
            }
            this.m_currentText = text;
        }
        return true;
    }

    protected boolean isEditable() {
        return true;
    }

    protected abstract String getEditorText(Property var1) throws Exception;

    protected abstract boolean setEditorText(Property var1, String var2) throws Exception;

    private class ImmediateProposalAdapter
    extends ContentProposalAdapter
    implements FocusListener,
    IContentProposalListener,
    IContentProposalListener2 {
        private final PropertyTable m_propertyTable;
        private final IContentProposalProvider m_proposalProvider;

        public ImmediateProposalAdapter(Text control, IControlContentAdapter controlContentAdapter, IContentProposalProvider proposalProvider, KeyStroke keyStroke, char[] autoActivationCharacters, PropertyTable propertyTable) {
            super((Control)control, controlContentAdapter, proposalProvider, keyStroke, autoActivationCharacters);
            this.m_propertyTable = propertyTable;
            this.m_proposalProvider = proposalProvider;
            control.addFocusListener((FocusListener)this);
            this.addContentProposalListener(this);
            this.addContentProposalListener(this);
        }

        private void openIfNecessary() {
            if (AbstractTextPropertyEditor.this.m_textControl == null || AbstractTextPropertyEditor.this.m_textControl.isDisposed() || this.m_proposalProvider.getProposals(AbstractTextPropertyEditor.this.m_textControl.getText(), AbstractTextPropertyEditor.this.m_textControl.getCaretPosition()).length == 0) {
                return;
            }
            this.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!ImmediateProposalAdapter.this.isProposalPopupOpen()) {
                        ImmediateProposalAdapter.this.openProposalPopup();
                    }
                }
            });
        }

        public void focusGained(FocusEvent event) {
            this.openIfNecessary();
        }

        public void focusLost(FocusEvent event) {
        }

        public void proposalAccepted(IContentProposal proposal) {
            this.closeProposalPopup();
            this.m_propertyTable.deactivateEditor(true);
        }

        public void proposalPopupClosed(ContentProposalAdapter adapter) {
            AbstractTextPropertyEditor.this.m_ignoreFocusLost = false;
        }

        public void proposalPopupOpened(ContentProposalAdapter adapter) {
            AbstractTextPropertyEditor.this.m_ignoreFocusLost = true;
        }
    }
}

