/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.editor;

import java.util.List;
import java.util.Map;
import org.eclipse.wb.core.controls.CCombo3;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.AbstractComboPropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.IValueSourcePropertyEditor;
import org.eclipse.wb.internal.core.utils.check.Assert;

public abstract class AbstractListPropertyEditor
extends AbstractComboPropertyEditor
implements IValueSourcePropertyEditor {
    @Override
    public String getText(Property property) throws Exception {
        Object value = property.getValue();
        if (value != Property.UNKNOWN_VALUE) {
            int index = this.getValueIndex(value);
            if (index >= 0) {
                return this.getTitle(index);
            }
            if (value instanceof String) {
                return (String)value;
            }
        }
        return null;
    }

    @Override
    public String getValueSource(Object value) throws Exception {
        int index;
        if (value != Property.UNKNOWN_VALUE && (index = this.getValueIndex(value)) >= 0) {
            return this.getExpression(index);
        }
        return null;
    }

    @Override
    protected void addItems(Property property, CCombo3 combo) throws Exception {
        for (int i = 0; i < this.getCount(); ++i) {
            combo.add(this.getTitle(i));
        }
    }

    @Override
    protected void selectItem(Property property, CCombo3 combo) throws Exception {
        combo.setText(this.getText(property));
    }

    @Override
    protected void toPropertyEx(Property property, CCombo3 combo, int index) throws Exception {
        this.toPropertyEx_simpleProperty(property, combo, index);
    }

    protected void toPropertyEx_simpleProperty(Property property, CCombo3 combo, int index) throws Exception {
    }

    protected abstract int getCount();

    protected abstract int getValueIndex(Object var1);

    protected abstract String getTitle(int var1);

    protected abstract String getExpression(int var1) throws Exception;

    protected static String[] getParameterAsArray(Map<String, Object> parameters, String name) {
        return AbstractListPropertyEditor.getParameterAsArray(parameters, name, false);
    }

    protected static String[] getParameterAsArray(Map<String, Object> parameters, String name, boolean noAssert) {
        String[] values = null;
        if (parameters.containsKey(name)) {
            List list = (List)parameters.get(name);
            values = list.toArray(new String[list.size()]);
        } else if (noAssert) {
            values = null;
        } else {
            Assert.fail(String.format("No parameter %s in %s.", name, parameters));
        }
        return values;
    }
}

