/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property;

import com.google.common.collect.Maps;
import java.util.Comparator;
import java.util.Map;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategory;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;

public abstract class Property {
    public static final Object UNKNOWN_VALUE = new Object(){

        public String toString() {
            return "UNKNOWN_VALUE";
        }
    };
    protected final PropertyEditor m_editor;
    private PropertyCategory m_category = PropertyCategory.NORMAL;
    private Map<Object, Object> m_arbitraryMap;
    private int mPriority;
    public static final Comparator<Property> ALPHABETICAL = new Comparator<Property>(){

        @Override
        public int compare(Property p1, Property p2) {
            return p1.getName().compareTo(p2.getName());
        }
    };
    public static final Comparator<Property> PRIORITY = new Comparator<Property>(){

        @Override
        public int compare(Property p1, Property p2) {
            int delta = p1.mPriority - p2.mPriority;
            if (delta != 0) {
                return delta;
            }
            return p1.getName().compareTo(p2.getName());
        }
    };

    public Property(PropertyEditor editor) {
        this.m_editor = editor;
    }

    public abstract String getTitle();

    public abstract boolean isModified() throws Exception;

    public final PropertyCategory getCategory() {
        return this.m_category;
    }

    public final void setCategory(PropertyCategory category) {
        this.m_category = category;
    }

    public abstract Object getValue() throws Exception;

    public abstract void setValue(Object var1) throws Exception;

    public final PropertyEditor getEditor() {
        return this.m_editor;
    }

    public Property getComposite(Property[] properties) {
        return null;
    }

    public <T> T getAdapter(Class<T> adapter) {
        return null;
    }

    public final void putArbitraryValue(Object key, Object value) {
        if (this.m_arbitraryMap == null) {
            this.m_arbitraryMap = Maps.newHashMap();
        }
        this.m_arbitraryMap.put(key, value);
    }

    public final Object getArbitraryValue(Object key) {
        if (this.m_arbitraryMap != null) {
            return this.m_arbitraryMap.get(key);
        }
        return null;
    }

    public final void removeArbitraryValue(Object key) {
        if (this.m_arbitraryMap != null) {
            this.m_arbitraryMap.remove(key);
        }
    }

    public String getName() {
        return this.getTitle();
    }

    public int getPriority() {
        return this.mPriority;
    }

    public void setPriority(int priority) {
        this.mPriority = priority;
    }
}

