/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core;

import com.google.common.collect.Maps;
import com.google.common.io.CharStreams;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wb.internal.core.EnvironmentUtils;

public class DesignerPlugin {
    private static AbstractUIPlugin sPlugin;
    private static String sPluginId;
    private static Map<String, ImageDescriptor> sDescriptorCache;
    private static Map<String, Image> sImageCache;

    public static void initialize(AbstractUIPlugin hostPlugin, String pluginId, boolean isWindows, boolean isMac, boolean isLinux) {
        assert (sPlugin == null);
        sPlugin = hostPlugin;
        sPluginId = pluginId;
        EnvironmentUtils.IS_WINDOWS = isWindows;
        EnvironmentUtils.IS_MAC = isMac;
        EnvironmentUtils.IS_LINUX = isLinux;
    }

    public static void dispose() {
        sPlugin = null;
        for (Image image : sImageCache.values()) {
            image.dispose();
        }
        sImageCache.clear();
        sDescriptorCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(InputStream inputStream, Charset charset) {
        if (inputStream == null) {
            return null;
        }
        Closeable closeMe = inputStream;
        try {
            InputStreamReader isr = new InputStreamReader(inputStream, charset);
            closeMe = isr;
            try {
                String string = CharStreams.toString((Readable)isr);
                return string;
            }
            catch (Exception ioe) {
                String string = null;
                Closeables.closeQuietly((Closeable)closeMe);
                return string;
            }
        }
        finally {
            Closeables.closeQuietly((Closeable)closeMe);
        }
    }

    public static AbstractUIPlugin getDefault() {
        assert (sPlugin != null);
        return sPlugin;
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return DesignerPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static Shell getShell() {
        if (DesignerPlugin.getActiveWorkbenchWindow() != null) {
            return DesignerPlugin.getActiveWorkbenchWindow().getShell();
        }
        return null;
    }

    public static void log(IStatus status) {
        DesignerPlugin.getDefault().getLog().log(status);
    }

    public static void log(String message) {
        DesignerPlugin.log((IStatus)new Status(1, sPluginId, 1, message, null));
    }

    public static void log(Throwable e) {
        Status status = new Status(4, sPluginId, "", e);
        DesignerPlugin.getDefault().getLog().log((IStatus)status);
    }

    public static void log(String message, Throwable e) {
        DesignerPlugin.log((IStatus)DesignerPlugin.createStatus(message, e));
    }

    public static Status createStatus(String message, Throwable e) {
        return new Status(4, "wb", 4, message, e){

            public boolean isMultiStatus() {
                return true;
            }
        };
    }

    public static Image getImage(String path) {
        Image image = sImageCache.get(path);
        if (image == null) {
            ImageDescriptor descriptor = DesignerPlugin.getImageDescriptor(path);
            if (descriptor != null) {
                image = descriptor.createImage();
            }
            sImageCache.put(path, image);
        }
        return image;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        URL url;
        ImageDescriptor descriptor = sDescriptorCache.get(path);
        if (descriptor == null && (url = DesignerPlugin.class.getResource("icons/" + path)) != null) {
            descriptor = ImageDescriptor.createFromURL((URL)url);
            sDescriptorCache.put(path, descriptor);
        }
        return descriptor;
    }

    static {
        sDescriptorCache = Maps.newHashMap();
        sImageCache = Maps.newHashMap();
    }
}

