/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.certmanager.ui.wizards;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.andmore.android.certmanager.i18n.CertificateManagerNLS;
import org.eclipse.core.internal.resources.Folder;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class RemoveExternalPackageSignaturePage
extends WizardPage {
    private Text sourceDirText = null;
    private Button browseDirButton = null;
    private Button workspaceDirButton = null;
    private Tree packagesTree = null;
    private Button selectAllButton = null;
    private Button deselectAllButton = null;
    private WizardSelection selection = null;
    protected Composite mainComposite = null;

    public RemoveExternalPackageSignaturePage(String pageName, IStructuredSelection selection) {
        super(pageName);
        this.setDescription(CertificateManagerNLS.UNSIGN_EXTERNAL_PKG_WIZARD_DESCRIPTION);
        this.setTitle(CertificateManagerNLS.UNSIGN_EXTERNAL_PKG_WIZARD_WINDOW_TITLE);
        this.selection = new WizardSelection(selection);
    }

    public void createControl(Composite parent) {
        this.mainComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(4, false);
        this.mainComposite.setLayout((Layout)layout);
        Label sourceDirLabel = new Label(this.mainComposite, 0);
        sourceDirLabel.setText(CertificateManagerNLS.SIGN_EXTERNAL_PKG_WIZARD_SOURCE_DIR_LABEL);
        GridData layoutData = new GridData(4, 0x1000000, false, false, 1, 1);
        sourceDirLabel.setLayoutData((Object)layoutData);
        this.sourceDirText = new Text(this.mainComposite, 2048);
        layoutData = new GridData(4, 0x1000000, true, false, 1, 1);
        this.sourceDirText.setLayoutData((Object)layoutData);
        this.sourceDirText.addListener(24, (Listener)new SourceDirectoryTextListener());
        this.browseDirButton = new Button(this.mainComposite, 8);
        this.browseDirButton.setText(CertificateManagerNLS.SIGN_EXTERNAL_PKG_WIZARD_FILESYSTEM);
        layoutData = new GridData(4, 0x1000000, false, false, 1, 1);
        this.browseDirButton.setLayoutData((Object)layoutData);
        this.browseDirButton.addListener(13, (Listener)new BrowseButtonListener());
        this.workspaceDirButton = new Button(this.mainComposite, 8);
        this.workspaceDirButton.setText(CertificateManagerNLS.SIGN_EXTERNAL_PKG_WIZARD_WORKSPACE);
        layoutData = new GridData(4, 0x1000000, false, false, 1, 1);
        this.workspaceDirButton.setLayoutData((Object)layoutData);
        this.workspaceDirButton.addListener(13, (Listener)new WorkspaceButtonListener());
        this.createExtendedArea(this.mainComposite);
        this.createPackageTreeLabel();
        this.packagesTree = new Tree(this.mainComposite, 2592);
        layoutData = new GridData(4, 4, true, true, 3, 2);
        layoutData.heightHint = 150;
        this.packagesTree.setLayoutData((Object)layoutData);
        this.packagesTree.addListener(13, (Listener)new TreeSelectionListener());
        Composite selectionButtons = new Composite(this.mainComposite, 4);
        layoutData = new GridData(4, 128, false, true, 1, 2);
        selectionButtons.setLayoutData((Object)layoutData);
        FillLayout row = new FillLayout(512);
        row.spacing = 3;
        selectionButtons.setLayout((Layout)row);
        this.selectAllButton = new Button(selectionButtons, 8);
        this.selectAllButton.setText(CertificateManagerNLS.PACKAGE_EXPORT_WIZARD_AREA_SELECT_ALL_BUTTON);
        SelectionButtonsListener selectionButtonsListener = new SelectionButtonsListener();
        this.selectAllButton.addListener(13, (Listener)selectionButtonsListener);
        this.deselectAllButton = new Button(selectionButtons, 8);
        this.deselectAllButton.setText(CertificateManagerNLS.PACKAGE_EXPORT_WIZARD_AREA_DESELECT_ALL_BUTTON);
        this.deselectAllButton.addListener(13, (Listener)selectionButtonsListener);
        this.sourceDirText.setText(this.selection.getSelectedDirectory());
        this.populateTree(this.selection.getSelectedPackages());
        this.updatePageComplete();
        this.setControl((Control)this.mainComposite);
    }

    protected void createPackageTreeLabel() {
        Label packagesLabel = new Label(this.mainComposite, 0);
        packagesLabel.setText(CertificateManagerNLS.RemoveExternalPackageSignaturePage_Package_Tree_Label);
        GridData layoutData = new GridData(4, 0x1000000, false, false, 4, 1);
        packagesLabel.setLayoutData((Object)layoutData);
    }

    protected void createExtendedArea(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.andmore.android.certmanager.unsign_external_pkg_wiz");
    }

    private void populateTree(List<String> selection) {
        File sourceDir = this.getSourcePath().toFile();
        Color gray = new Color(null, 130, 130, 130);
        this.packagesTree.removeAll();
        if (sourceDir.isDirectory() && sourceDir.canWrite()) {
            File[] list;
            File[] fileArray = list = sourceDir.listFiles();
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.canRead() && file.isFile() && file.getName().endsWith("apk")) {
                    TreeItem fileItem = new TreeItem(this.packagesTree, 0);
                    String text = file.getName();
                    if (!file.canWrite()) {
                        text = String.valueOf(text) + " [" + CertificateManagerNLS.READ_ONLY_TEXT + "]";
                        fileItem.setForeground(gray);
                    }
                    fileItem.setText(text);
                    fileItem.setData((Object)file);
                    if (selection != null && selection.contains(file.getName()) && file.canWrite()) {
                        fileItem.setChecked(true);
                    }
                }
                ++n2;
            }
        }
    }

    private boolean isSourceDirValid() {
        String messageAux = null;
        int severity = 0;
        Path path = new Path(this.sourceDirText.getText());
        if (this.sourceDirText.getText().equals("")) {
            messageAux = CertificateManagerNLS.SIGN_EXTERNAL_PKG_WIZARD_SOURCE_DIR_EMPTY;
            severity = 1;
        }
        if (messageAux == null && Platform.getOS().equalsIgnoreCase("win32")) {
            if (path.toString().length() > 255) {
                messageAux = CertificateManagerNLS.SELECTOR_MESSAGE_LOCATION_ERROR_PATH_TOO_LONG;
                severity = 2;
            }
            String device = path.getDevice();
            File deviceFile = null;
            if (device != null) {
                deviceFile = new File(path.getDevice());
            }
            if (device != null && !deviceFile.exists()) {
                messageAux = String.valueOf(CertificateManagerNLS.SELECTOR_MESSAGE_LOCATION_ERROR_INVALID_DEVICE) + " [" + device + "]";
                severity = 3;
            }
        }
        if (!(messageAux != null || path.isAbsolute() && path.toFile().exists())) {
            messageAux = CertificateManagerNLS.SIGN_EXTERNAL_PKG_WIZARD_SOURCE_DIR_INVALID;
            severity = 3;
        }
        if (messageAux == null) {
            String[] stringArray = path.segments();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String folderName = stringArray[n2];
                if (!ResourcesPlugin.getWorkspace().validateName(folderName, 2).isOK()) {
                    messageAux = CertificateManagerNLS.SIGN_EXTERNAL_PKG_WIZARD_SOURCE_DIR_INVALID;
                    severity = 3;
                }
                ++n2;
            }
        }
        if (messageAux == null && path.toFile().exists() && !path.toFile().isDirectory()) {
            messageAux = CertificateManagerNLS.SIGN_EXTERNAL_PKG_WIZARD_SOURCE_DIR_NOT_DIRECTORY;
            severity = 3;
        }
        if (messageAux == null) {
            messageAux = CertificateManagerNLS.SIGN_EXTERNAL_PKG_WIZARD_DESCRIPTION;
            severity = 0;
        }
        this.setMessage(messageAux, severity);
        return severity == 0;
    }

    public IPath getSourcePath() {
        return new Path(this.sourceDirText.getText());
    }

    public List<String> getSelectedPackages() {
        ArrayList<String> selected = new ArrayList<String>();
        TreeItem[] treeItemArray = this.packagesTree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (item.getChecked()) {
                selected.add(item.getData().toString());
            }
            ++n2;
        }
        return selected;
    }

    public void updatePageComplete() {
        String messageAux = null;
        int severity = 0;
        if (this.isSourceDirValid()) {
            if (this.packagesTree.getItemCount() == 0) {
                messageAux = CertificateManagerNLS.SIGN_EXTERNAL_PKG_WIZARD_NO_AVAILABLE_PACKAGES;
                severity = 3;
            }
        } else {
            messageAux = this.getMessage();
            severity = this.getMessageType();
        }
        if (messageAux == null && this.getSelectedPackages().size() == 0) {
            messageAux = CertificateManagerNLS.UNSIGN_EXTERNAL_PKG_WIZARD_NO_PACKAGES_SELECTED;
            severity = 1;
        }
        if (messageAux == null) {
            messageAux = CertificateManagerNLS.UNSIGN_EXTERNAL_PKG_WIZARD_DESCRIPTION;
            severity = 0;
        }
        this.setMessage(messageAux, severity);
        this.setPageComplete(severity == 0);
    }

    class BrowseButtonListener
    implements Listener {
        BrowseButtonListener() {
        }

        public void handleEvent(Event event) {
            DirectoryDialog dialog = new DirectoryDialog(RemoveExternalPackageSignaturePage.this.mainComposite.getShell());
            dialog.setFilterPath(!RemoveExternalPackageSignaturePage.this.sourceDirText.getText().trim().equals("") ? RemoveExternalPackageSignaturePage.this.sourceDirText.getText() : null);
            String path = dialog.open();
            if (path != null) {
                RemoveExternalPackageSignaturePage.this.sourceDirText.setText(path);
                RemoveExternalPackageSignaturePage.this.populateTree(null);
                RemoveExternalPackageSignaturePage.this.updatePageComplete();
            }
        }
    }

    class SelectionButtonsListener
    implements Listener {
        SelectionButtonsListener() {
        }

        private void setCheckedAll(boolean check) {
            TreeItem[] treeItemArray = RemoveExternalPackageSignaturePage.this.packagesTree.getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                item.setChecked(check);
                ++n2;
            }
        }

        public void handleEvent(Event event) {
            if (event.widget == RemoveExternalPackageSignaturePage.this.selectAllButton) {
                this.setCheckedAll(true);
            } else if (event.widget == RemoveExternalPackageSignaturePage.this.deselectAllButton) {
                this.setCheckedAll(false);
            }
            RemoveExternalPackageSignaturePage.this.updatePageComplete();
        }
    }

    class SourceDirectoryTextListener
    implements Listener {
        SourceDirectoryTextListener() {
        }

        public void handleEvent(Event event) {
            RemoveExternalPackageSignaturePage.this.packagesTree.removeAll();
            if (RemoveExternalPackageSignaturePage.this.isSourceDirValid()) {
                RemoveExternalPackageSignaturePage.this.populateTree(null);
            }
            RemoveExternalPackageSignaturePage.this.updatePageComplete();
        }
    }

    class TreeSelectionListener
    implements Listener {
        TreeSelectionListener() {
        }

        public void handleEvent(Event event) {
            RemoveExternalPackageSignaturePage.this.updatePageComplete();
        }
    }

    class WizardSelection {
        private ArrayList<String> packages = new ArrayList();
        private IPath directory = null;

        public WizardSelection(IStructuredSelection selection) {
            for (Object obj : selection) {
                if (obj instanceof IFile) {
                    IFile file = (IFile)obj;
                    if (!file.getLocation().getFileExtension().equals("apk")) continue;
                    if (this.directory == null) {
                        this.directory = file.getLocation().removeLastSegments(1);
                        this.packages.add(file.getName());
                        continue;
                    }
                    if (file.getLocation().matchingFirstSegments(this.directory) != this.directory.segmentCount()) continue;
                    this.packages.add(file.getName());
                    continue;
                }
                if (!(obj instanceof IFolder) || this.directory != null) continue;
                this.directory = ((IFolder)obj).getLocation();
            }
            if (this.directory == null) {
                this.directory = new Path("");
            }
        }

        public String getSelectedDirectory() {
            return this.directory.toOSString();
        }

        public List<String> getSelectedPackages() {
            return this.packages;
        }
    }

    class WorkspaceButtonListener
    implements Listener {
        WorkspaceButtonListener() {
        }

        public void handleEvent(Event event) {
            ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(RemoveExternalPackageSignaturePage.this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
            dialog.setTitle(CertificateManagerNLS.SIGN_EXTERNAL_PKG_WIZARD_WORKSPACE_SIMPLE);
            dialog.setMessage(CertificateManagerNLS.SIGN_EXTERNAL_PKG_WIZARD_CHOOSE);
            dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
            dialog.setComparator((ViewerComparator)new ResourceComparator(1));
            dialog.addFilter(new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    boolean filtered = false;
                    if (element instanceof IFile) {
                        filtered = true;
                    }
                    return !filtered;
                }
            });
            dialog.setValidator(new ISelectionStatusValidator(){

                public IStatus validate(Object[] selection) {
                    Status valid = new Status(4, "org.eclipse.andmore.android.certmanager", "");
                    if (selection.length == 1 && selection[0] instanceof Folder) {
                        valid = new Status(0, "org.eclipse.andmore.android.certmanager", "");
                    }
                    return valid;
                }
            });
            String path = null;
            if (dialog.open() == 0) {
                Folder resource = (Folder)dialog.getFirstResult();
                path = resource.getLocation().toString();
            }
            if (path != null) {
                RemoveExternalPackageSignaturePage.this.sourceDirText.setText(path);
                RemoveExternalPackageSignaturePage.this.populateTree(null);
                RemoveExternalPackageSignaturePage.this.updatePageComplete();
            }
        }
    }
}

