/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.certmanager.ui.model;

import org.eclipse.andmore.android.certmanager.event.KeyStoreModelEvent;
import org.eclipse.andmore.android.certmanager.event.KeyStoreModelEventManager;
import org.eclipse.andmore.android.certmanager.exception.KeyStoreManagerException;
import org.eclipse.andmore.android.certmanager.i18n.CertificateManagerNLS;
import org.eclipse.andmore.android.certmanager.ui.model.ITreeNode;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public abstract class AbstractTreeNode
implements ITreeNode {
    private static final String UNSAVED_PASSWORD = CertificateManagerNLS.AbstractTreeNode_UnsavedPassword_Tooltip;
    private static final String SAVED_PASSWORD = CertificateManagerNLS.AbstractTreeNode_SavedPassword_Tooltip;
    private IStatus nodeStatus = Status.OK_STATUS;
    private ITreeNode parent;
    private String tooltip;

    @Override
    public String getTooltip() {
        if (this.tooltip != null) {
            return this.isPasswordSaved() ? String.valueOf(SAVED_PASSWORD) + "\n" + this.tooltip : String.valueOf(UNSAVED_PASSWORD) + "\n" + this.tooltip;
        }
        return this.isPasswordSaved() ? SAVED_PASSWORD : UNSAVED_PASSWORD;
    }

    @Override
    public IStatus getNodeStatus() {
        return this.nodeStatus;
    }

    @Override
    public void setNodeStatus(IStatus nodeStatus) {
        this.nodeStatus = nodeStatus;
        KeyStoreModelEventManager.getInstance().fireEvent(this, KeyStoreModelEvent.EventType.UPDATE);
    }

    @Override
    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    @Override
    public ITreeNode getParent() {
        return this.parent;
    }

    public void setParent(ITreeNode parent) {
        this.parent = parent;
    }

    @Override
    public void addChild(ITreeNode newChild) throws KeyStoreManagerException {
    }

    public boolean testAttribute(Object target, String name, String value) {
        boolean result = false;
        if (name.equals("org.eclipse.andmore.android.certmanager.core.property.nodeStatus")) {
            if (value.equals("org.eclipse.andmore.android.certmanager.core.property.nodeStatusError")) {
                boolean bl = result = !this.getNodeStatus().isOK();
                if (result) {
                    this.setTooltip(this.getNodeStatus().getMessage());
                }
            } else if (value.equals("org.eclipse.andmore.android.certmanager.core.property.nodeStatusOk")) {
                result = this.getNodeStatus().isOK();
            }
        }
        return result;
    }

    protected boolean isPasswordSaved() {
        return false;
    }
}

