/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.certmanager.ui.composite;

import org.eclipse.andmore.android.certmanager.i18n.CertificateManagerNLS;
import org.eclipse.andmore.android.common.utilities.ui.Country;
import org.eclipse.andmore.android.common.utilities.ui.ToolsCountries;
import org.eclipse.andmore.android.common.utilities.ui.WidgetsFactory;
import org.eclipse.andmore.android.common.utilities.ui.WidgetsUtil;
import org.eclipse.andmore.android.wizards.elements.IBaseBlock;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CertificateBlock
implements IBaseBlock {
    private static final String LABEL_DECORATOR = "*";
    private static final int LONG_TEXT_SIZE = 256;
    private static final int MEDIUM_TEXT_SIZE = 128;
    private static final int SMALL_TEXT_SIZE = 64;
    private Shell shell;
    protected Composite parent;
    private Text textAlias;
    private Text commonNameText;
    private Text textOrganization;
    private Text textOrganizationUnit;
    private Text textLocality;
    private Text textState;
    private Combo comboCountry;
    private Label labelAlias;
    private Control controlToFocus = null;
    protected FocusListener focusListener = new FocusListener(){

        public void focusLost(FocusEvent e) {
        }

        public void focusGained(FocusEvent e) {
            if (e.widget instanceof Control) {
                CertificateBlock.this.controlToFocus = (Control)e.widget;
            }
        }
    };

    public Composite createContent(Composite parent) {
        Composite toReturn = WidgetsFactory.createComposite((Composite)parent, (int)1);
        this.parent = parent;
        this.createBasicInfoArea(toReturn);
        this.createDetailedInfoArea(toReturn);
        this.createCustomArea(toReturn);
        this.setDefaultFocus();
        return toReturn;
    }

    protected void createCustomArea(Composite parent) {
    }

    protected void createCustomDetailedInfoArea(Composite dnFieldsArea) {
    }

    private void createDetailedInfoArea(Composite parent) {
        Group detailsGroup = WidgetsFactory.createTitledGroup((Composite)parent, (String)CertificateManagerNLS.CertificateBlock_DetailedInfoGroupTitle, (int)2);
        WidgetsFactory.createLabel((Composite)detailsGroup, (String)(String.valueOf(CertificateManagerNLS.CertificateBlock_FirstAndLastName) + ":"));
        this.commonNameText = WidgetsFactory.createText((Composite)detailsGroup);
        this.commonNameText.setTextLimit(128);
        this.commonNameText.addListener(24, (Listener)this);
        this.commonNameText.addFocusListener(this.focusListener);
        WidgetsFactory.createLabel((Composite)detailsGroup, (String)(String.valueOf(CertificateManagerNLS.CertificateBlock_Organization) + ":"));
        this.textOrganization = WidgetsFactory.createText((Composite)detailsGroup);
        this.textOrganization.setTextLimit(128);
        this.textOrganization.addListener(24, (Listener)this);
        this.textOrganization.addFocusListener(this.focusListener);
        WidgetsFactory.createLabel((Composite)detailsGroup, (String)(String.valueOf(CertificateManagerNLS.CertificateBlock_OrganizationUnit) + ":"));
        this.textOrganizationUnit = WidgetsFactory.createText((Composite)detailsGroup);
        this.textOrganizationUnit.setTextLimit(128);
        this.textOrganizationUnit.addListener(24, (Listener)this);
        this.textOrganizationUnit.addFocusListener(this.focusListener);
        WidgetsFactory.createLabel((Composite)detailsGroup, (String)(String.valueOf(CertificateManagerNLS.CertificateBlock_CityOrLocality) + ":"));
        this.textLocality = WidgetsFactory.createText((Composite)detailsGroup);
        this.textLocality.setTextLimit(256);
        this.textLocality.addListener(24, (Listener)this);
        this.textLocality.addFocusListener(this.focusListener);
        WidgetsFactory.createLabel((Composite)detailsGroup, (String)(String.valueOf(CertificateManagerNLS.CertificateBlock_StateOrProvince) + ":"));
        this.textState = WidgetsFactory.createText((Composite)detailsGroup);
        this.textState.setTextLimit(256);
        this.textState.addListener(24, (Listener)this);
        this.textState.addFocusListener(this.focusListener);
        WidgetsFactory.createLabel((Composite)detailsGroup, (String)(String.valueOf(CertificateManagerNLS.CertificateBlock_CountryCode) + ":"));
        this.comboCountry = WidgetsFactory.createCombo((Composite)detailsGroup);
        this.comboCountry.addListener(13, (Listener)this);
        this.comboCountry.addFocusListener(this.focusListener);
        for (Country country : ToolsCountries.getInstance().getCountries()) {
            this.comboCountry.add(country.getCountryName());
            this.comboCountry.setData(country.getCountryName(), (Object)country.getCountryCode());
        }
        this.comboCountry.setVisibleItemCount(64);
        this.createCustomDetailedInfoArea((Composite)detailsGroup);
    }

    private void createBasicInfoArea(Composite parent) {
        Group groupBasicInfo = WidgetsFactory.createTitledGroup((Composite)parent, (String)CertificateManagerNLS.CertificateBlock_BasicInfoGroupTitle, (int)2);
        this.labelAlias = WidgetsFactory.createLabel((Composite)groupBasicInfo, (String)(String.valueOf(CertificateManagerNLS.CertificateBlock_AliasName) + ":"));
        this.textAlias = WidgetsFactory.createText((Composite)groupBasicInfo);
        this.textAlias.setTextLimit(64);
        this.textAlias.addListener(24, (Listener)this);
        this.textAlias.addFocusListener(this.focusListener);
        this.createCustomBasicInfoArea((Composite)groupBasicInfo);
    }

    protected void createCustomBasicInfoArea(Composite parent) {
    }

    protected void decorateRequiredFields() {
        this.labelAlias.setText(this.decorateText(this.labelAlias.getText()));
    }

    protected String decorateText(String strToDecorate) {
        return LABEL_DECORATOR.concat(strToDecorate);
    }

    public String getAlias() {
        return this.textAlias.getText().toLowerCase();
    }

    public String getCommonName() {
        return this.commonNameText.getText();
    }

    public String getOrganization() {
        return this.textOrganization.getText();
    }

    public String getOrganizationUnit() {
        return this.textOrganizationUnit.getText();
    }

    public String getLocality() {
        return this.textLocality.getText();
    }

    public String getState() {
        return this.textState.getText();
    }

    public String getCountry() {
        String result = new String();
        if (this.comboCountry.getSelectionIndex() >= 0) {
            result = (String)this.comboCountry.getData(this.comboCountry.getItem(this.comboCountry.getSelectionIndex()));
        }
        return result;
    }

    public boolean isPageComplete() {
        return this.getErrorMessage() == null && !WidgetsUtil.isNullOrEmpty((Text)this.textAlias) && (!WidgetsUtil.isNullOrEmpty((Text)this.commonNameText) || !WidgetsUtil.isNullOrEmpty((Text)this.textOrganization) || !WidgetsUtil.isNullOrEmpty((Text)this.textOrganizationUnit) || !WidgetsUtil.isNullOrEmpty((Text)this.textLocality) || !WidgetsUtil.isNullOrEmpty((Text)this.textState) || !WidgetsUtil.isNullOrDeselected((Combo)this.comboCountry));
    }

    public boolean canFlipToNextPage() {
        return this.getErrorMessage() == null && this.isPageComplete();
    }

    public String getErrorMessage() {
        String toReturn = null;
        if (WidgetsUtil.isNullOrEmpty((Text)this.textAlias)) {
            toReturn = NLS.bind((String)CertificateManagerNLS.CertificateBlock_FieldIsEmpty, (Object)CertificateManagerNLS.CertificateBlock_AliasName);
        } else if (WidgetsUtil.isNullOrEmpty((Text)this.commonNameText) && WidgetsUtil.isNullOrEmpty((Text)this.textOrganization) && WidgetsUtil.isNullOrEmpty((Text)this.textOrganizationUnit) && WidgetsUtil.isNullOrEmpty((Text)this.textLocality) && WidgetsUtil.isNullOrEmpty((Text)this.textState) && WidgetsUtil.isNullOrDeselected((Combo)this.comboCountry)) {
            toReturn = CertificateManagerNLS.CertificateBlock_DetailedInfoNonEmptyFieldsRestriction;
        }
        return toReturn;
    }

    public Composite createInfoBlock(Composite parent, String alias, String name, String organization, String organizationUnit, String country, String state, String locality) {
        Composite toReturn = this.createContent(parent);
        this.textAlias.setText(alias);
        this.commonNameText.setText(name);
        this.textOrganization.setText(organization);
        this.textOrganizationUnit.setText(organizationUnit);
        this.textLocality.setText(locality);
        this.textState.setText(state);
        int i = 0;
        boolean found = false;
        while (i < this.comboCountry.getItemCount() && !found) {
            String id = (String)this.comboCountry.getData(this.comboCountry.getItem(i));
            if (id.equalsIgnoreCase(country)) {
                this.comboCountry.select(i);
                found = true;
            }
            ++i;
        }
        this.textAlias.setEditable(false);
        this.commonNameText.setEditable(false);
        this.textOrganization.setEditable(false);
        this.textOrganizationUnit.setEditable(false);
        this.textLocality.setEditable(false);
        this.textState.setEditable(false);
        if (!found) {
            this.comboCountry.add(CertificateManagerNLS.CertificateInfoDialog_NotAvailableProperty, 0);
            this.comboCountry.select(0);
        }
        this.comboCountry.setEnabled(false);
        return toReturn;
    }

    public void handleEvent(Event event) {
        if (this.parent != null) {
            this.parent.notifyListeners(event.type, event);
        }
    }

    public void refresh() {
    }

    public void setShell(Shell shell) {
        this.shell = shell;
    }

    public Shell getShell() {
        return this.shell;
    }

    public void setDefaultFocus() {
        this.controlToFocus = this.textAlias;
    }

    public void setFocus() {
        if (this.controlToFocus != null) {
            this.controlToFocus.setFocus();
        }
    }
}

