/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.certmanager.core;

import java.io.File;
import java.io.IOException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import junit.framework.TestCase;
import org.bouncycastle.operator.OperatorCreationException;
import org.eclipse.andmore.android.certmanager.core.KeyStoreUtils;
import org.eclipse.andmore.android.certmanager.exception.InvalidPasswordException;
import org.eclipse.andmore.android.certmanager.exception.KeyStoreManagerException;
import org.eclipse.andmore.android.certmanager.ui.model.CertificateDetailsInfo;
import org.junit.Test;

public class KeyStoreUtilsTest
extends TestCase {
    File keyStoreFile = null;
    private String passwd;

    protected void setUp() throws Exception {
        this.keyStoreFile = File.createTempFile("testKeystore", ".tmp");
        this.passwd = "passwd";
        super.setUp();
    }

    @Test
    public void testCreateKeystore() {
        KeyStore keyStore;
        block6: {
            keyStore = null;
            try {
                keyStore = KeyStoreUtils.createKeystore(this.keyStoreFile, this.passwd.toCharArray());
            }
            catch (KeyStoreManagerException keyStoreManagerException) {
                assert (false);
            }
            catch (InvalidPasswordException invalidPasswordException) {
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
        assert (keyStore != null);
        assert (this.keyStoreFile.length() > 0L);
    }

    @Test
    public void testLoadKeyStore() {
        block6: {
            try {
                KeyStore keyStore = KeyStoreUtils.loadKeystore(this.keyStoreFile, this.passwd.toCharArray(), "JKS");
                keyStore.aliases();
            }
            catch (KeyStoreException keyStoreException) {
                assert (false);
            }
            catch (KeyStoreManagerException keyStoreManagerException) {
                assert (false);
            }
            catch (InvalidPasswordException invalidPasswordException) {
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
    }

    @Test
    public void testCreateCertificate() {
        block2: {
            try {
                KeyStore keyStore = KeyStoreUtils.loadKeystore(this.keyStoreFile, this.passwd.toCharArray(), "JKS");
                KeyPair keyPair = KeyStoreUtils.genKeyPair();
                X509Certificate x509Certificate = KeyStoreUtils.createX509Certificate(keyPair, new CertificateDetailsInfo("test", "nome", "org", "orgUn", "testUni", "country", "Estate", "30", ""));
                KeyStore.PrivateKeyEntry privateKeyEntry = KeyStoreUtils.createPrivateKeyEntry(keyPair, x509Certificate);
                KeyStoreUtils.addEntry(keyStore, this.passwd.toCharArray(), this.keyStoreFile, "aliasTest", privateKeyEntry, "aliaspass".toCharArray());
            }
            catch (Exception exception) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    @Test
    public void testChangePasswd() {
        File keyStoreFile2;
        KeyStore keyStore;
        block9: {
            block8: {
                keyStore = null;
                try {
                    keyStore = KeyStoreUtils.loadKeystore(this.keyStoreFile, this.passwd.toCharArray());
                }
                catch (KeyStoreManagerException keyStoreManagerException) {
                    assert (false);
                }
                catch (InvalidPasswordException invalidPasswordException) {
                    if ($assertionsDisabled) break block8;
                    throw new AssertionError();
                }
            }
            keyStoreFile2 = new File(this.keyStoreFile + "_2");
            try {
                KeyStoreUtils.changeKeystorePasswd(keyStore, keyStoreFile2, this.passwd.toCharArray(), "newPasswd2".toCharArray());
            }
            catch (KeyStoreManagerException keyStoreManagerException) {
                if ($assertionsDisabled) break block9;
                throw new AssertionError();
            }
        }
        assert (keyStore != null);
        assert (keyStoreFile2.length() > 0L);
    }

    @Test
    public void testChangeKsType() {
        try {
            KeyStoreUtils.createKeystore(this.keyStoreFile, "JKS", this.passwd.toCharArray());
            KeyStoreUtils.changeKeyStoreType(this.keyStoreFile, this.passwd.toCharArray(), "JKS", "JCEKS", new HashMap<String, String>(0));
        }
        catch (KeyStoreManagerException e) {
            e.printStackTrace();
        }
        catch (InvalidPasswordException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testImportKeys() {
        File keyStoreFile1 = new File(String.valueOf(this.keyStoreFile.getAbsolutePath()) + "_import");
        try {
            KeyStoreUtils.createKeystore(keyStoreFile1, "pass1".toCharArray());
        }
        catch (KeyStoreManagerException e) {
            e.printStackTrace();
        }
        catch (InvalidPasswordException e) {
            e.printStackTrace();
        }
        try {
            KeyStore keyStore = KeyStoreUtils.loadKeystore(this.keyStoreFile, this.passwd.toCharArray(), "JKS");
            KeyPair keyPair = KeyStoreUtils.genKeyPair();
            X509Certificate x509Certificate = KeyStoreUtils.createX509Certificate(keyPair, new CertificateDetailsInfo("test", "nome", "org", "orgUn", "testUni", "country", "Estate", "30", ""));
            KeyStore.PrivateKeyEntry privateKeyEntry = KeyStoreUtils.createPrivateKeyEntry(keyPair, x509Certificate);
            KeyStoreUtils.addEntry(keyStore, this.passwd.toCharArray(), this.keyStoreFile, "aliasTest", privateKeyEntry, this.passwd.toCharArray());
            keyStore = KeyStoreUtils.loadKeystore(this.keyStoreFile, this.passwd.toCharArray(), "JKS");
            HashMap<String, String> aliases = new HashMap<String, String>(1);
            aliases.put("aliasTest", this.passwd);
        }
        catch (KeyStoreManagerException e) {
            e.printStackTrace();
        }
        catch (InvalidPasswordException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (OperatorCreationException e) {
            e.printStackTrace();
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

