/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.certmanager.core;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Calendar;
import java.util.Map;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.X500NameStyle;
import org.bouncycastle.asn1.x500.style.BCStrictStyle;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.bc.BcRSAContentSignerBuilder;
import org.eclipse.andmore.android.certmanager.exception.InvalidPasswordException;
import org.eclipse.andmore.android.certmanager.exception.KeyStoreManagerException;
import org.eclipse.andmore.android.certmanager.i18n.CertificateManagerNLS;
import org.eclipse.andmore.android.certmanager.ui.model.CertificateDetailsInfo;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.common.utilities.FileUtil;
import org.eclipse.osgi.util.NLS;

public class KeyStoreUtils {
    private static final String ERROR_DELETING_ALIAS = CertificateManagerNLS.KeyStoreUtils_ErrorDeletingAlias;

    public static KeyStore createKeystore(File keyStoreFile, char[] password) throws KeyStoreManagerException, InvalidPasswordException {
        return KeyStoreUtils.createKeystore(keyStoreFile, KeyStore.getDefaultType(), password);
    }

    public static KeyStore createKeystore(File keyStoreFile, String keyStoreType, char[] password) throws KeyStoreManagerException, InvalidPasswordException {
        KeyStore keyStore = null;
        if (keyStoreFile != null && !keyStoreFile.exists()) {
            keyStore = KeyStoreUtils.loadKeystore(keyStoreFile, password, keyStoreType);
            try {
                KeyStoreUtils.writeKeyStore(keyStore, password, keyStoreFile);
            }
            catch (Exception e) {
                throw new KeyStoreManagerException(NLS.bind((String)CertificateManagerNLS.KeyStoreUtils_Error_WriteKeyStore, (Object)keyStoreFile), e);
            }
        } else {
            throw new KeyStoreManagerException(NLS.bind((String)CertificateManagerNLS.KeyStoreUtils_Error_FileAlreadyExists, (Object)keyStoreFile));
        }
        return keyStore;
    }

    public static void writeKeyStore(KeyStore keyStore, char[] password, File keyStoreFile) throws FileNotFoundException, KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, KeyStoreManagerException, InvalidPasswordException {
        KeyStoreUtils.writeKeyStore(keyStore, null, password, keyStoreFile);
    }

    private static void writeKeyStore(KeyStore keyStore, char[] oldPassword, char[] newPassword, File keyStoreFile) throws FileNotFoundException, KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, KeyStoreManagerException, InvalidPasswordException {
        FileOutputStream fos = null;
        try {
            if (oldPassword != null) {
                if (KeyStoreUtils.loadKeystore(keyStoreFile, oldPassword, keyStore.getType()) != null) {
                    fos = new FileOutputStream(keyStoreFile);
                    keyStore.store(fos, newPassword);
                }
            } else {
                fos = new FileOutputStream(keyStoreFile);
                keyStore.store(fos, newPassword);
            }
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    AndmoreLogger.error((String)("Could not close steam while writing keystore file. " + e.getMessage()));
                }
            }
        }
    }

    public static KeyStore loadKeystore(File keyStoreFile, char[] password) throws KeyStoreManagerException, InvalidPasswordException {
        return KeyStoreUtils.loadKeystore(keyStoreFile, password, KeyStore.getDefaultType());
    }

    public static KeyStore loadKeystore(File keyStoreFile, char[] password, String storeType) throws KeyStoreManagerException, InvalidPasswordException {
        KeyStore keyStore = null;
        FileInputStream fis = null;
        try {
            try {
                keyStore = KeyStore.getInstance(storeType);
                if (keyStoreFile != null && keyStoreFile.exists() && keyStoreFile.length() > 0L) {
                    fis = new FileInputStream(keyStoreFile);
                }
                keyStore.load(fis, password);
            }
            catch (IOException e) {
                if (e.getMessage().contains("password was incorrect") || e.getCause() instanceof UnrecoverableKeyException) {
                    throw new InvalidPasswordException(e.getMessage());
                }
                throw new KeyStoreManagerException(NLS.bind((String)CertificateManagerNLS.KeyStoreUtils_Error_LoadKeyStore, (Object)keyStoreFile), e);
            }
            catch (Exception e) {
                throw new KeyStoreManagerException(NLS.bind((String)CertificateManagerNLS.KeyStoreUtils_Error_LoadKeyStore, (Object)keyStoreFile), e);
            }
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    AndmoreLogger.error((String)("Could not close steam while loading keystore. " + e.getMessage()));
                }
            }
        }
        return keyStore;
    }

    public static void deleteKeystore(File keyStoreFile) throws KeyStoreManagerException {
        try {
            FileUtil.deleteFile((File)keyStoreFile);
        }
        catch (IOException e) {
            throw new KeyStoreManagerException(NLS.bind((String)CertificateManagerNLS.KeyStoreUtils_Error_DeleteKeyStore, (Object)keyStoreFile), e);
        }
    }

    public static void changeKeystorePasswd(KeyStore keyStore, File keyStoreFile, char[] oldPassword, char[] newPassword) throws KeyStoreManagerException {
        try {
            keyStore = KeyStoreUtils.loadKeystore(keyStoreFile, oldPassword, keyStore.getType());
            KeyStoreUtils.writeKeyStore(keyStore, oldPassword, newPassword, keyStoreFile);
        }
        catch (Exception e) {
            throw new KeyStoreManagerException(NLS.bind((String)CertificateManagerNLS.KeyStoreUtils_Error_WriteKeyStore, (Object)keyStoreFile), e);
        }
    }

    public static void addEntry(KeyStore keyStore, char[] keyStorePassword, File keyStoreFile, String alias, KeyStore.Entry entry, char[] entryPassword) throws KeyStoreManagerException {
        try {
            KeyStore.PasswordProtection passwordProtection = new KeyStore.PasswordProtection(entryPassword);
            keyStore = KeyStoreUtils.loadKeystore(keyStoreFile, keyStorePassword, keyStore.getType());
            if (keyStore.containsAlias(alias)) {
                throw new KeyStoreManagerException(NLS.bind((String)"Alias \"{0}\" already exists.", (Object)alias));
            }
            keyStore.setEntry(alias, entry, passwordProtection);
            KeyStoreUtils.writeKeyStore(keyStore, keyStorePassword, keyStoreFile);
        }
        catch (KeyStoreManagerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KeyStoreManagerException(NLS.bind((String)CertificateManagerNLS.KeyStoreUtils_Error_AddEntryToKeyStore, (Object)alias), e);
        }
    }

    public static void changeEntryPassword(KeyStore keyStore, char[] keyStorePassword, File keyStoreFile, String alias, KeyStore.Entry entry, char[] entryPassword) throws KeyStoreManagerException {
        try {
            KeyStore.PasswordProtection passwordProtection = new KeyStore.PasswordProtection(entryPassword);
            keyStore.setEntry(alias, entry, passwordProtection);
            KeyStoreUtils.writeKeyStore(keyStore, keyStorePassword, keyStoreFile);
        }
        catch (Exception e) {
            throw new KeyStoreManagerException(NLS.bind((String)"Error attempting to change password for {0}", (Object)alias), e);
        }
    }

    public static X509Certificate createX509Certificate(KeyPair keyPair, CertificateDetailsInfo certDetails) throws IOException, OperatorCreationException, CertificateException {
        PublicKey publicKey = keyPair.getPublic();
        PrivateKey privateKey = keyPair.getPrivate();
        if (!(publicKey instanceof RSAPublicKey) || !(privateKey instanceof RSAPrivateKey)) {
            throw new IllegalArgumentException(CertificateManagerNLS.KeyStoreUtils_RSA_Keys_Expected);
        }
        RSAPublicKey rsaPublicKey = (RSAPublicKey)publicKey;
        RSAPrivateKey rsaPrivateKey = (RSAPrivateKey)privateKey;
        ASN1InputStream asn1InputStream = null;
        X509Certificate x509Certificate = null;
        try {
            X500Name subjectName;
            asn1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(rsaPublicKey.getEncoded()));
            SubjectPublicKeyInfo pubKey = new SubjectPublicKeyInfo((ASN1Sequence)asn1InputStream.readObject());
            X500NameBuilder nameBuilder = new X500NameBuilder((X500NameStyle)new BCStrictStyle());
            KeyStoreUtils.addField(BCStyle.C, certDetails.getCountry(), nameBuilder);
            KeyStoreUtils.addField(BCStyle.ST, certDetails.getState(), nameBuilder);
            KeyStoreUtils.addField(BCStyle.L, certDetails.getLocality(), nameBuilder);
            KeyStoreUtils.addField(BCStyle.O, certDetails.getOrganization(), nameBuilder);
            KeyStoreUtils.addField(BCStyle.OU, certDetails.getOrganizationUnit(), nameBuilder);
            KeyStoreUtils.addField(BCStyle.CN, certDetails.getCommonName(), nameBuilder);
            X500Name issuerName = subjectName = nameBuilder.build();
            X509v3CertificateBuilder certBuilder = new X509v3CertificateBuilder(issuerName, BigInteger.valueOf(new SecureRandom().nextInt()), Calendar.getInstance().getTime(), certDetails.getExpirationDate(), subjectName, pubKey);
            AlgorithmIdentifier sigAlgId = new DefaultSignatureAlgorithmIdentifierFinder().find("SHA1withRSA");
            AlgorithmIdentifier digAlgId = new DefaultDigestAlgorithmIdentifierFinder().find(sigAlgId);
            BcRSAContentSignerBuilder sigGen = new BcRSAContentSignerBuilder(sigAlgId, digAlgId);
            RSAKeyParameters keyParams = new RSAKeyParameters(true, rsaPrivateKey.getPrivateExponent(), rsaPrivateKey.getModulus());
            ContentSigner contentSigner = sigGen.build((AsymmetricKeyParameter)keyParams);
            X509CertificateHolder certificateHolder = certBuilder.build(contentSigner);
            JcaX509CertificateConverter certConverter = new JcaX509CertificateConverter();
            x509Certificate = certConverter.getCertificate(certificateHolder);
        }
        finally {
            if (asn1InputStream != null) {
                try {
                    asn1InputStream.close();
                }
                catch (IOException e) {
                    AndmoreLogger.error((String)("Could not close stream while creating X509 certificate. " + e.getMessage()));
                }
            }
        }
        return x509Certificate;
    }

    private static void addField(ASN1ObjectIdentifier objectId, String value, X500NameBuilder nameBuilder) {
        if (value.length() > 0) {
            nameBuilder.addRDN(objectId, value);
        }
    }

    public static KeyPair genKeyPair() throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance("RSA");
        keyPairGen.initialize(2048);
        KeyPair keyPair = keyPairGen.genKeyPair();
        return keyPair;
    }

    public static KeyStore.PrivateKeyEntry createPrivateKeyEntry(KeyPair keyPair, X509Certificate x509Certificate) {
        Certificate[] certChain = new Certificate[]{x509Certificate};
        KeyStore.PrivateKeyEntry privateKeyEntry = new KeyStore.PrivateKeyEntry(keyPair.getPrivate(), certChain);
        return privateKeyEntry;
    }

    public static void deleteEntry(KeyStore keyStore, char[] password, File keyStoreFile, String alias) throws KeyStoreManagerException {
        try {
            keyStore = KeyStoreUtils.loadKeystore(keyStoreFile, password, keyStore.getType());
            keyStore.deleteEntry(alias);
            KeyStoreUtils.writeKeyStore(keyStore, password, keyStoreFile);
        }
        catch (Exception e) {
            AndmoreLogger.error(KeyStoreUtils.class, (String)(String.valueOf(ERROR_DELETING_ALIAS) + alias), (Throwable)e);
            throw new KeyStoreManagerException(String.valueOf(ERROR_DELETING_ALIAS) + alias, e);
        }
    }

    public static void changeKeyStoreType(File keyStoreFile, char[] password, String originalType, String destinationType, Map<String, String> aliases) throws KeyStoreManagerException, InvalidPasswordException {
        boolean rollBack = false;
        String timeStamp = Long.toString(Calendar.getInstance().getTimeInMillis());
        File oldKsFile = new File(String.valueOf(keyStoreFile.getAbsolutePath()) + "_" + timeStamp);
        oldKsFile.delete();
        boolean renamed = false;
        renamed = keyStoreFile.renameTo(oldKsFile);
        if (renamed) {
            try {
                KeyStore.Builder oldKsBuilder = KeyStore.Builder.newInstance(originalType, null, oldKsFile, new KeyStore.PasswordProtection(password));
                KeyStore oldKeyStore = oldKsBuilder.getKeyStore();
                KeyStore newKeyStore = KeyStoreUtils.createKeystore(keyStoreFile, destinationType, password);
                for (String alias : aliases.keySet()) {
                    KeyStore.PasswordProtection protectionParameter = new KeyStore.PasswordProtection(aliases.get(alias).toCharArray());
                    KeyStore.Entry entry = oldKeyStore.getEntry(alias, protectionParameter);
                    newKeyStore.setEntry(alias, entry, protectionParameter);
                }
                KeyStoreUtils.writeKeyStore(newKeyStore, password, keyStoreFile);
            }
            catch (InvalidPasswordException e) {
                rollBack = true;
                AndmoreLogger.error(KeyStoreUtils.class, (String)"Invalid password while trying to create a new keystore, changing a keyStore type.", (Throwable)((Object)e));
            }
            catch (Exception e) {
                if (e.getMessage().contains("password was incorrect") || e.getCause().getMessage().contains("password was incorrect")) {
                    keyStoreFile.delete();
                    oldKsFile.renameTo(keyStoreFile);
                    throw new InvalidPasswordException(e.getMessage());
                }
                AndmoreLogger.error(KeyStoreUtils.class, (String)"Exception occurred while attempting to change a keyStore type.", (Throwable)e);
                rollBack = true;
            }
            if (rollBack) {
                keyStoreFile.delete();
                oldKsFile.renameTo(keyStoreFile);
                throw new KeyStoreManagerException(NLS.bind((String)"Could not convert the KeyStore {0} to type {1}", (Object)keyStoreFile, (Object)destinationType));
            }
        } else {
            throw new KeyStoreManagerException(NLS.bind((String)"Could not convert the KeyStore {0} to type {1}, could not backup the current keyStore file, maybe it's in use by another program.", (Object)keyStoreFile, (Object)destinationType));
        }
        oldKsFile.delete();
    }

    public static void importKeys(KeyStore targetKeyStore, File targetFile, String targetType, char[] targetPasswd, KeyStore sourceKeyStore, File sourceKeyStoreFile, char[] sourcePasswd, Map<String, String> aliases) throws InvalidPasswordException, KeyStoreManagerException {
        if (!KeyStoreUtils.isValidKeyStorePasswd(targetFile, targetType, targetPasswd)) {
            throw new InvalidPasswordException(CertificateManagerNLS.PasswordChanged_InvalidKeystorePassword);
        }
        try {
            for (String alias : aliases.keySet()) {
                if (sourceKeyStore.containsAlias(alias)) {
                    KeyStore.PasswordProtection protectionParameter = new KeyStore.PasswordProtection(aliases.get(alias).toCharArray());
                    KeyStore.Entry entry = sourceKeyStore.getEntry(alias, protectionParameter);
                    if (targetKeyStore.containsAlias(alias)) {
                        alias = String.valueOf(alias) + "_" + sourceKeyStoreFile.getName();
                    }
                    int i = 1;
                    while (targetKeyStore.containsAlias(alias)) {
                        alias = String.valueOf(alias) + "_" + i;
                        ++i;
                    }
                    targetKeyStore.setEntry(alias, entry, protectionParameter);
                    continue;
                }
                AndmoreLogger.error(KeyStoreUtils.class, (String)NLS.bind((String)"Alias {0} could not be imported because it doesn't exists on originKeyStore", (Object)alias));
            }
            KeyStoreUtils.writeKeyStore(targetKeyStore, targetPasswd, targetFile);
        }
        catch (Exception e) {
            throw new KeyStoreManagerException("Could not import the selected aliases into " + targetFile.getName(), e);
        }
    }

    public static boolean isValidKeyStorePasswd(File keyStoreFile, String keyStoreType, char[] passwd) throws KeyStoreManagerException {
        KeyStore keystore = null;
        try {
            keystore = KeyStoreUtils.loadKeystore(keyStoreFile, passwd, keyStoreType);
        }
        catch (InvalidPasswordException invalidPasswordException) {}
        return keystore != null;
    }
}

