/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository.local;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.SystemImage;
import com.android.sdklib.io.FileOp;
import com.android.sdklib.io.IFileOp;
import com.android.sdklib.repository.MajorRevision;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.descriptors.IdDisplay;
import com.android.sdklib.repository.descriptors.PkgDesc;
import com.android.sdklib.repository.local.LocalPkgInfo;
import com.android.sdklib.repository.local.LocalSdk;
import com.android.sdklib.repository.local.PackageParserUtils;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

public class LocalSysImgPkgInfo
extends LocalPkgInfo {
    private final IPkgDesc mDesc;

    public LocalSysImgPkgInfo(LocalSdk localSdk, File localDir, Properties sourceProps, AndroidVersion version, IdDisplay tag, String abi, MajorRevision revision) {
        super(localSdk, localDir, sourceProps);
        this.mDesc = PkgDesc.Builder.newSysImg(version, tag, abi, revision).create();
    }

    @Override
    public IPkgDesc getDesc() {
        return this.mDesc;
    }

    public static IdDisplay extractTagFromProps(Properties props) {
        if (props != null) {
            String tagId = props.getProperty("SystemImage.TagId", SystemImage.DEFAULT_TAG.getId());
            String tagDisp = props.getProperty("SystemImage.TagDisplay", "");
            if (tagDisp == null || tagDisp.isEmpty()) {
                tagDisp = LocalSysImgPkgInfo.tagIdToDisplay(tagId);
            }
            assert (tagId != null);
            assert (tagDisp != null);
            return new IdDisplay(tagId, tagDisp);
        }
        return SystemImage.DEFAULT_TAG;
    }

    public static String tagIdToDisplay(String tagId) {
        char c;
        String name = tagId.replaceAll("[^A-Za-z0-9]+", " ");
        name = name.replaceAll(" +", " ");
        if (!(name = name.trim()).isEmpty() && !Character.isUpperCase(c = name.charAt(0))) {
            StringBuilder sb = new StringBuilder(name);
            sb.replace(0, 1, String.valueOf(c).toUpperCase(Locale.US));
            name = sb.toString();
        }
        return name;
    }

    public SystemImage getSystemImage() {
        return LocalSysImgPkgInfo.getSystemImage(this.mDesc, this.getLocalDir(), this.getLocalSdk().getFileOp());
    }

    static SystemImage getSystemImage(IPkgDesc desc, File localDir, IFileOp fileOp) {
        IdDisplay tag = desc.getTag();
        String abi = desc.getPath();
        List<File> parsedSkins = PackageParserUtils.parseSkinFolder(new File(localDir, "skins"), fileOp);
        File[] skins = FileOp.EMPTY_FILE_ARRAY;
        if (!parsedSkins.isEmpty()) {
            skins = parsedSkins.toArray(new File[parsedSkins.size()]);
        }
        return new SystemImage(localDir, ISystemImage.LocationType.IN_SYSTEM_IMAGE, tag, desc.getVendor(), abi, skins);
    }
}

