/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.api;

import com.android.ide.common.api.INode;
import com.android.ide.common.api.Rect;
import com.google.common.annotations.Beta;

@Beta
public final class SegmentType
extends Enum<SegmentType> {
    public static final /* enum */ SegmentType LEFT = new SegmentType();
    public static final /* enum */ SegmentType TOP = new SegmentType();
    public static final /* enum */ SegmentType RIGHT = new SegmentType();
    public static final /* enum */ SegmentType BOTTOM = new SegmentType();
    public static final /* enum */ SegmentType BASELINE = new SegmentType();
    public static final /* enum */ SegmentType CENTER_VERTICAL = new SegmentType();
    public static final /* enum */ SegmentType CENTER_HORIZONTAL = new SegmentType();
    public static final /* enum */ SegmentType UNKNOWN = new SegmentType();
    private static final /* synthetic */ SegmentType[] $VALUES;

    public static SegmentType[] values() {
        return (SegmentType[])$VALUES.clone();
    }

    public static SegmentType valueOf(String name) {
        return Enum.valueOf(SegmentType.class, name);
    }

    public boolean isHorizontal() {
        return this == TOP || this == BOTTOM || this == BASELINE || this == CENTER_HORIZONTAL;
    }

    public int getX(INode node, Rect bounds) {
        switch (this) {
            case RIGHT: {
                return bounds.x + bounds.w;
            }
            case TOP: 
            case BOTTOM: 
            case CENTER_VERTICAL: {
                return bounds.x + bounds.w / 2;
            }
            case UNKNOWN: {
                assert (false);
                return bounds.x;
            }
        }
        return bounds.x;
    }

    public int getY(INode node, Rect bounds) {
        switch (this) {
            case TOP: {
                return bounds.y;
            }
            case BOTTOM: {
                return bounds.y + bounds.h;
            }
            case BASELINE: {
                int baseline;
                int n = baseline = node != null ? node.getBaseline() : -1;
                if (node == null) {
                    baseline = (int)((float)bounds.h * 0.8f);
                }
                return bounds.y + baseline;
            }
            case UNKNOWN: {
                assert (false);
                return bounds.y;
            }
        }
        return bounds.y + bounds.h / 2;
    }

    public String toString() {
        return this.name();
    }

    static {
        $VALUES = new SegmentType[]{LEFT, TOP, RIGHT, BOTTOM, BASELINE, CENTER_VERTICAL, CENTER_HORIZONTAL, UNKNOWN};
    }
}

