/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.api;

import com.android.ide.common.api.IMenuCallback;
import com.android.ide.common.api.INode;
import com.android.utils.Pair;
import com.google.common.annotations.Beta;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

@Beta
public class RuleAction
implements Comparable<RuleAction> {
    public static final String CHOICE_SEP = "|";
    public static final String CHOICE_SEP_PATTERN = Pattern.quote("|");
    private final String mId;
    private final String mTitle;
    private URL mIconUrl;
    private final IMenuCallback mCallback;
    protected final int mSortPriority;
    private final boolean mSupportsMultipleNodes;
    public static final String SEPARATOR = "----";

    public static Separator createSeparator(int sortPriority) {
        return new Separator(sortPriority, true);
    }

    public static RuleAction createAction(String id, String title, IMenuCallback callback, URL iconUrl, int sortPriority, boolean supportsMultipleNodes) {
        RuleAction action = new RuleAction(id, title, callback, sortPriority, supportsMultipleNodes);
        action.setIconUrl(iconUrl);
        return action;
    }

    public static Toggle createToggle(String id, String title, boolean isChecked, IMenuCallback callback, URL iconUrl, int sortPriority, boolean supportsMultipleNodes) {
        Toggle toggle = new Toggle(id, title, isChecked, callback, sortPriority, supportsMultipleNodes);
        toggle.setIconUrl(iconUrl);
        return toggle;
    }

    public static NestedAction createChoices(String id, String title, IMenuCallback callback, URL iconUrl, int sortPriority, boolean supportsMultipleNodes, ActionProvider provider) {
        NestedAction choices = new NestedAction(id, title, provider, callback, sortPriority, supportsMultipleNodes);
        choices.setIconUrl(iconUrl);
        return choices;
    }

    public static Choices createChoices(String id, String title, IMenuCallback callback, List<String> titles, List<URL> iconUrls, List<String> ids, String current, URL iconUrl, int sortPriority, boolean supportsMultipleNodes) {
        Choices choices = new Choices(id, title, callback, titles, iconUrls, ids, current, sortPriority, supportsMultipleNodes);
        choices.setIconUrl(iconUrl);
        return choices;
    }

    public static Choices createChoices(String id, String title, IMenuCallback callback, List<URL> iconUrls, String current, URL iconUrl, int sortPriority, boolean supportsMultipleNodes, List<Pair<String, String>> idsAndTitles) {
        int itemCount = idsAndTitles.size();
        ArrayList<Object> titles = new ArrayList<Object>(itemCount);
        ArrayList<Object> ids = new ArrayList<Object>(itemCount);
        for (Pair<String, String> pair : idsAndTitles) {
            ids.add(pair.getFirst());
            titles.add(pair.getSecond());
        }
        Choices choices = new Choices(id, title, callback, titles, iconUrls, ids, current, sortPriority, supportsMultipleNodes);
        choices.setIconUrl(iconUrl);
        return choices;
    }

    public static Choices createChoices(String id, String title, IMenuCallback callback, ChoiceProvider provider, String current, URL iconUrl, int sortPriority, boolean supportsMultipleNodes) {
        DelayedChoices choices = new DelayedChoices(id, title, callback, current, provider, sortPriority, supportsMultipleNodes);
        choices.setIconUrl(iconUrl);
        return choices;
    }

    private RuleAction(String id, String title, IMenuCallback callback, int sortPriority, boolean supportsMultipleNodes) {
        this.mId = id;
        this.mTitle = title;
        this.mSortPriority = sortPriority;
        this.mSupportsMultipleNodes = supportsMultipleNodes;
        this.mCallback = callback;
    }

    public String getId() {
        return this.mId;
    }

    public String getTitle() {
        return this.mTitle;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RuleAction) {
            RuleAction rhs = (RuleAction)obj;
            if (!(this.mId == rhs.mId || this.mId != null && this.mId.equals(rhs.mId))) {
                return false;
            }
            return this.mTitle == rhs.mTitle || this.mTitle != null && this.mTitle.equals(rhs.mTitle);
        }
        return false;
    }

    public boolean supportsMultipleNodes() {
        return this.mSupportsMultipleNodes;
    }

    public int hashCode() {
        int h = this.mId == null ? 0 : this.mId.hashCode();
        return h ^= this.mTitle == null ? 0 : this.mTitle.hashCode();
    }

    public URL getIconUrl() {
        return this.mIconUrl;
    }

    public RuleAction setIconUrl(URL iconUrl) {
        this.mIconUrl = iconUrl;
        return this;
    }

    public int getSortPriority() {
        return this.mSortPriority;
    }

    public IMenuCallback getCallback() {
        return this.mCallback;
    }

    @Override
    public int compareTo(RuleAction other) {
        if (this.mSortPriority != other.mSortPriority) {
            return this.mSortPriority - other.mSortPriority;
        }
        return this.mTitle.compareTo(other.mTitle);
    }

    public String toString() {
        return "RuleAction [id=" + this.mId + ", title=" + this.mTitle + ", priority=" + this.mSortPriority + "]";
    }

    public static interface ChoiceProvider {
        public void addChoices(List<String> var1, List<URL> var2, List<String> var3);
    }

    public static interface ActionProvider {
        public List<RuleAction> getNestedActions(INode var1);
    }

    private static class DelayedChoices
    extends Choices {
        private final ChoiceProvider mProvider;
        private boolean mInitialized;

        private DelayedChoices(String id, String title, IMenuCallback callback, String current, ChoiceProvider provider, int sortPriority, boolean supportsMultipleNodes) {
            super(id, title, callback, new ArrayList(), new ArrayList(), new ArrayList(), current, sortPriority, supportsMultipleNodes);
            this.mProvider = provider;
        }

        private void ensureInitialized() {
            if (!this.mInitialized) {
                this.mInitialized = true;
                this.mProvider.addChoices(this.mTitles, this.mIconUrls, this.mIds);
            }
        }

        @Override
        public List<URL> getIconUrls() {
            this.ensureInitialized();
            return this.mIconUrls;
        }

        @Override
        public List<String> getIds() {
            this.ensureInitialized();
            return this.mIds;
        }

        @Override
        public List<String> getTitles() {
            this.ensureInitialized();
            return this.mTitles;
        }
    }

    public static class NestedAction
    extends RuleAction {
        private final ActionProvider mProvider;

        private NestedAction(String id, String title, ActionProvider provider, IMenuCallback callback, int sortPriority, boolean supportsMultipleNodes) {
            super(id, title, callback, sortPriority, supportsMultipleNodes);
            this.mProvider = provider;
        }

        public List<RuleAction> getNestedActions(INode node) {
            return this.mProvider.getNestedActions(node);
        }
    }

    public static class Choices
    extends RuleAction {
        protected List<String> mTitles;
        protected List<URL> mIconUrls;
        protected List<String> mIds;
        private boolean mRadio;
        protected final String mCurrent;

        private Choices(String id, String title, IMenuCallback callback, List<String> titles, List<URL> iconUrls, List<String> ids, String current, int sortPriority, boolean supportsMultipleNodes) {
            super(id, title, callback, sortPriority, supportsMultipleNodes);
            this.mTitles = titles;
            this.mIconUrls = iconUrls;
            this.mIds = ids;
            this.mCurrent = current;
        }

        public List<URL> getIconUrls() {
            return this.mIconUrls;
        }

        public List<String> getIds() {
            return this.mIds;
        }

        public List<String> getTitles() {
            return this.mTitles;
        }

        public String getCurrent() {
            return this.mCurrent;
        }

        public void setRadio(boolean radio) {
            this.mRadio = radio;
        }

        public boolean isRadio() {
            return this.mRadio;
        }
    }

    public static class Toggle
    extends RuleAction {
        private final boolean mIsChecked;

        private Toggle(String id, String title, boolean isChecked, IMenuCallback callback, int sortPriority, boolean supportsMultipleNodes) {
            super(id, title, callback, sortPriority, supportsMultipleNodes);
            this.mIsChecked = isChecked;
        }

        public boolean isChecked() {
            return this.mIsChecked;
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }

    public static class Separator
    extends RuleAction {
        private Separator(int sortPriority, boolean supportsMultipleNodes) {
            super("_separator", "", IMenuCallback.NONE, sortPriority, supportsMultipleNodes);
        }
    }
}

