/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.api;

import com.android.ide.common.api.Point;
import com.google.common.annotations.Beta;

@Beta
public class Rect {
    public int x;
    public int y;
    public int w;
    public int h;

    public Rect() {
    }

    public Rect(int x, int y, int w, int h) {
        this.set(x, y, w, h);
    }

    public Rect(Rect r) {
        this.set(r);
    }

    public Rect set(int x, int y, int w, int h) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
        return this;
    }

    public Rect set(Rect r) {
        this.set(r.x, r.y, r.w, r.h);
        return this;
    }

    public Rect copy() {
        return new Rect(this.x, this.y, this.w, this.h);
    }

    public boolean isValid() {
        return this.w > 0 && this.h > 0;
    }

    public boolean contains(int x, int y) {
        return this.isValid() && x >= this.x && y >= this.y && x < this.x + this.w && y < this.y + this.h;
    }

    public boolean intersects(Rect other) {
        if (other == null) {
            return false;
        }
        return this.x2() > other.x && other.x2() > this.x && this.y2() > other.y && other.y2() > this.y;
    }

    public boolean contains(Rect rect) {
        return rect != null && this.x <= rect.x && this.y <= rect.y && this.x2() >= rect.x2() && this.y2() >= rect.y2();
    }

    public boolean contains(Point p) {
        return p != null && this.contains(p.x, p.y);
    }

    public Rect moveTo(int x, int y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public Rect offsetBy(int x, int y) {
        this.x += x;
        this.y += y;
        return this;
    }

    public Point getCenter() {
        return new Point(this.x + (this.w > 0 ? this.w / 2 : 0), this.y + (this.h > 0 ? this.h / 2 : 0));
    }

    public Point getTopLeft() {
        return new Point(this.x, this.y);
    }

    public Point getBottomLeft() {
        return new Point(this.x, this.y + (this.h > 0 ? this.h : 0));
    }

    public Point getTopRight() {
        return new Point(this.x + (this.w > 0 ? this.w : 0), this.y);
    }

    public Point getBottomRight() {
        return new Point(this.x + (this.w > 0 ? this.w : 0), this.y + (this.h > 0 ? this.h : 0));
    }

    public int x2() {
        return this.x + this.w;
    }

    public int y2() {
        return this.y + this.h;
    }

    public int centerX() {
        return this.x + this.w / 2;
    }

    public int centerY() {
        return this.y + this.h / 2;
    }

    public String toString() {
        return String.format("Rect [(%d,%d)-(%d,%d): %dx%d]", this.x, this.y, this.x + this.w, this.y + this.h, this.w, this.h);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Rect) {
            Rect rhs = (Rect)obj;
            if (this.isValid() != rhs.isValid()) {
                return false;
            }
            if (!this.isValid() && !rhs.isValid()) {
                return true;
            }
            return this.x == rhs.x && this.y == rhs.y && this.w == rhs.w && this.h == rhs.h;
        }
        return false;
    }

    public int hashCode() {
        int hc = this.x;
        hc ^= this.y >> 8 & 0xFFFFFF | (this.y & 0xFF) << 24;
        hc ^= this.w >> 16 & 0xFFFF | (this.w & 0xFFFF) << 16;
        return hc ^= this.h >> 24 & 0xFF | (this.h & 0xFFFFFF) << 8;
    }

    public Point center() {
        return new Point(this.x + this.w / 2, this.y + this.h / 2);
    }
}

