/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.logger.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.PropertyConfigurator;
import org.eclipse.andmore.android.logger.Logger;
import org.eclipse.andmore.android.logger.internal.Activator;
import org.eclipse.andmore.android.logger.internal.EnvironmentManager;
import org.eclipse.andmore.android.logger.internal.VMEnvironmentManager;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public class EclipseEnvironmentManager
implements EnvironmentManager {
    private static final String CONFIGURATION = "configuration";
    public static final String PROPERTY = "logger.properties";
    public static final String DEFLOG_FILE = "log4j.appender.default.File";
    public static final String ENVLOG_FILE = "log4j.appender.envconf.File";

    @Override
    public void logEnvironment() {
        LinkedHashMap<String, String> log4jPropertiesMap = new LinkedHashMap<String, String>();
        Properties log4jProperties = new Properties();
        try {
            this.getExtensionsConfiguration(log4jPropertiesMap);
            this.getPlatformConfiguration(log4jPropertiesMap);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Set keys = log4jPropertiesMap.keySet();
        for (String key : keys) {
            log4jProperties.setProperty(key, (String)log4jPropertiesMap.get(key));
        }
        PropertyConfigurator.configure((Properties)log4jProperties);
        new VMEnvironmentManager().logEnvironment();
        Logger envLogger = Logger.getLogger("org.eclipse.andmore.environment");
        IBundleGroupProvider[] registry = Platform.getBundleGroupProviders();
        envLogger.info("--------------------------------------");
        envLogger.info("## Eclipse Plug-ins Log Information ##");
        envLogger.info("--------------------------------------");
        int i = 0;
        while (i < registry.length) {
            IBundleGroup[] bundleGroup = registry[i].getBundleGroups();
            int j = 0;
            while (j < bundleGroup.length) {
                Bundle[] bundles = bundleGroup[j].getBundles();
                int k = 0;
                while (k < bundles.length) {
                    Bundle bundle = bundles[k];
                    Dictionary values = bundle.getHeaders();
                    envLogger.info(String.valueOf(bundle.getSymbolicName()) + " - " + (String)values.get("Bundle-Version"));
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    private File getLogsFolder() {
        IPath workspacePath = Activator.getDefault().getStateLocation();
        File file = null;
        if (workspacePath != null) {
            file = workspacePath.toFile();
        }
        return file;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void getPlatformConfiguration(Map<String, String> log4jPropertiesMap) throws IOException {
        Activator activator = Activator.getDefault();
        if (activator == null) throw new RuntimeException("Could not get org.eclipse.andmore.android.logger activator.");
        URL bundleUrl = activator.getBundle().getEntry(PROPERTY);
        if (bundleUrl == null) throw new RuntimeException("Could not get logger.properties URL.");
        Properties props = new Properties();
        props.load(bundleUrl.openStream());
        File logs = this.getLogsFolder();
        if (!logs.exists()) {
            throw new RuntimeException("State folder does not exist.");
        }
        String logFileName = props.getProperty(DEFLOG_FILE);
        String envFileName = props.getProperty(ENVLOG_FILE);
        if (logFileName == null || envFileName == null) throw new RuntimeException("Logger property file is corrupted.");
        File logFile = new File(String.valueOf(logs.getAbsolutePath()) + File.separator + logFileName);
        File envFile = new File(String.valueOf(logs.getAbsolutePath()) + File.separator + envFileName);
        props.setProperty(DEFLOG_FILE, logFile.getAbsolutePath());
        props.setProperty(ENVLOG_FILE, envFile.getAbsolutePath());
        Enumeration<Object> keys = props.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = props.getProperty(key);
            if (value == null) continue;
            log4jPropertiesMap.put(key, value);
        }
    }

    private void getExtensionsConfiguration(Map<String, String> log4jPropertiesMap) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extPoint = registry.getExtensionPoint("org.eclipse.andmore.android.logger", CONFIGURATION);
        IExtension[] exts = extPoint.getExtensions();
        int i = 0;
        while (i < exts.length) {
            IExtension ext = exts[i];
            if (ext != null) {
                IConfigurationElement[] configuration = ext.getConfigurationElements();
                int j = 0;
                while (j < configuration.length) {
                    Bundle plugin;
                    String file;
                    IConfigurationElement config = configuration[j];
                    if (config != null && config.getName().equals(CONFIGURATION) && (file = config.getAttribute("file")) != null && file.length() > 0 && (plugin = Platform.getBundle((String)ext.getNamespaceIdentifier())) != null) {
                        URL url = plugin.getEntry(file);
                        if (url != null) {
                            Properties props;
                            block20: {
                                InputStream stream = null;
                                props = null;
                                try {
                                    try {
                                        stream = FileLocator.toFileURL((URL)url).openStream();
                                        props = new Properties();
                                        props.load(stream);
                                    }
                                    catch (IOException e) {
                                        Activator.getDefault().getLog().log((IStatus)new Status(2, ext.getNamespaceIdentifier(), 0, String.valueOf(ext.getNamespaceIdentifier()) + " can not be loaded, using default configuration.", (Throwable)e));
                                        try {
                                            stream.close();
                                        }
                                        catch (IOException e2) {
                                            e2.printStackTrace();
                                        }
                                        break block20;
                                    }
                                }
                                catch (Throwable throwable) {
                                    try {
                                        stream.close();
                                    }
                                    catch (IOException e) {
                                        e.printStackTrace();
                                    }
                                    throw throwable;
                                }
                                try {
                                    stream.close();
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                            if (props != null) {
                                Enumeration<Object> keys = props.keys();
                                while (keys.hasMoreElements()) {
                                    File customLogFile;
                                    File logs;
                                    String key = (String)keys.nextElement();
                                    String value = props.getProperty(key);
                                    if (key.startsWith("log4j.appender.") && key.endsWith(".File") && (logs = this.getLogsFolder()) != null && (customLogFile = new File(value = String.valueOf(logs.getAbsolutePath()) + File.separator + value)).exists()) {
                                        customLogFile.delete();
                                    }
                                    if (value == null) continue;
                                    log4jPropertiesMap.put(key, value);
                                }
                            }
                        } else {
                            Activator.getDefault().getLog().log((IStatus)new Status(2, ext.getNamespaceIdentifier(), 0, "Could not load " + file + " from " + ext.getNamespaceIdentifier() + " plugin.", null));
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }
}

