/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.vnc.protocol.lib.internal.engine;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.sequoyah.device.common.utilities.BasePlugin;
import org.eclipse.sequoyah.vnc.protocol.lib.IMessageHandler;
import org.eclipse.sequoyah.vnc.protocol.lib.IProtocolExceptionHandler;
import org.eclipse.sequoyah.vnc.protocol.lib.IProtocolHandshake;
import org.eclipse.sequoyah.vnc.protocol.lib.ProtocolHandle;
import org.eclipse.sequoyah.vnc.protocol.lib.ProtocolMessage;
import org.eclipse.sequoyah.vnc.protocol.lib.exceptions.InvalidDefinitionException;
import org.eclipse.sequoyah.vnc.protocol.lib.exceptions.InvalidInputStreamDataException;
import org.eclipse.sequoyah.vnc.protocol.lib.exceptions.InvalidMessageException;
import org.eclipse.sequoyah.vnc.protocol.lib.exceptions.MessageHandleException;
import org.eclipse.sequoyah.vnc.protocol.lib.exceptions.ProtocolHandshakeException;
import org.eclipse.sequoyah.vnc.protocol.lib.exceptions.ProtocolRawHandlingException;
import org.eclipse.sequoyah.vnc.protocol.lib.internal.engine.MessageReader;
import org.eclipse.sequoyah.vnc.protocol.lib.internal.engine.MessageWriter;
import org.eclipse.sequoyah.vnc.protocol.lib.internal.engine.NioDataInput;
import org.eclipse.sequoyah.vnc.protocol.lib.internal.engine.NioOutputStream;
import org.eclipse.sequoyah.vnc.protocol.lib.msgdef.ProtocolMsgDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtocolEngine {
    private static final int RECONNECTION_MAX = 5;
    private static int engineEventCounter = 0;
    private static int consumerCounter = 0;
    private boolean isBigEndianProtocol;
    private ProtocolHandle handle;
    private Map<Long, ProtocolMsgDefinition> messageDefCollection;
    private int retries;
    private int retriesMax = 5;
    private int connectionSerialNumber = 0;
    private Collection<String> incomingMessages;
    private Collection<String> outgoingMessages;
    private IProtocolHandshake initProcedure;
    private IProtocolExceptionHandler exceptionHandler;
    private SocketChannel sockChannel;
    private String host;
    private Map<?, ?> parameters;
    private int port = -1;
    private int timeout = -1;
    private boolean isServer;
    private NioDataInput in;
    private OutputStream out;
    private Consumer consumer;
    private EngineEventHandler eventHandler = new EngineEventHandler();

    public ProtocolEngine(ProtocolHandle protocolHandle, IProtocolHandshake iProtocolHandshake, Map<Long, ProtocolMsgDefinition> map, Collection<String> collection, Collection<String> collection2, IProtocolExceptionHandler iProtocolExceptionHandler, boolean bl, boolean bl2, int n) {
        BasePlugin.logDebugMessage((String)"ProtocolEngine", (String)"A protocol engine is being created.");
        this.handle = protocolHandle;
        this.initProcedure = iProtocolHandshake;
        this.messageDefCollection = map;
        this.incomingMessages = collection;
        this.outgoingMessages = collection2;
        this.exceptionHandler = iProtocolExceptionHandler;
        this.isBigEndianProtocol = bl;
        this.isServer = bl2;
        this.retries = this.retriesMax = n >= 0 ? n : 5;
        new Thread((Runnable)this.eventHandler, "Protocol Event Handler-" + ++engineEventCounter).start();
    }

    public void dispose() {
        BasePlugin.logInfo((String)"The protocol engine is being disposed.");
        if (this.consumer != null) {
            this.consumer.stopConsumer();
            this.consumer = null;
        }
        if (this.eventHandler != null) {
            this.eventHandler.stopEventHandler();
            this.eventHandler = null;
        }
    }

    public void requestStart(String string, int n, Map<?, ?> map) {
        this.requestStart(string, n, map, -1);
    }

    public void requestStart(String string, int n, Map<?, ?> map, int n2) {
        String string2 = string != null ? string : this.host;
        int n3 = n != -1 ? n : this.port;
        Map<?, ?> map2 = map != null ? map : this.parameters;
        int n4 = n2 != -1 ? n2 : this.timeout;
        this.eventHandler.requestStart(this.sockChannel, string2, n3, n4, map2);
    }

    public void requestStart(SocketChannel socketChannel, Map<?, ?> map) {
        SocketChannel socketChannel2 = socketChannel != null ? socketChannel : this.sockChannel;
        String string = socketChannel2.socket().getInetAddress().getHostAddress();
        int n = socketChannel2.socket().getPort();
        Map<?, ?> map2 = map != null ? map : this.parameters;
        this.eventHandler.requestStart(socketChannel2, string, n, -1, map2);
    }

    private void doStartProtocol() throws ProtocolHandshakeException, IOException {
        if (!this.isRunning()) {
            Object object;
            BasePlugin.logInfo((String)"Starting protocol.");
            if (this.sockChannel == null) {
                object = new InetSocketAddress(this.host, this.port);
                this.sockChannel = SocketChannel.open((SocketAddress)object);
            }
            this.sockChannel.configureBlocking(false);
            this.in = new NioDataInput(this.sockChannel);
            this.out = new NioOutputStream(this.sockChannel);
            if (this.initProcedure != null) {
                if (this.isServer) {
                    this.initProcedure.serverHandshake(this.handle, this.in, this.out, this.parameters);
                } else {
                    this.initProcedure.clientHandshake(this.handle, this.in, this.out, this.parameters);
                }
                BasePlugin.logInfo((String)"Handshake is finished.");
                this.consumer = new Consumer();
                object = new Thread((Runnable)this.consumer, "Consumer-" + ++consumerCounter);
                ((Thread)object).start();
                this.retries = this.retriesMax;
                ++this.connectionSerialNumber;
            } else {
                BasePlugin.logWarning((String)"Handshake handler is not available. No handshake performed.");
            }
            BasePlugin.logInfo((String)"Protocol started.");
        }
    }

    public void requestStop() {
        this.eventHandler.requestStop();
    }

    private void doStopProtocol() throws IOException {
        if (this.isConnected()) {
            BasePlugin.logInfo((String)"Stopping protocol.");
            if (this.consumer != null) {
                this.consumer.stopConsumer();
                this.consumer = null;
            }
            if (this.sockChannel != null) {
                this.sockChannel.close();
                this.sockChannel = null;
            }
            if (this.in != null) {
                this.in.close();
                this.in = null;
            }
            if (this.out != null) {
                this.out.close();
                this.out = null;
            }
            BasePlugin.logInfo((String)"Protocol stopped.");
        }
    }

    public void requestRestart() {
        this.eventHandler.requestRestart();
    }

    public boolean isConnected() {
        boolean bl = false;
        if (this.sockChannel != null && this.sockChannel.isConnected()) {
            bl = true;
        }
        return bl;
    }

    public boolean isRunning() {
        return this.isConnected() && this.consumer != null && this.consumer.isRunning();
    }

    public void requestSendMessage(ProtocolMessage protocolMessage) {
        if (protocolMessage != null) {
            this.eventHandler.queueMessage(protocolMessage);
        }
    }

    Collection<String> getIncomingMessages() {
        return this.incomingMessages;
    }

    Collection<String> getOutgoingMessages() {
        return this.outgoingMessages;
    }

    ProtocolHandle getHandle() {
        return this.handle;
    }

    boolean isBigEndianProtocol() {
        return this.isBigEndianProtocol;
    }

    ProtocolMsgDefinition getDefinitionByCode(long l) {
        return this.messageDefCollection.get(l);
    }

    private class Consumer
    implements Runnable {
        private boolean isRunning = false;

        private Consumer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            BasePlugin.logInfo((String)"Starting consumer.");
            long l = 0L;
            this.isRunning = true;
            while (this.isRunning) {
                try {
                    try {
                        if (l > 0x3FFFFFFFFFFFFFFFL) {
                            BasePlugin.logError((String)"Message not found. Stopping protocol...");
                            ProtocolEngine.this.requestRestart();
                            this.isRunning = false;
                            continue;
                        }
                        byte by = ProtocolEngine.this.in.readByte(false);
                        l <<= 8;
                        long l2 = ProtocolEngine.this.isServer ? l : -(l += (long)by);
                        ProtocolMsgDefinition protocolMsgDefinition = (ProtocolMsgDefinition)ProtocolEngine.this.messageDefCollection.get(l2);
                        if (protocolMsgDefinition == null) continue;
                        if (ProtocolEngine.this.in != null) {
                            NioDataInput nioDataInput = ProtocolEngine.this.in;
                            synchronized (nioDataInput) {
                                IMessageHandler iMessageHandler = protocolMsgDefinition.getHandler();
                                ProtocolMessage protocolMessage = MessageReader.readReceivedMessage(ProtocolEngine.this.in, l2, protocolMsgDefinition, ProtocolEngine.this);
                                ProtocolMessage protocolMessage2 = iMessageHandler.handleMessage(ProtocolEngine.this.handle, protocolMessage);
                                if (protocolMessage2 != null) {
                                    ProtocolEngine.this.requestSendMessage(protocolMessage2);
                                }
                            }
                        }
                        l = 0L;
                    }
                    catch (IOException iOException) {
                        if (!this.isRunning) continue;
                        BasePlugin.logError((String)"Socket disconnection was detected. Stopping consumer.");
                        this.isRunning = false;
                        if (ProtocolEngine.this.exceptionHandler == null) continue;
                        BasePlugin.logInfo((String)"An user exception handler is available. Delegating exception to the handler.");
                        ProtocolEngine.this.exceptionHandler.handleIOException(ProtocolEngine.this.handle, iOException);
                    }
                    catch (Exception exception) {
                        BasePlugin.logError((String)("A protocol related error happened. Stopping consumer. Cause: " + exception.getMessage()));
                        this.isRunning = false;
                        if (ProtocolEngine.this.exceptionHandler == null) continue;
                        BasePlugin.logInfo((String)"An user exception handler is available. Delegating exception to the handler.");
                        if (exception instanceof ProtocolHandshakeException) {
                            ProtocolEngine.this.exceptionHandler.handleProtocolHandshakeException(ProtocolEngine.this.handle, (ProtocolHandshakeException)exception);
                            continue;
                        }
                        if (exception instanceof MessageHandleException) {
                            ProtocolEngine.this.exceptionHandler.handleMessageHandleException(ProtocolEngine.this.handle, (MessageHandleException)exception);
                            continue;
                        }
                        if (exception instanceof InvalidMessageException) {
                            ProtocolEngine.this.exceptionHandler.handleInvalidMessageException(ProtocolEngine.this.handle, (InvalidMessageException)exception);
                            continue;
                        }
                        if (exception instanceof InvalidInputStreamDataException) {
                            ProtocolEngine.this.exceptionHandler.handleInvalidInputStreamDataException(ProtocolEngine.this.handle, (InvalidInputStreamDataException)exception);
                            continue;
                        }
                        if (exception instanceof InvalidDefinitionException) {
                            ProtocolEngine.this.exceptionHandler.handleInvalidDefinitionException(ProtocolEngine.this.handle, (InvalidDefinitionException)exception);
                            continue;
                        }
                        if (!(exception instanceof ProtocolRawHandlingException)) continue;
                        ProtocolEngine.this.exceptionHandler.handleProtocolRawHandlingException(ProtocolEngine.this.handle, (ProtocolRawHandlingException)exception);
                    }
                }
                catch (Throwable throwable) {
                    BasePlugin.logError((String)"One unhandled error occurred in consumer thread. Restarting the protocol...");
                    ProtocolEngine.this.requestRestart();
                    this.isRunning = false;
                }
            }
            BasePlugin.logInfo((String)"Consumer stopped.");
        }

        public void stopConsumer() {
            BasePlugin.logDebugMessage((String)"Consumer", (String)"Stopping consumer");
            this.isRunning = false;
        }

        public boolean isRunning() {
            return this.isRunning;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EngineEventHandler
    implements Runnable {
        private boolean isRunning = true;
        private boolean restartRequested = false;
        private boolean startRequested = false;
        private boolean stopRequested = false;
        private Queue<ProtocolMessage> messagesToSend = new ConcurrentLinkedQueue<ProtocolMessage>();
        private SocketChannel nextChannel = null;
        private String nextHost = null;
        private int nextPort = -1;
        private int nextTimeout = -1;
        private Map<?, ?> nextParameters = null;

        private EngineEventHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BasePlugin.logInfo((String)"Starting engine event handler.");
            ProtocolMessage protocolMessage = null;
            while (this.isRunning) {
                try {
                    block33: {
                        Object object = this.messagesToSend;
                        synchronized (object) {
                            if (!this.startRequested && !this.stopRequested && !this.restartRequested && this.messagesToSend.isEmpty()) {
                                try {
                                    this.messagesToSend.wait();
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                            if (!this.messagesToSend.isEmpty()) {
                                protocolMessage = this.messagesToSend.poll();
                            }
                        }
                        try {
                            if (this.startRequested) {
                                this.startRequested = false;
                                this.messagesToSend.clear();
                                ProtocolEngine.this.sockChannel = this.nextChannel;
                                ProtocolEngine.this.host = this.nextHost;
                                ProtocolEngine.this.port = this.nextPort;
                                ProtocolEngine.this.timeout = this.nextTimeout;
                                ProtocolEngine.this.parameters = this.nextParameters;
                                ProtocolEngine.this.doStartProtocol();
                                break block33;
                            }
                            if (this.stopRequested) {
                                this.stopRequested = false;
                                this.messagesToSend.clear();
                                ProtocolEngine.this.doStopProtocol();
                                this.stopEventHandler();
                                break block33;
                            }
                            if (!this.restartRequested) break block33;
                            this.restartRequested = false;
                            this.messagesToSend.clear();
                            object = this;
                            synchronized (object) {
                                int n = ProtocolEngine.this.connectionSerialNumber;
                                while (ProtocolEngine.this.connectionSerialNumber == n && ProtocolEngine.this.retries >= 0) {
                                    try {
                                        if (ProtocolEngine.this.isConnected() || ProtocolEngine.this.isRunning()) {
                                            ProtocolEngine.this.doStopProtocol();
                                        }
                                        if (ProtocolEngine.this.isConnected()) continue;
                                        ProtocolEngine.this.doStartProtocol();
                                    }
                                    catch (Exception exception) {
                                        ProtocolEngine protocolEngine = ProtocolEngine.this;
                                        protocolEngine.retries = protocolEngine.retries - 1;
                                        if (ProtocolEngine.this.retries >= 0) continue;
                                        BasePlugin.logError((String)"Number of connection retries exceeded the limit.");
                                        ProtocolEngine.this.retries = ProtocolEngine.this.retriesMax;
                                        throw exception;
                                    }
                                }
                            }
                        }
                        catch (Exception exception) {
                            try {
                                ProtocolEngine.this.doStopProtocol();
                            }
                            catch (IOException iOException) {}
                            if (ProtocolEngine.this.exceptionHandler != null) {
                                if (exception instanceof ProtocolHandshakeException) {
                                    ProtocolEngine.this.exceptionHandler.handleProtocolHandshakeException(ProtocolEngine.this.handle, (ProtocolHandshakeException)exception);
                                }
                                if (exception instanceof IOException) {
                                    ProtocolEngine.this.exceptionHandler.handleIOException(ProtocolEngine.this.handle, (IOException)exception);
                                }
                                throw exception;
                            }
                            throw exception;
                        }
                    }
                    if (!ProtocolEngine.this.isConnected() || protocolMessage == null) continue;
                    try {
                        MessageWriter.doSendMessage(ProtocolEngine.this.out, protocolMessage, ProtocolEngine.this);
                        protocolMessage = null;
                    }
                    catch (Exception exception) {
                        if (ProtocolEngine.this.exceptionHandler != null) {
                            if (exception instanceof ProtocolRawHandlingException) {
                                ProtocolEngine.this.exceptionHandler.handleProtocolRawHandlingException(ProtocolEngine.this.handle, (ProtocolRawHandlingException)exception);
                                continue;
                            }
                            if (exception instanceof InvalidMessageException) {
                                ProtocolEngine.this.exceptionHandler.handleInvalidMessageException(ProtocolEngine.this.handle, (InvalidMessageException)exception);
                                continue;
                            }
                            if (exception instanceof InvalidDefinitionException) {
                                ProtocolEngine.this.exceptionHandler.handleInvalidDefinitionException(ProtocolEngine.this.handle, (InvalidDefinitionException)exception);
                                continue;
                            }
                            if (exception instanceof IOException) {
                                ProtocolEngine.this.exceptionHandler.handleIOException(ProtocolEngine.this.handle, (IOException)exception);
                                continue;
                            }
                            throw exception;
                        }
                        throw exception;
                    }
                }
                catch (Throwable throwable) {
                    BasePlugin.logWarning((String)"One unhandled error occurred in event handler thread.");
                }
            }
            BasePlugin.logInfo((String)"Engine event handler stopped.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void queueMessage(ProtocolMessage protocolMessage) {
            Queue<ProtocolMessage> queue = this.messagesToSend;
            synchronized (queue) {
                this.messagesToSend.offer(protocolMessage);
                this.messagesToSend.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestRestart() {
            Queue<ProtocolMessage> queue = this.messagesToSend;
            synchronized (queue) {
                BasePlugin.logDebugMessage((String)"EngineEventHandler", (String)"A restart was requested.");
                this.restartRequested = true;
                this.messagesToSend.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestStart(SocketChannel socketChannel, String string, int n, int n2, Map<?, ?> map) {
            Queue<ProtocolMessage> queue = this.messagesToSend;
            synchronized (queue) {
                BasePlugin.logDebugMessage((String)"EngineEventHandler", (String)("A start was requested. Host=" + string + "; Port=" + n + "; Channel=" + (socketChannel != null ? "available" : "none")));
                this.nextChannel = socketChannel;
                this.nextHost = string;
                this.nextPort = n;
                this.nextTimeout = n2;
                this.nextParameters = map;
                this.startRequested = true;
                this.messagesToSend.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestStop() {
            Queue<ProtocolMessage> queue = this.messagesToSend;
            synchronized (queue) {
                BasePlugin.logDebugMessage((String)"EngineEventHandler", (String)"A stop was requested.");
                this.stopRequested = true;
                this.messagesToSend.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopEventHandler() {
            BasePlugin.logDebugMessage((String)"EngineEventHandler", (String)"Stopping engine event handler.");
            this.isRunning = false;
            Queue<ProtocolMessage> queue = this.messagesToSend;
            synchronized (queue) {
                this.messagesToSend.notify();
            }
        }
    }
}

