/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.vnc.protocol.lib.internal.engine;

import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.eclipse.sequoyah.device.common.utilities.BasePlugin;

public class NioDataInput
implements DataInput {
    private static final int IN_STREAM_TIMEOUT_MS = 3000;
    private static final int BUFFER_SIZE = 102400;
    private SocketChannel channel;
    private ByteBuffer buffer;

    NioDataInput(SocketChannel socketChannel) {
        this.channel = socketChannel;
        this.buffer = ByteBuffer.allocate(102400);
        this.buffer.flip();
    }

    byte[] close() throws IOException {
        byte[] byArray = null;
        if (this.channel != null) {
            this.channel.close();
        }
        if (this.buffer != null) {
            int n = this.buffer.remaining();
            byArray = new byte[n];
            this.buffer.get(byArray);
        }
        return byArray;
    }

    public boolean readBoolean() throws IOException {
        byte[] byArray = this.getBytesFromBuffer(1);
        return byArray[0] != 0;
    }

    public byte readByte() throws IOException {
        return this.readByte(true);
    }

    byte readByte(boolean bl) throws IOException {
        int[] nArray = this.asIntArray(this.getBytesFromBuffer(1, bl));
        return (byte)nArray[0];
    }

    public char readChar() throws IOException {
        int[] nArray = this.asIntArray(this.getBytesFromBuffer(2));
        return (char)((nArray[0] << 8) + (nArray[1] << 0));
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        byte[] byArray2 = this.getBytesFromBuffer(n2 - n);
        System.arraycopy(byArray2, 0, byArray, n, n2);
    }

    public int readInt() throws IOException {
        int[] nArray = this.asIntArray(this.getBytesFromBuffer(4));
        return (nArray[0] << 24) + (nArray[1] << 16) + (nArray[2] << 8) + (nArray[3] << 0);
    }

    public String readLine() throws IOException {
        int n;
        char[] cArray;
        block8: {
            boolean bl = false;
            cArray = new char[128];
            int n2 = cArray.length;
            n = 0;
            try {
                block6: while (!bl) {
                    int n3 = this.readUnsignedByte();
                    switch (n3) {
                        case 10: {
                            bl = true;
                            continue block6;
                        }
                        case 13: {
                            continue block6;
                        }
                    }
                    if (--n2 < 0) {
                        char[] cArray2 = cArray;
                        cArray = new char[n + 128];
                        n2 = cArray.length - n - 1;
                        System.arraycopy(cArray2, 0, cArray, 0, n);
                    }
                    cArray[n++] = (char)n3;
                }
            }
            catch (EOFException eOFException) {
                if (n != 0) break block8;
                return null;
            }
        }
        return String.copyValueOf(cArray, 0, n);
    }

    public long readLong() throws IOException {
        byte[] byArray = this.getBytesFromBuffer(8);
        return ((long)byArray[0] << 56) + ((long)(byArray[1] & 0xFF) << 48) + ((long)(byArray[2] & 0xFF) << 40) + ((long)(byArray[3] & 0xFF) << 32) + ((long)(byArray[4] & 0xFF) << 24) + (long)((byArray[5] & 0xFF) << 16) + (long)((byArray[6] & 0xFF) << 8) + (long)((byArray[7] & 0xFF) << 0);
    }

    public short readShort() throws IOException {
        int[] nArray = this.asIntArray(this.getBytesFromBuffer(2));
        return (short)((nArray[0] << 8) + (nArray[1] << 0));
    }

    public String readUTF() throws IOException {
        return "";
    }

    public int readUnsignedByte() throws IOException {
        int[] nArray = this.asIntArray(this.getBytesFromBuffer(1));
        return nArray[0];
    }

    public int readUnsignedShort() throws IOException {
        int[] nArray = this.asIntArray(this.getBytesFromBuffer(2));
        return (nArray[0] << 8) + (nArray[1] << 0);
    }

    public int skipBytes(int n) throws IOException {
        int n2 = 0;
        try {
            n2 = 0;
            while (n2 < n) {
                this.getBytesFromBuffer(1);
                ++n2;
            }
        }
        catch (EOFException eOFException) {}
        return n2;
    }

    private byte[] getBytesFromBuffer(int n) throws IOException {
        return this.getBytesFromBuffer(n, true);
    }

    private byte[] getBytesFromBuffer(int n, boolean bl) throws IOException {
        byte[] byArray = new byte[n];
        boolean bl2 = false;
        int n2 = 0;
        int n3 = n;
        while (!bl2) {
            int n4 = Math.min(n3, this.buffer.remaining());
            this.buffer.get(byArray, n2, n4);
            n3 -= n4;
            if ((n2 += n4) >= n) {
                bl2 = true;
                continue;
            }
            this.fillBuffer(byArray.length - n2, bl);
        }
        return byArray;
    }

    private void fillBuffer(int n, boolean bl) throws IOException {
        this.buffer.clear();
        long l = System.currentTimeMillis();
        while (this.buffer.remaining() > 0 && this.buffer.position() < n) {
            int n2 = this.channel.read(this.buffer);
            if (n2 <= 0) {
                if (bl && System.currentTimeMillis() > l + 3000L) {
                    BasePlugin.logError((String)"No data arrived through the input stream channel for 3000 milliseconds. Timeout expired.");
                    this.buffer.flip();
                    throw new EOFException("Timeout on communication detected!");
                }
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            l = System.currentTimeMillis();
        }
        this.buffer.flip();
    }

    private int[] asIntArray(byte[] byArray) {
        int[] nArray = new int[byArray.length];
        int n = 0;
        while (n < byArray.length) {
            nArray[n] = byArray[n] & 0xFF;
            ++n;
        }
        return nArray;
    }
}

