/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.vnc.protocol.internal.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.sequoyah.vnc.protocol.exceptions.MalformedProtocolExtensionException;
import org.eclipse.sequoyah.vnc.protocol.internal.model.ProtocolBean;
import org.eclipse.sequoyah.vnc.protocol.internal.reader.ProtocolExtensionsReader;
import org.eclipse.sequoyah.vnc.protocol.lib.IProtocolHandshake;
import org.eclipse.sequoyah.vnc.protocol.lib.msgdef.ProtocolMsgDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginProtocolModel {
    private static PluginProtocolModel instance;
    private Map<String, ProtocolBean> protocolDataMap = new HashMap<String, ProtocolBean>();
    private Map<String, Map<Long, ProtocolMsgDefinition>> allMessagesMap = new HashMap<String, Map<Long, ProtocolMsgDefinition>>();
    private Map<String, Collection<String>> serverMessagesMap = new HashMap<String, Collection<String>>();
    private Map<String, Collection<String>> clientMessagesMap = new HashMap<String, Collection<String>>();

    private PluginProtocolModel() {
    }

    public static PluginProtocolModel getInstance() {
        if (instance == null) {
            instance = new PluginProtocolModel();
        }
        return instance;
    }

    public boolean isBigEndianProtocol(String string) throws MalformedProtocolExtensionException {
        ProtocolBean protocolBean = this.protocolDataMap.get(string);
        if (protocolBean == null) {
            protocolBean = ProtocolExtensionsReader.readProtocolImplDef(string);
            this.protocolDataMap.put(string, protocolBean);
        }
        return protocolBean.isBigEndianProtocol();
    }

    public IProtocolHandshake getProtocolInit(String string) throws MalformedProtocolExtensionException {
        ProtocolBean protocolBean = this.protocolDataMap.get(string);
        if (protocolBean == null) {
            protocolBean = ProtocolExtensionsReader.readProtocolImplDef(string);
            this.protocolDataMap.put(string, protocolBean);
        }
        return protocolBean.getProtocolInit();
    }

    public Map<Long, ProtocolMsgDefinition> getAllProtocolMessages(String string) throws MalformedProtocolExtensionException {
        Map<Long, ProtocolMsgDefinition> map = this.allMessagesMap.get(string);
        if (map == null) {
            map = ProtocolExtensionsReader.readMessageDefinitions(string);
            this.allMessagesMap.put(string, map);
        }
        return map;
    }

    public Collection<String> getClientMessages(String string) {
        Collection<String> collection = this.clientMessagesMap.get(string);
        if (collection == null) {
            collection = ProtocolExtensionsReader.readClientMessages(string);
            this.clientMessagesMap.put(string, collection);
        }
        return collection;
    }

    public Collection<String> getServerMessages(String string) {
        Collection<String> collection = this.serverMessagesMap.get(string);
        if (collection == null) {
            collection = ProtocolExtensionsReader.readServerMessages(string);
            this.serverMessagesMap.put(string, collection);
        }
        return collection;
    }
}

