/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.localization.tools.managers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.sequoyah.localization.tools.LocalizationToolsPlugin;
import org.eclipse.sequoyah.localization.tools.managers.ProjectLocalizationManager;

public class ProjectPreferencesManager {
    private IProject project;
    private final String DEFAULT_LANGUAGE = "en";
    private Map<String, String> defaultLanguageForColumn = new HashMap<String, String>();
    private IPreferenceStore preferenceStore = null;
    private final String PREFERENCE_KEY_SUFFIX = "_DEFAULTLANGUAGES";
    private final String NODE_SEPARATOR = ",";
    private final String FIELD_SEPARATOR = ":";
    private ProjectLocalizationManager projectLocalizationManager;
    private boolean metadataEnabled;

    public ProjectPreferencesManager(IProject iProject) {
        this.project = iProject;
        this.preferenceStore = LocalizationToolsPlugin.getDefault().getPreferenceStore();
        this.load();
    }

    public String getDefaultLanguage() {
        return "en";
    }

    public String getDefaultLanguageForColumn(String string) {
        String string2 = this.defaultLanguageForColumn.get(string);
        if (string2 == null) {
            string2 = this.getDefaultLanguage();
        }
        return string2;
    }

    public void setDefaultLanguageForColumn(String string, String string2) {
        this.defaultLanguageForColumn.put(string, string2);
        this.save();
    }

    private void cleanLanguageInfoForColumn(String string) {
        this.defaultLanguageForColumn.remove(string);
        this.save();
    }

    public void clearDataForFile(IFile iFile) {
    }

    private void cleanInfoForInexistentColumns(String[] stringArray) {
        List<String> list = Arrays.asList(stringArray);
        Set<String> set = this.defaultLanguageForColumn.keySet();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : set) {
            if (list.contains(string)) continue;
            arrayList.add(string);
        }
        for (String string : arrayList) {
            this.defaultLanguageForColumn.remove(string);
        }
        this.save();
    }

    private void load() {
        String string = this.preferenceStore.getString(String.valueOf(this.project.getName()) + "_DEFAULTLANGUAGES");
        if (string != null && !string.equals("")) {
            String[] stringArray;
            String[] stringArray2 = stringArray = string.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringArray2[n2];
                String[] stringArray3 = string2.split(":");
                this.defaultLanguageForColumn.put(stringArray3[0], stringArray3[1]);
                ++n2;
            }
        }
    }

    private void save() {
        String string = "";
        for (Map.Entry<String, String> entry : this.defaultLanguageForColumn.entrySet()) {
            string = String.valueOf(string) + (string != "" ? "," : "") + entry.getKey() + ":" + entry.getValue();
        }
        this.preferenceStore.setValue(String.valueOf(this.project.getName()) + "_DEFAULTLANGUAGES", string);
    }

    public boolean hasMetadata() {
        return false;
    }

    public boolean hasExtraInfo() {
        return false;
    }

    public void clearMetadata() {
    }

    public void clearExtraInfo() {
    }

    public boolean hasComments() {
        return false;
    }

    public boolean hasTranslationDetails() {
        return false;
    }

    public boolean hasGrammarCheckerDetails() {
        return false;
    }

    public void clearComments() {
    }

    public void clearTranslationDetails() {
    }

    public void clearGrammarCheckerDetails() {
    }

    public boolean isMetadataEnabled() {
        return this.metadataEnabled;
    }

    public void setMetadataEnabled(boolean bl) {
        this.metadataEnabled = bl;
    }
}

