/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.localization.tools.editor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sequoyah.device.common.utilities.BasePlugin;
import org.eclipse.sequoyah.device.common.utilities.exception.AbstractExceptionStatus;
import org.eclipse.sequoyah.device.common.utilities.exception.SequoyahException;
import org.eclipse.sequoyah.device.common.utilities.exception.SequoyahExceptionStatus;
import org.eclipse.sequoyah.localization.editor.datatype.CellInfo;
import org.eclipse.sequoyah.localization.editor.datatype.ColumnInfo;
import org.eclipse.sequoyah.localization.editor.datatype.RowInfo;
import org.eclipse.sequoyah.localization.editor.datatype.RowInfoLeaf;
import org.eclipse.sequoyah.localization.editor.datatype.TranslationInfo;
import org.eclipse.sequoyah.localization.editor.model.input.AbstractStringEditorInput;
import org.eclipse.sequoyah.localization.editor.model.input.IEditorChangeListener;
import org.eclipse.sequoyah.localization.tools.LocalizationToolsPlugin;
import org.eclipse.sequoyah.localization.tools.datamodel.LocaleInfo;
import org.eclipse.sequoyah.localization.tools.datamodel.LocalizationFile;
import org.eclipse.sequoyah.localization.tools.datamodel.LocalizationFileBean;
import org.eclipse.sequoyah.localization.tools.datamodel.StringLocalizationFile;
import org.eclipse.sequoyah.localization.tools.datamodel.node.Node;
import org.eclipse.sequoyah.localization.tools.datamodel.node.NodeComment;
import org.eclipse.sequoyah.localization.tools.datamodel.node.StringArrayItemNode;
import org.eclipse.sequoyah.localization.tools.datamodel.node.StringArrayNode;
import org.eclipse.sequoyah.localization.tools.datamodel.node.StringNode;
import org.eclipse.sequoyah.localization.tools.datamodel.node.TranslationResult;
import org.eclipse.sequoyah.localization.tools.extensions.classes.ILocalizationSchema;
import org.eclipse.sequoyah.localization.tools.extensions.classes.ITranslator;
import org.eclipse.sequoyah.localization.tools.i18n.Messages;
import org.eclipse.sequoyah.localization.tools.managers.LocalizationManager;
import org.eclipse.sequoyah.localization.tools.managers.ProjectLocalizationManager;
import org.eclipse.sequoyah.localization.tools.managers.TranslatorManager;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPersistableElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringEditorInput
extends AbstractStringEditorInput {
    private ProjectLocalizationManager projectLocalizationManager = null;
    private final LocalizationManager.IFileChangeListener fileChangeListener = new LocalizationManager.IFileChangeListener(){

        public IProject getProject() {
            return StringEditorInput.this.projectLocalizationManager.getLocalizationProject().getProject();
        }

        public void fileChanged(IFile iFile) {
            StringEditorInput.this.notifyInputChanged(StringEditorInput.this.getColumnID(iFile));
        }
    };
    private final IEditorChangeListener editorChangeListener = new IEditorChangeListener(){

        public void editorContentChanged(IEditorInput iEditorInput, String string) {
            IFileEditorInput iFileEditorInput;
            IFileEditorInput iFileEditorInput2 = iFileEditorInput = iEditorInput instanceof IFileEditorInput ? (IFileEditorInput)iEditorInput : null;
            if (iFileEditorInput != null) {
                LocalizationFile localizationFile = StringEditorInput.this.projectLocalizationManager.getLocalizationProject().getLocalizationFile(iFileEditorInput.getFile());
                try {
                    StringEditorInput.this.projectLocalizationManager.getProjectLocalizationSchema().updateLocalizationFileContent(localizationFile, string);
                    StringEditorInput.this.notifyInputChanged(StringEditorInput.this.getColumnID(localizationFile.getFile()));
                }
                catch (SequoyahException sequoyahException) {
                    BasePlugin.logError((String)("Impossible to update file content for file: " + localizationFile.getFile().getFullPath()), (Throwable)sequoyahException);
                }
            }
        }
    };
    private final String LOCALIZATION_ICON = "icons/loc_icon.png";

    public String getTitle() {
        return this.projectLocalizationManager.getLocalizationProject().getProject().getName();
    }

    public RowInfo addRow(RowInfo rowInfo) {
        LocaleInfo localeInfo;
        Object object;
        RowInfo rowInfo2 = rowInfo;
        String string = rowInfo.getKey();
        boolean bl = false;
        HashMap<String, CellInfo> hashMap = null;
        Set<String> set = null;
        if (rowInfo instanceof RowInfoLeaf) {
            object = (RowInfoLeaf)rowInfo;
            hashMap = object.getCells();
        } else if (rowInfo instanceof RowInfo) {
            hashMap = new HashMap<String, CellInfo>();
            bl = true;
        }
        set = hashMap.keySet();
        object = this.projectLocalizationManager.getProjectLocalizationSchema();
        if (set.size() == 0 && (localeInfo = ((ILocalizationSchema)object).getLocaleInfoFromID(((ILocalizationSchema)object).getDefaultID())) != null) {
            LocalizationFile localizationFile = this.projectLocalizationManager.getLocalizationProject().getLocalizationFile(localeInfo);
            StringNode stringNode = ((StringLocalizationFile)localizationFile).getStringNodeByKey(rowInfo.getKey());
            if (stringNode == null) {
                ((StringLocalizationFile)localizationFile).createNode(rowInfo2, "", "");
            } else if (stringNode instanceof StringArrayNode) {
                ((StringLocalizationFile)localizationFile).createNode(rowInfo2, "", "");
            }
        }
        this.addNodeForEachColumnNonDefault(rowInfo2, string, bl, hashMap, set, (ILocalizationSchema)object);
        return rowInfo2;
    }

    private void addNodeForEachColumnNonDefault(RowInfo rowInfo, String string, boolean bl, Map<String, CellInfo> map, Set<String> set, ILocalizationSchema iLocalizationSchema) {
        for (String string2 : set) {
            RowInfoLeaf rowInfoLeaf;
            LocaleInfo localeInfo = iLocalizationSchema.getLocaleInfoFromID(string2);
            LocalizationFile localizationFile = this.projectLocalizationManager.getLocalizationProject().getLocalizationFile(localeInfo);
            String string3 = map.get(string2) != null ? map.get(string2).getComment() : null;
            String string4 = map.get(string2) != null ? map.get(string2).getValue() : null;
            StringNode stringNode = ((StringLocalizationFile)localizationFile).createNode(rowInfo, string4, string3);
            rowInfo.setKey(stringNode.getKey());
            if (!(rowInfo instanceof RowInfoLeaf) || (rowInfoLeaf = (RowInfoLeaf)rowInfo).getCells().get(string2) == null) continue;
            ((CellInfo)rowInfoLeaf.getCells().get(string2)).setValue(string4);
        }
    }

    public ProjectLocalizationManager getProjectLocalizationManager() {
        return this.projectLocalizationManager;
    }

    public void removeRow(String string) {
        List<LocalizationFile> list = this.projectLocalizationManager.getLocalizationProject().getLocalizationFiles();
        for (LocalizationFile localizationFile : list) {
            StringNode stringNode = ((StringLocalizationFile)localizationFile).getStringNodeByKey(string);
            if (stringNode == null) continue;
            ((StringLocalizationFile)localizationFile).removeStringNode(stringNode);
        }
    }

    public void removeChildRow(String string, int n) {
        List<LocalizationFile> list = this.projectLocalizationManager.getLocalizationProject().getLocalizationFiles();
        for (LocalizationFile localizationFile : list) {
            StringArrayNode stringArrayNode;
            StringArrayItemNode stringArrayItemNode;
            StringLocalizationFile stringLocalizationFile = (StringLocalizationFile)localizationFile;
            StringNode stringNode = stringLocalizationFile.getStringNodeByKey(string);
            if (!(stringNode instanceof StringArrayNode) || (stringArrayItemNode = (stringArrayNode = (StringArrayNode)stringNode).getArrayItemByIndex(n)) == null) continue;
            stringLocalizationFile.removeStringArrayItemNode(stringArrayItemNode);
        }
    }

    public void init(IProject iProject) throws SequoyahException {
        try {
            this.projectLocalizationManager = LocalizationManager.getInstance().getProjectLocalizationManager(iProject, true);
            LocalizationManager.getInstance().addFileChangeListener(this.fileChangeListener);
            this.addEditorChangeListener(this.editorChangeListener);
            if (this.projectLocalizationManager == null) {
                Status status = new Status(4, "org.eclipse.sequoyah.localization.tools", Messages.StringEditorInput_ErrorInitializingEditor);
                throw new SequoyahException((AbstractExceptionStatus)new SequoyahExceptionStatus((IStatus)status));
            }
        }
        catch (IOException iOException) {
            Status status = new Status(4, "org.eclipse.sequoyah.localization.tools", Messages.StringEditorInput_FileMalformed);
            throw new SequoyahException((AbstractExceptionStatus)new SequoyahExceptionStatus((IStatus)status));
        }
    }

    private String getColumnID(IFile iFile) {
        return iFile.getFullPath().removeLastSegments(1).lastSegment();
    }

    public List<ColumnInfo> getColumns() {
        List<LocalizationFile> list = this.projectLocalizationManager.getLocalizationProject().getLocalizationFiles();
        ArrayList<ColumnInfo> arrayList = new ArrayList<ColumnInfo>();
        ILocalizationSchema iLocalizationSchema = this.projectLocalizationManager.getProjectLocalizationSchema();
        String string = this.projectLocalizationManager.getProjectLocalizationSchema().getDefaultID();
        for (LocalizationFile localizationFile : list) {
            Object object;
            Object object2;
            String string2 = this.getColumnID(localizationFile.getFile());
            String string3 = iLocalizationSchema.getLocaleToolTip(localizationFile.getFile().getFullPath());
            List<StringNode> list2 = ((StringLocalizationFile)localizationFile).getStringNodes();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            for (StringNode stringNode : list2) {
                object2 = stringNode.getNodeComment() != null ? stringNode.getNodeComment().getComment() : "";
                object = new CellInfo(stringNode.getValue(), (String)object2);
                hashMap.put(stringNode.getKey(), object);
            }
            List<StringArrayNode> list3 = ((StringLocalizationFile)localizationFile).getStringArrays();
            Iterator object32 = list3.iterator();
            while (object32.hasNext()) {
                object2 = (StringArrayNode)object32.next();
                object = ((StringArrayNode)object2).getValues();
                CellInfo cellInfo = new CellInfo(true);
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    StringNode stringNode = (StringNode)iterator.next();
                    String string4 = stringNode.getNodeComment() != null ? stringNode.getNodeComment().getComment() : "";
                    CellInfo cellInfo2 = new CellInfo(stringNode.getValue(), string4);
                    cellInfo.addChild(cellInfo2);
                }
                hashMap.put(((Node)object2).getKey(), cellInfo);
            }
            arrayList.add(new ColumnInfo(string2, string3, hashMap, !string2.equals(string)));
        }
        return arrayList;
    }

    public IStatus translateColumn(String string, TranslationInfo translationInfo, IProgressMonitor iProgressMonitor) {
        IStatus iStatus = Status.OK_STATUS;
        ILocalizationSchema iLocalizationSchema = this.projectLocalizationManager.getProjectLocalizationSchema();
        LocaleInfo localeInfo = iLocalizationSchema.getLocaleInfoFromID(string);
        LocalizationFile localizationFile = this.projectLocalizationManager.getLocalizationProject().getLocalizationFile(localeInfo);
        if (localizationFile != null) {
            LocaleInfo localeInfo2 = iLocalizationSchema.getLocaleInfoFromID(translationInfo.getId());
            String string2 = iLocalizationSchema.getPathFromLocaleInfo(localeInfo2);
            IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(string2));
            LocalizationFileBean localizationFileBean = new LocalizationFileBean("", iFile, localeInfo2, new ArrayList<StringNode>(), null);
            StringLocalizationFile stringLocalizationFile = (StringLocalizationFile)this.projectLocalizationManager.getProjectLocalizationSchema().createLocalizationFile(localizationFileBean);
            stringLocalizationFile.setLocalizationProject(this.projectLocalizationManager.getLocalizationProject());
            iStatus = this.translateColumn((StringLocalizationFile)localizationFile, stringLocalizationFile, translationInfo, iProgressMonitor);
            if (iStatus.isOK()) {
                this.projectLocalizationManager.getLocalizationProject().addLocalizationFile(stringLocalizationFile);
                stringLocalizationFile.setDirty(true);
            }
        } else {
            iProgressMonitor.setCanceled(true);
            iStatus = new Status(4, "org.eclipse.sequoyah.localization.tools", NLS.bind((String)Messages.StringEditorInput_ErrorTranslatingFromFile, (Object)string));
            BasePlugin.logError((String)("Error translating from file '" + string + ". File does not exist."));
        }
        return iStatus;
    }

    public IStatus translateCells(String string, TranslationInfo[] translationInfoArray, IProgressMonitor iProgressMonitor) {
        IStatus iStatus = Status.OK_STATUS;
        try {
            Object object;
            iProgressMonitor.beginTask(Messages.TranslationProgress_Connecting, translationInfoArray.length);
            ITranslator iTranslator = TranslatorManager.getInstance().getTranslatorByName(translationInfoArray[0].getTranslator());
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            TranslationInfo[] translationInfoArray2 = translationInfoArray;
            int n = translationInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                object = translationInfoArray2[n2];
                arrayList.add(object.getFromWord());
                arrayList2.add(object.getFromLang());
                arrayList3.add(object.getToLang());
                iProgressMonitor.worked(1);
                ++n2;
            }
            iProgressMonitor.beginTask(Messages.TranslationProgress_FetchingInformation, 100);
            object = iTranslator.translateAll(arrayList, arrayList2, arrayList3, iProgressMonitor);
            n2 = 0;
            iProgressMonitor.done();
            iProgressMonitor.beginTask(Messages.ParsingAnswer, translationInfoArray.length * 3);
            TranslationInfo[] translationInfoArray3 = translationInfoArray;
            int n3 = translationInfoArray.length;
            int n4 = 0;
            while (n4 < n3) {
                TranslationInfo translationInfo = translationInfoArray3[n4];
                iProgressMonitor.worked(1);
                String string2 = ((TranslationResult)object.get(n2++)).getTranslatedWord();
                iProgressMonitor.worked(1);
                translationInfo.setToWord(string2);
                iProgressMonitor.worked(1);
                ++n4;
            }
            iProgressMonitor.done();
        }
        catch (Exception exception) {
            iStatus = new Status(4, "org.eclipse.sequoyah.localization.tools", Messages.StringEditorInput_ErrorTranslatingCells, (Throwable)exception);
            BasePlugin.logError((String)exception.getMessage());
            iProgressMonitor.setCanceled(true);
        }
        return iStatus;
    }

    private IStatus translateColumn(StringLocalizationFile stringLocalizationFile, StringLocalizationFile stringLocalizationFile2, TranslationInfo translationInfo, IProgressMonitor iProgressMonitor) {
        IStatus iStatus = Status.OK_STATUS;
        if (stringLocalizationFile.getStringNodes().size() > 0) {
            iStatus = this.translateStringNodes(stringLocalizationFile, stringLocalizationFile2, translationInfo, iProgressMonitor);
        }
        if (iStatus.isOK()) {
            iStatus = this.translateStringArrayNodes(stringLocalizationFile, stringLocalizationFile2, translationInfo, iProgressMonitor);
        }
        return iStatus;
    }

    /*
     * WARNING - void declaration
     */
    private IStatus translateStringNodes(StringLocalizationFile stringLocalizationFile, StringLocalizationFile stringLocalizationFile2, TranslationInfo translationInfo, IProgressMonitor iProgressMonitor) {
        List<StringNode> list = stringLocalizationFile.getStringNodes();
        ArrayList<String> arrayList = new ArrayList<String>();
        IStatus iStatus = Status.OK_STATUS;
        iProgressMonitor.beginTask(Messages.TranslationProgress_Connecting, list.size());
        for (StringNode object2 : list) {
            arrayList.add(object2.getValue());
            iProgressMonitor.worked(1);
        }
        iProgressMonitor.done();
        Object object = null;
        try {
            ITranslator exception = TranslatorManager.getInstance().getTranslatorByName(translationInfo.getTranslator());
            iProgressMonitor.beginTask(Messages.TranslationProgress_FetchingInformation, 100);
            object = exception.translateAll(arrayList, translationInfo.getFromLang(), translationInfo.getToLang(), iProgressMonitor);
        }
        catch (Exception n) {
            iStatus = new Status(4, "org.eclipse.sequoyah.localization.tools", n.getLocalizedMessage(), (Throwable)n);
            BasePlugin.logError((String)n.getMessage());
            iProgressMonitor.setCanceled(true);
        }
        if (iStatus.isOK()) {
            iProgressMonitor.done();
            boolean bl = false;
            iProgressMonitor.beginTask(Messages.ParsingAnswer, object.size());
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                void var9_14;
                iProgressMonitor.worked(1);
                TranslationResult translationResult = (TranslationResult)iterator.next();
                String string = translationResult.getTranslatedWord();
                StringNode stringNode = null;
                stringNode = new StringNode(list.get((int)var9_14).getKey(), string);
                ++var9_14;
                stringLocalizationFile2.addStringNode(stringNode);
                translationInfo.addCell(stringNode.getKey(), new CellInfo(stringNode.getValue(), ""));
            }
            iProgressMonitor.done();
        }
        return iStatus;
    }

    private IStatus translateStringArrayNodes(StringLocalizationFile stringLocalizationFile, StringLocalizationFile stringLocalizationFile2, TranslationInfo translationInfo, IProgressMonitor iProgressMonitor) {
        IStatus iStatus = Status.OK_STATUS;
        List<StringArrayNode> list = stringLocalizationFile.getStringArrays();
        iProgressMonitor.beginTask(Messages.ParsingAnswer, list.size());
        ArrayList<StringArrayNode> arrayList = new ArrayList<StringArrayNode>();
        int n = 0;
        for (StringArrayNode stringArrayNode : list) {
            int n2 = stringArrayNode.getStringValues().size();
            TranslationResult translationResult = null;
            StringArrayNode stringArrayNode2 = null;
            CellInfo cellInfo = null;
            ITranslator iTranslator = TranslatorManager.getInstance().getTranslatorByName(translationInfo.getTranslator());
            int n3 = 0;
            while (n3 < n2 && iStatus.isOK()) {
                String string;
                try {
                    string = stringArrayNode.getArrayItemByIndex(n3).getValue();
                    translationResult = string != null && !string.equals("") ? iTranslator.translate(string, translationInfo.getFromLang(), translationInfo.getToLang()) : new TranslationResult("", iTranslator, "", translationInfo.getFromLang(), translationInfo.getToLang(), new Date(), true);
                }
                catch (Exception exception) {
                    iStatus = new Status(4, "org.eclipse.sequoyah.localization.tools", exception.getLocalizedMessage(), (Throwable)exception);
                    BasePlugin.logError((String)exception.getMessage());
                    iProgressMonitor.setCanceled(true);
                }
                if (iStatus.isOK()) {
                    string = translationResult.getTranslatedWord();
                    if (n3 == 0) {
                        stringArrayNode2 = new StringArrayNode(list.get(n).getKey());
                        cellInfo = new CellInfo(true);
                        translationInfo.addCell(list.get(n).getKey(), cellInfo);
                    }
                    stringArrayNode2.addValue(string, n3);
                    CellInfo cellInfo2 = new CellInfo(string, "");
                    cellInfo.addChild(cellInfo2, n3, false);
                }
                ++n3;
            }
            if (stringArrayNode2 != null) {
                arrayList.add(stringArrayNode2);
            }
            iProgressMonitor.worked(1);
            ++n;
        }
        if (iStatus.isOK()) {
            stringLocalizationFile2.setStringArrayNodes(arrayList);
            iProgressMonitor.done();
        }
        return iStatus;
    }

    public void addColumn(String string) {
        ILocalizationSchema iLocalizationSchema = this.projectLocalizationManager.getProjectLocalizationSchema();
        LocaleInfo localeInfo = iLocalizationSchema.getLocaleInfoFromID(string);
        LocalizationFile localizationFile = this.projectLocalizationManager.getLocalizationProject().getLocalizationFile(localeInfo);
        if (localizationFile == null) {
            String string2 = iLocalizationSchema.getPathFromLocaleInfo(localeInfo);
            IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(string2));
            LocalizationFileBean localizationFileBean = new LocalizationFileBean("", iFile, localeInfo, new ArrayList<StringNode>(), null);
            LocalizationFile localizationFile2 = this.projectLocalizationManager.getProjectLocalizationSchema().createLocalizationFile(localizationFileBean);
            localizationFile2.setLocalizationProject(this.projectLocalizationManager.getLocalizationProject());
            localizationFile2.setDirty(true);
            this.projectLocalizationManager.getLocalizationProject().addLocalizationFile((StringLocalizationFile)localizationFile2);
        } else {
            localizationFile.setToBeDeleted(false);
        }
    }

    public void removeColumn(String string) {
        LocaleInfo localeInfo = this.projectLocalizationManager.getProjectLocalizationSchema().getLocaleInfoFromID(string);
        if (localeInfo.getLocaleAttributes().isEmpty()) {
            List<LocalizationFile> list = this.projectLocalizationManager.getLocalizationProject().getLocalizationFiles();
            for (LocalizationFile localizationFile : list) {
                if (!localizationFile.getFile().toString().contains(string)) continue;
                this.projectLocalizationManager.markFileForDeletion(localizationFile);
                this.projectLocalizationManager.getLocalizationProject().setDirty(true);
            }
        } else {
            LocalizationFile localizationFile = this.projectLocalizationManager.getLocalizationProject().getLocalizationFile(localeInfo);
            this.projectLocalizationManager.markFileForDeletion(localizationFile);
            this.projectLocalizationManager.getLocalizationProject().setDirty(true);
        }
    }

    public void setValue(String string, String string2, String string3) throws SequoyahException {
        if (this.projectLocalizationManager == null) {
            Status status = new Status(4, "org.eclipse.sequoyah.localization.tools", Messages.StringEditorInput_ErrorManagerNotInitialized);
            throw new SequoyahException((AbstractExceptionStatus)new SequoyahExceptionStatus((IStatus)status));
        }
        LocaleInfo localeInfo = this.projectLocalizationManager.getProjectLocalizationSchema().getLocaleInfoFromID(string);
        LocalizationFile localizationFile = this.projectLocalizationManager.getLocalizationProject().getLocalizationFile(localeInfo);
        StringNode stringNode = ((StringLocalizationFile)localizationFile).getStringNodeByKey(string2);
        if (stringNode == null) {
            stringNode = new StringNode(string2, string3);
            ((StringLocalizationFile)localizationFile).addStringNode(stringNode);
        }
        stringNode.setValue(string3);
    }

    public void setValue(String string, String string2, String string3, int n) throws SequoyahException {
        if (this.projectLocalizationManager == null) {
            Status status = new Status(4, "org.eclipse.sequoyah.localization.tools", Messages.StringEditorInput_ErrorManagerNotInitialized);
            throw new SequoyahException((AbstractExceptionStatus)new SequoyahExceptionStatus((IStatus)status));
        }
        LocaleInfo localeInfo = this.projectLocalizationManager.getProjectLocalizationSchema().getLocaleInfoFromID(string);
        LocalizationFile localizationFile = this.projectLocalizationManager.getLocalizationProject().getLocalizationFile(localeInfo);
        StringNode stringNode = ((StringLocalizationFile)localizationFile).getStringNodeByKey(string2);
        if (stringNode instanceof StringArrayNode) {
            StringArrayNode stringArrayNode = (StringArrayNode)stringNode;
            StringArrayItemNode stringArrayItemNode = stringArrayNode.getArrayItemByIndex(n);
            if (stringArrayItemNode != null) {
                stringArrayItemNode.setLocalizationFile(localizationFile);
                stringArrayItemNode.setValue(string3);
            } else {
                StringArrayItemNode stringArrayItemNode2 = stringArrayNode.addValue(string3, n);
                stringArrayItemNode2.setLocalizationFile(localizationFile);
            }
        } else if (stringNode == null) {
            StringArrayNode stringArrayNode = new StringArrayNode(string2);
            stringArrayNode.setLocalizationFile(localizationFile);
            StringArrayItemNode stringArrayItemNode = stringArrayNode.addValue(string3, n);
            stringArrayItemNode.setLocalizationFile(localizationFile);
            ((StringLocalizationFile)localizationFile).addStringNode(stringArrayNode);
        }
    }

    public CellInfo getValue(String string, String string2) {
        LocaleInfo localeInfo = this.projectLocalizationManager.getProjectLocalizationSchema().getLocaleInfoFromID(string);
        LocalizationFile localizationFile = this.projectLocalizationManager.getLocalizationProject().getLocalizationFile(localeInfo);
        StringNode stringNode = ((StringLocalizationFile)localizationFile).getStringNodeByKey(string2);
        if (stringNode == null) {
            return new CellInfo("", "");
        }
        return new CellInfo(stringNode.getValue(), stringNode.getNodeComment() != null ? stringNode.getNodeComment().getComment() : null);
    }

    public Map<String, CellInfo> getValues(String string) {
        LocaleInfo localeInfo = this.projectLocalizationManager.getProjectLocalizationSchema().getLocaleInfoFromID(string);
        HashMap<String, CellInfo> hashMap = new HashMap<String, CellInfo>();
        hashMap.keySet();
        LocalizationFile localizationFile = this.projectLocalizationManager.getLocalizationProject().getLocalizationFile(localeInfo);
        List<StringNode> list = ((StringLocalizationFile)localizationFile).getStringNodes();
        for (StringNode object22 : list) {
            Object object = "";
            if (object22.getNodeComment() != null) {
                object = object22.getNodeComment().getComment();
            }
            hashMap.put(object22.getKey(), new CellInfo(object22.getValue(), (String)object));
        }
        List<StringArrayNode> list2 = ((StringLocalizationFile)localizationFile).getStringArrays();
        for (Object stringArrayNode : list2) {
            CellInfo cellInfo = new CellInfo(true);
            for (StringNode stringNode : ((StringArrayNode)stringArrayNode).getValues()) {
                String string2 = "";
                if (stringNode.getNodeComment() != null) {
                    string2 = stringNode.getNodeComment().getComment();
                }
                cellInfo.addChild(new CellInfo(stringNode.getValue(), string2));
            }
            hashMap.put(((Node)stringArrayNode).getKey(), cellInfo);
        }
        return hashMap;
    }

    public List<CellInfo> getAvailableKeysForColumn(String string) {
        LocaleInfo localeInfo = this.projectLocalizationManager.getProjectLocalizationSchema().getLocaleInfoFromID(string);
        ArrayList<CellInfo> arrayList = new ArrayList<CellInfo>();
        LocalizationFile localizationFile = this.projectLocalizationManager.getLocalizationProject().getLocalizationFile(localeInfo);
        List<StringNode> list = ((StringLocalizationFile)localizationFile).getStringNodes();
        for (StringNode stringNode : list) {
            arrayList.add(new CellInfo(stringNode.getKey(), stringNode.getNodeComment().getComment()));
        }
        return arrayList;
    }

    public boolean canSave() {
        return true;
    }

    public boolean save() {
        boolean bl = this.projectLocalizationManager.saveProject();
        return bl;
    }

    public boolean isDirty() {
        boolean bl = false;
        if (this.projectLocalizationManager != null) {
            bl = this.projectLocalizationManager.getLocalizationProject().isDirty();
        }
        return bl;
    }

    public boolean exists() {
        return this.projectLocalizationManager.getAvailableLocales().size() > 0;
    }

    public ImageDescriptor getImageDescriptor() {
        return LocalizationToolsPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sequoyah.localization.tools", (String)"icons/loc_icon.png");
    }

    public String getName() {
        String string = "";
        if (this.projectLocalizationManager != null) {
            string = this.projectLocalizationManager.getProjectLocalizationSchema().getEditorName();
        }
        return string;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public Object getAdapter(Class clazz) {
        return null;
    }

    public boolean canRevertByColumn() {
        return true;
    }

    public boolean revert() {
        LocalizationManager.getInstance().unloadProjectLocalizationManager(this.projectLocalizationManager.getLocalizationProject().getProject());
        try {
            LocalizationManager.getInstance().getProjectLocalizationManager(this.projectLocalizationManager.getLocalizationProject().getProject(), false);
        }
        catch (IOException iOException) {
        }
        catch (SequoyahException sequoyahException) {}
        return true;
    }

    public boolean isRevertable(String string) {
        boolean bl = false;
        LocaleInfo localeInfo = this.projectLocalizationManager.getProjectLocalizationSchema().getLocaleInfoFromID(string);
        LocalizationFile localizationFile = this.projectLocalizationManager.getLocalizationProject().getLocalizationFile(localeInfo);
        if (localizationFile.getFile().exists()) {
            bl = true;
        }
        return bl;
    }

    public boolean revert(String string) throws IOException {
        boolean bl = false;
        ILocalizationSchema iLocalizationSchema = this.projectLocalizationManager.getProjectLocalizationSchema();
        LocaleInfo localeInfo = this.projectLocalizationManager.getProjectLocalizationSchema().getLocaleInfoFromID(string);
        if (localeInfo != null) {
            LocalizationFile localizationFile = this.projectLocalizationManager.getLocalizationProject().getLocalizationFile(localeInfo);
            String string2 = localizationFile.getClass().toString();
            string2 = string2.substring(6, string2.length());
            LocalizationFile localizationFile2 = null;
            try {
                localizationFile2 = iLocalizationSchema.loadFile(string2, localizationFile.getFile());
            }
            catch (SequoyahException sequoyahException) {
                sequoyahException.printStackTrace();
            }
            this.projectLocalizationManager.getLocalizationProject().removeLocalizationFile(localizationFile);
            this.projectLocalizationManager.getLocalizationProject().addLocalizationFile(localizationFile2);
            bl = true;
        }
        return bl;
    }

    public String getToolTipText() {
        return this.projectLocalizationManager.getProjectLocalizationSchema().getEditorName();
    }

    public void dispose() {
        if (this.projectLocalizationManager != null) {
            LocalizationManager.getInstance().removeFileChangeListener(this.fileChangeListener);
            LocalizationManager.getInstance().unloadProjectLocalizationManager(this.projectLocalizationManager.getLocalizationProject().getProject());
            this.projectLocalizationManager = null;
        }
    }

    public static void stopListening() {
    }

    public void removeCell(String string, String string2) {
        ILocalizationSchema iLocalizationSchema = this.projectLocalizationManager.getProjectLocalizationSchema();
        LocaleInfo localeInfo = iLocalizationSchema.getLocaleInfoFromID(string2);
        LocalizationFile localizationFile = this.projectLocalizationManager.getLocalizationProject().getLocalizationFile(localeInfo);
        if (iLocalizationSchema.getDefaultID() != null && iLocalizationSchema.getDefaultID().equals(string2)) {
            try {
                this.setValue(string2, string, "");
            }
            catch (SequoyahException sequoyahException) {}
        } else {
            ((StringLocalizationFile)localizationFile).removeStringNode(((StringLocalizationFile)localizationFile).getStringNodeByKey(string));
        }
    }

    public void removeCell(String string, String string2, int n) {
        block10: {
            ILocalizationSchema iLocalizationSchema = this.projectLocalizationManager.getProjectLocalizationSchema();
            LocaleInfo localeInfo = iLocalizationSchema.getLocaleInfoFromID(string2);
            LocalizationFile localizationFile = this.projectLocalizationManager.getLocalizationProject().getLocalizationFile(localeInfo);
            if (iLocalizationSchema.getDefaultID() != null && iLocalizationSchema.getDefaultID().equals(string2)) {
                try {
                    if (n >= 0) {
                        this.setValue(string2, string, "", n);
                        break block10;
                    }
                    this.setValue(string2, string, "");
                }
                catch (SequoyahException sequoyahException) {}
            } else {
                StringLocalizationFile stringLocalizationFile = (StringLocalizationFile)localizationFile;
                StringArrayItemNode stringArrayItemNode = this.getArrayItemNodeByPosition(string, n, stringLocalizationFile);
                if (stringArrayItemNode != null) {
                    LocaleInfo localeInfo2 = iLocalizationSchema.getLocaleInfoFromID(iLocalizationSchema.getDefaultID());
                    LocalizationFile localizationFile2 = this.projectLocalizationManager.getLocalizationProject().getLocalizationFile(localeInfo2);
                    StringLocalizationFile stringLocalizationFile2 = (StringLocalizationFile)localizationFile2;
                    StringArrayItemNode stringArrayItemNode2 = this.getArrayItemNodeByPosition(string, n, stringLocalizationFile2);
                    if (stringArrayItemNode2 != null) {
                        try {
                            this.setValue(string2, string, "", n);
                        }
                        catch (SequoyahException sequoyahException) {}
                    } else {
                        stringLocalizationFile.removeStringArrayItemNode(stringArrayItemNode);
                    }
                }
            }
        }
    }

    private StringArrayItemNode getArrayItemNodeByPosition(String string, int n, StringLocalizationFile stringLocalizationFile) {
        StringArrayItemNode stringArrayItemNode = null;
        StringNode stringNode = stringLocalizationFile.getStringNodeByKey(string);
        if (stringNode instanceof StringArrayNode) {
            StringArrayNode stringArrayNode = (StringArrayNode)stringNode;
            stringArrayItemNode = stringArrayNode.getArrayItemByIndex(n);
        }
        return stringArrayItemNode;
    }

    public void setCellTooltip(String string, String string2, String string3) throws SequoyahException {
        if (this.projectLocalizationManager == null) {
            Status status = new Status(4, "org.eclipse.sequoyah.localization.tools", Messages.StringEditorInput_ErrorManagerNotInitialized);
            throw new SequoyahException((AbstractExceptionStatus)new SequoyahExceptionStatus((IStatus)status));
        }
        LocaleInfo localeInfo = this.projectLocalizationManager.getProjectLocalizationSchema().getLocaleInfoFromID(string);
        LocalizationFile localizationFile = this.projectLocalizationManager.getLocalizationProject().getLocalizationFile(localeInfo);
        NodeComment nodeComment = ((StringLocalizationFile)localizationFile).getStringNodeByKey(string2).getNodeComment();
        if (nodeComment == null) {
            nodeComment = new NodeComment();
        }
        ((StringLocalizationFile)localizationFile).getStringNodeByKey(string2).setNodeComment(nodeComment);
        nodeComment.setComment(string3);
    }

    public void setCellTooltip(String string, String string2, String string3, Integer n) throws SequoyahException {
        if (this.projectLocalizationManager == null) {
            Status status = new Status(4, "org.eclipse.sequoyah.localization.tools", Messages.StringEditorInput_ErrorManagerNotInitialized);
            throw new SequoyahException((AbstractExceptionStatus)new SequoyahExceptionStatus((IStatus)status));
        }
        LocaleInfo localeInfo = this.projectLocalizationManager.getProjectLocalizationSchema().getLocaleInfoFromID(string);
        LocalizationFile localizationFile = this.projectLocalizationManager.getLocalizationProject().getLocalizationFile(localeInfo);
        NodeComment nodeComment = ((StringArrayNode)((StringLocalizationFile)localizationFile).getStringNodeByKey(string2)).getArrayItemByIndex(n).getNodeComment();
        if (nodeComment == null) {
            nodeComment = new NodeComment();
        }
        ((StringArrayNode)((StringLocalizationFile)localizationFile).getStringNodeByKey(string2)).getArrayItemByIndex(n).setNodeComment(nodeComment);
        nodeComment.setComment(string3);
    }

    public IStatus validate() {
        Status status = new Status(0, "org.eclipse.sequoyah.localization.tools", "");
        String string = this.projectLocalizationManager.getProjectLocalizationSchema().getDefaultID();
        if (string != null) {
            LocaleInfo localeInfo = this.projectLocalizationManager.getProjectLocalizationSchema().getLocaleInfoFromID(string);
            LocalizationFile localizationFile = this.projectLocalizationManager.getLocalizationProject().getLocalizationFile(localeInfo);
            if (localizationFile == null) {
                status = new Status(2, "org.eclipse.sequoyah.localization.tools", Messages.Warning_NoDefaultFile);
            } else if (localizationFile.isToBeDeleted()) {
                status = new Status(2, "org.eclipse.sequoyah.localization.tools", Messages.Warning_NoDefaultFile);
            }
        }
        return status;
    }

    public boolean canHandle(IFile iFile) {
        boolean bl = false;
        ILocalizationSchema iLocalizationSchema = LocalizationManager.getInstance().getLocalizationSchema(iFile.getProject());
        if (iLocalizationSchema != null) {
            bl = iLocalizationSchema.isLocalizationFile(iFile);
        }
        return bl;
    }

    public List<IFile> getFiles() {
        ArrayList<IFile> arrayList = new ArrayList<IFile>();
        for (LocalizationFile localizationFile : this.projectLocalizationManager.getLocalizationProject().getLocalizationFiles()) {
            arrayList.add(localizationFile.getFile());
        }
        return arrayList;
    }

    public String getSourcePageNameForFile(IFile iFile) {
        IPath iPath = iFile.getFullPath();
        return String.valueOf(iPath.segment(iPath.segmentCount() - 2)) + "/" + iPath.lastSegment();
    }

    public String getContentForFileAsText(IFileEditorInput iFileEditorInput) {
        LocalizationFile localizationFile = this.projectLocalizationManager.getLocalizationProject().getLocalizationFile(iFileEditorInput.getFile());
        return (String)this.projectLocalizationManager.getProjectLocalizationSchema().getLocalizationFileContent(localizationFile);
    }

    public void renameKey(String string, String string2) throws SequoyahException {
        if (this.projectLocalizationManager == null) {
            Status status = new Status(4, "org.eclipse.sequoyah.localization.tools", Messages.StringEditorInput_ErrorManagerNotInitialized);
            throw new SequoyahException((AbstractExceptionStatus)new SequoyahExceptionStatus((IStatus)status));
        }
        for (LocalizationFile localizationFile : this.projectLocalizationManager.getLocalizationProject().getLocalizationFiles()) {
            if (!(localizationFile instanceof StringLocalizationFile)) continue;
            ((StringLocalizationFile)localizationFile).renameNodeKey(string, string2);
        }
    }
}

