/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.e4.migration;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.internal.e4.migration.InfoReader;
import org.eclipse.ui.internal.e4.migration.MementoReader;
import org.eclipse.ui.internal.e4.migration.PerspectiveReader;

public class WindowReader
extends MementoReader {
    public static final String STATUS_LINE_MANAGER_ID = "org.eclipse.jface.action.StatusLineManager";

    WindowReader(IMemento memento) {
        super(memento);
    }

    Rectangle getBounds() {
        Rectangle windowBounds = new Rectangle(0, 0, 0, 0);
        Integer bigInt = this.getInteger("x");
        windowBounds.x = bigInt == null ? 0 : bigInt;
        bigInt = this.getInteger("y");
        windowBounds.y = bigInt == null ? 0 : bigInt;
        bigInt = this.getInteger("width");
        windowBounds.width = bigInt == null ? 0 : bigInt;
        bigInt = this.getInteger("height");
        windowBounds.height = bigInt == null ? 0 : bigInt;
        return windowBounds;
    }

    boolean isMaximized() {
        return this.getBoolean("maximized", false);
    }

    boolean isMinimized() {
        return this.getBoolean("minimized", false);
    }

    boolean isCoolbarVisible() {
        IMemento trimLayoutMem = this.getChild("trimLayout");
        if (trimLayoutMem == null) {
            return false;
        }
        boolean visible = false;
        IMemento[] trimAreas = trimLayoutMem.getChildren("trimArea");
        IMemento topTrim = null;
        IMemento[] iMementoArray = trimAreas;
        int n = trimAreas.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento trimArea = iMementoArray[n2];
            if (128 == trimArea.getInteger("IMemento.internal.id")) {
                topTrim = trimArea;
                break;
            }
            ++n2;
        }
        if (topTrim != null) {
            IMemento[] trimItems;
            IMemento[] iMementoArray2 = trimItems = topTrim.getChildren("trimItem");
            int n3 = trimItems.length;
            n = 0;
            while (n < n3) {
                IMemento trimItem = iMementoArray2[n];
                if ("org.eclipse.ui.internal.WorkbenchWindow.topBar".equals(trimItem.getString("IMemento.internal.id"))) {
                    visible = true;
                    break;
                }
                ++n;
            }
        }
        return visible;
    }

    boolean isStatusBarVisible() {
        return this.getStatusBar() != null;
    }

    private IMemento getStatusBar() {
        IMemento[] trimAreas;
        IMemento trimLayoutMem = this.getChild("trimLayout");
        if (trimLayoutMem == null) {
            return null;
        }
        IMemento[] iMementoArray = trimAreas = trimLayoutMem.getChildren("trimArea");
        int n = trimAreas.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento trimArea = iMementoArray[n2];
            if (1024 == trimArea.getInteger("IMemento.internal.id")) {
                return trimArea;
            }
            ++n2;
        }
        return null;
    }

    boolean hasStatusLine() {
        IMemento statusBar = this.getStatusBar();
        if (statusBar != null) {
            IMemento[] trimItemMems;
            IMemento[] iMementoArray = trimItemMems = statusBar.getChildren("trimItem");
            int n = trimItemMems.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento trimItemMem = iMementoArray[n2];
                if (STATUS_LINE_MANAGER_ID.equals(trimItemMem.getID())) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    boolean isWelcomePageOpen() {
        return this.getChild("intro") != null;
    }

    List<PerspectiveReader> getPerspectiveReaders() {
        ArrayList<PerspectiveReader> perspectives = new ArrayList<PerspectiveReader>();
        IMemento perspContainer = this.getPerspectiveContainer();
        if (perspContainer != null) {
            IMemento[] perspectiveMems;
            IMemento[] iMementoArray = perspectiveMems = perspContainer.getChildren("perspective");
            int n = perspectiveMems.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento perspectiveMem = iMementoArray[n2];
                PerspectiveReader perspective = new PerspectiveReader(perspectiveMem);
                perspectives.add(perspective);
                ++n2;
            }
        }
        return perspectives;
    }

    private IMemento getPerspectiveContainer() {
        IMemento perspContainer = null;
        IMemento page = this.getPage();
        if (page != null) {
            perspContainer = page.getChild("perspectives");
        }
        return perspContainer;
    }

    boolean isSelected() {
        IMemento page = this.getPage();
        if (page == null) {
            return false;
        }
        Boolean selected = page.getBoolean("focus");
        return selected == null ? false : selected;
    }

    String getActivePerspectiveId() {
        String activePerspectiveId = null;
        IMemento perspContainer = this.getPerspectiveContainer();
        if (perspContainer != null) {
            activePerspectiveId = perspContainer.getString("activePerspective");
        }
        return activePerspectiveId;
    }

    List<InfoReader> getEditorStacks() {
        IMemento editorArea = this.getEditorArea();
        ArrayList<InfoReader> readers = new ArrayList<InfoReader>();
        if (editorArea != null) {
            IMemento[] editorStackMems;
            IMemento[] iMementoArray = editorStackMems = editorArea.getChildren("info");
            int n = editorStackMems.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento memento = iMementoArray[n2];
                readers.add(new InfoReader(memento));
                ++n2;
            }
        }
        return readers;
    }

    public Integer getDefaultFastViewSide() {
        Integer defaultFastViewSide = null;
        IMemento fastViewData = this.getChild("fastViewData");
        if (fastViewData != null) {
            defaultFastViewSide = fastViewData.getInteger("fastViewLocation");
        }
        return defaultFastViewSide;
    }

    private IMemento getEditorArea() {
        IMemento editors = this.getEditorsMemento();
        if (editors != null) {
            return editors.getChild("editorArea");
        }
        return null;
    }

    List<EditorReader> getEditors() {
        ArrayList<EditorReader> readers = new ArrayList<EditorReader>();
        IMemento editors = this.getEditorsMemento();
        if (editors != null) {
            IMemento[] editorMems;
            IMemento[] iMementoArray = editorMems = editors.getChildren("editor");
            int n = editorMems.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento memento = iMementoArray[n2];
                readers.add(new EditorReader(memento));
                ++n2;
            }
        }
        return readers;
    }

    private IMemento getEditorsMemento() {
        IMemento page = this.getPage();
        if (page == null) {
            return null;
        }
        return page.getChild("editors");
    }

    List<ViewReader> getViews() {
        ArrayList<ViewReader> readers = new ArrayList<ViewReader>();
        IMemento page = this.getPage();
        if (page == null) {
            return readers;
        }
        IMemento editors = page.getChild("views");
        if (editors != null) {
            IMemento[] editorMems;
            IMemento[] iMementoArray = editorMems = editors.getChildren("view");
            int n = editorMems.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento memento = iMementoArray[n2];
                readers.add(new ViewReader(memento));
                ++n2;
            }
        }
        return readers;
    }

    private IMemento getPage() {
        return this.getChild("page");
    }

    static class EditorReader
    extends MementoReader {
        private EditorReader(IMemento memento) {
            super(memento);
        }

        String getLabel() {
            return this.getString("title");
        }

        String getType() {
            return this.getString("id");
        }

        String getStackId() {
            return this.getString("workbook");
        }

        boolean isSelected() {
            return this.getBoolean("focus");
        }
    }

    static class ViewReader
    extends MementoReader {
        private ViewReader(IMemento memento) {
            super(memento);
        }

        String getId() {
            return this.getString("id");
        }

        String getLabel() {
            return this.getString("partName");
        }

        IMemento getViewState() {
            IMemento viewStateMem = this.getChild("viewState");
            if (viewStateMem == null) {
                return null;
            }
            return this.createRenamedCopy(viewStateMem, "view");
        }

        private XMLMemento createRenamedCopy(IMemento memento, String newName) {
            XMLMemento newMem = XMLMemento.createWriteRoot(newName);
            newMem.putMemento(memento);
            return newMem;
        }
    }
}

