/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.localization.editor.model.operations;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.sequoyah.localization.editor.datatype.RowInfo;
import org.eclipse.sequoyah.localization.editor.model.StringEditorPart;
import org.eclipse.sequoyah.localization.editor.model.operations.EditorOperation;

public class AddKeyOperation
extends EditorOperation {
    private final RowInfo row;
    private boolean doRefresh = true;

    public AddKeyOperation(String string, StringEditorPart stringEditorPart, RowInfo rowInfo) {
        super(string, stringEditorPart);
        this.row = rowInfo;
    }

    public AddKeyOperation(String string, StringEditorPart stringEditorPart, RowInfo rowInfo, boolean bl) {
        this(string, stringEditorPart, rowInfo);
        this.doRefresh = bl;
    }

    public IStatus execute(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws ExecutionException {
        return this.redo(iProgressMonitor, iAdaptable);
    }

    public IStatus redo(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws ExecutionException {
        this.getEditor().addRow(this.row);
        if (this.doRefresh) {
            this.getEditor().refresh();
        }
        return Status.OK_STATUS;
    }

    public IStatus undo(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws ExecutionException {
        this.getEditor().removeRow(this.row.getKey());
        if (this.doRefresh) {
            this.getEditor().refresh();
        }
        return Status.OK_STATUS;
    }
}

