/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.localization.editor.model;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.sequoyah.localization.editor.datatype.CellInfo;
import org.eclipse.sequoyah.localization.editor.datatype.RowInfo;
import org.eclipse.sequoyah.localization.editor.datatype.RowInfoLeaf;
import org.eclipse.sequoyah.localization.editor.i18n.Messages;
import org.eclipse.sequoyah.localization.editor.model.StringEditorPart;
import org.eclipse.sequoyah.localization.editor.model.operations.EditCellOperation;
import org.eclipse.sequoyah.localization.editor.model.operations.EditKeyOperation;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

class CellEditingSupport
extends EditingSupport {
    private final StringEditorPart stringEditorPart;
    private final String columnID;
    private final CellEditor editor;

    public CellEditingSupport(StringEditorPart stringEditorPart, TreeViewer treeViewer, String string) {
        super((ColumnViewer)treeViewer);
        this.stringEditorPart = stringEditorPart;
        this.columnID = string;
        this.editor = string.equalsIgnoreCase(Messages.StringEditorPart_KeyLabel) ? new TextCellEditor((Composite)treeViewer.getTree(), 4) : new TextCellEditor((Composite)treeViewer.getTree(), 514);
    }

    protected boolean canEdit(Object object) {
        boolean bl = true;
        if (this.columnID.equalsIgnoreCase(Messages.StringEditorPart_KeyLabel)) {
            if (object instanceof RowInfoLeaf) {
                RowInfoLeaf rowInfoLeaf = (RowInfoLeaf)object;
                bl = rowInfoLeaf.getParent() == null;
            } else if (object instanceof RowInfo) {
                bl = true;
            }
        } else {
            bl = object instanceof RowInfoLeaf;
        }
        return bl;
    }

    protected CellEditor getCellEditor(Object object) {
        return this.editor;
    }

    protected Object getValue(Object object) {
        RowInfo rowInfo = null;
        String string = null;
        if (object instanceof RowInfo) {
            rowInfo = (RowInfo)object;
        }
        if (this.columnID.equalsIgnoreCase(Messages.StringEditorPart_KeyLabel)) {
            string = rowInfo.getKey();
        } else if (object instanceof RowInfoLeaf) {
            CellInfo cellInfo = ((RowInfoLeaf)object).getCells().get(this.columnID);
            string = cellInfo != null && cellInfo.getValue() != null ? cellInfo.getValue() : "";
        }
        return string;
    }

    protected void setValue(Object object, final Object object2) {
        if (this.columnID.equalsIgnoreCase(Messages.StringEditorPart_KeyLabel)) {
            final RowInfo[] rowInfoArray = new RowInfo[1];
            if (object instanceof RowInfo) {
                rowInfoArray[0] = (RowInfo)object;
            }
            if (!object2.equals(rowInfoArray[0].getKey()) && this.stringEditorPart.getModel().getRows().containsKey(object2)) {
                this.getViewer().getControl().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        MessageDialog.openError((Shell)CellEditingSupport.this.getViewer().getControl().getShell(), (String)Messages.CellEditingSupport_0, (String)(String.valueOf(Messages.CellEditingSupport_1) + "'" + object2.toString() + "'" + Messages.CellEditingSupport_2));
                        CellEditingSupport.this.stringEditorPart.getEditorViewer().editElement((Object)rowInfoArray[0], 0);
                    }
                });
            } else if (object2 != null && object2.toString().trim().length() > 0 && object2.toString().compareTo(rowInfoArray[0].getKey()) != 0) {
                EditKeyOperation editKeyOperation = new EditKeyOperation(rowInfoArray[0].getKey(), object2.toString(), this.stringEditorPart);
                this.stringEditorPart.executeOperation(editKeyOperation);
            }
        } else if (object instanceof RowInfoLeaf) {
            RowInfoLeaf rowInfoLeaf = (RowInfoLeaf)object;
            CellInfo cellInfo = rowInfoLeaf.getCells().get(this.columnID);
            CellInfo cellInfo2 = null;
            String string = System.getProperty("line.separator");
            String string2 = cellInfo != null ? cellInfo.getValue() : "";
            String string3 = ((String)object2).replaceAll(string, "\n");
            if (string3.equals(string2)) {
                return;
            }
            if (object2.toString().length() > 0) {
                if (cellInfo != null) {
                    if (cellInfo.getValue() != null && !cellInfo.getValue().equals(object2.toString()) || cellInfo.getValue() == null) {
                        cellInfo2 = new CellInfo(object2.toString(), cellInfo.getComment(), cellInfo.getPosition());
                    }
                } else {
                    cellInfo2 = new CellInfo(object2.toString(), null, rowInfoLeaf.getPosition());
                }
            } else if (cellInfo != null) {
                cellInfo2 = new CellInfo(null, null, cellInfo.getPosition());
            }
            if (cellInfo2 != null) {
                cellInfo2.setDirty(true);
                EditCellOperation editCellOperation = new EditCellOperation(rowInfoLeaf.getKey(), this.columnID, cellInfo, cellInfo2, this.stringEditorPart, rowInfoLeaf);
                this.stringEditorPart.executeOperation(editCellOperation);
            }
        }
    }
}

