/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.wizards.elements;

import org.eclipse.andmore.android.common.utilities.i18n.UtilitiesNLS;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class ProjectChooser
extends Composite {
    private Label lblProject;
    private Text txtProject;
    private Button btnBrowseProject;
    IProject project;

    public IProject getProject() {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] projects = workspaceRoot.getProjects();
        if (projects != null && projects.length > 0) {
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject innerProject = iProjectArray[n2];
                if (innerProject.getName().equals(this.txtProject.getText())) {
                    this.project = innerProject;
                    break;
                }
                ++n2;
            }
        }
        return this.project;
    }

    public String getText() {
        return this.txtProject != null ? this.txtProject.getText() : "";
    }

    public void setText(String text) {
        if (this.txtProject != null) {
            this.txtProject.setText(text);
        }
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.txtProject.addModifyListener(modifyListener);
    }

    public void setTextFieldEnabled(boolean enabled) {
        this.txtProject.setEnabled(enabled);
    }

    public ProjectChooser(Composite parent, int style) {
        super(parent, style);
        this.setupLayout();
        this.addComponents();
    }

    private void setupLayout() {
        GridLayout layout = new GridLayout(5, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(4, 2, true, false));
    }

    private void addComponents() {
        this.lblProject = new Label((Composite)this, 0);
        this.lblProject.setText(UtilitiesNLS.UI_General_ProjectLabel);
        this.lblProject.setLayoutData((Object)new GridData(4, 2, false, false, 1, 1));
        this.txtProject = new Text((Composite)this, 2048);
        this.txtProject.setText("");
        this.txtProject.setLayoutData((Object)new GridData(4, 2, true, false, 3, 1));
        this.btnBrowseProject = new Button((Composite)this, 8);
        this.btnBrowseProject.setText(UtilitiesNLS.UI_General_BrowseButtonLabel);
        this.btnBrowseProject.setLayoutData((Object)new GridData(4, 2, false, false, 1, 1));
        this.btnBrowseProject.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ProjectChooser.this.project = ProjectChooser.this.openProjectChooser();
                if (ProjectChooser.this.project != null) {
                    ProjectChooser.this.txtProject.setText(ProjectChooser.this.project.getName());
                }
            }
        });
    }

    private IProject openProjectChooser() {
        IResource resource;
        IProject selectedProject = null;
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        ElementTreeSelectionDialog packageDialog = new ElementTreeSelectionDialog(shell, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        packageDialog.setTitle(UtilitiesNLS.ProjectChooser_UI_Selection);
        packageDialog.setMessage(UtilitiesNLS.ProjectChooser_UI_ChooseAProject);
        packageDialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        packageDialog.setComparator((ViewerComparator)new ResourceComparator(1));
        packageDialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return element instanceof IProject;
            }
        });
        packageDialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                Status valid = new Status(4, "org.eclipse.andmore.android.common", "");
                if (selection.length == 1 && selection[0] instanceof IProject) {
                    valid = new Status(0, "org.eclipse.andmore.android.common", "");
                }
                return valid;
            }
        });
        if (packageDialog.open() == 0 && (resource = (IResource)packageDialog.getFirstResult()) instanceof IProject) {
            selectedProject = (IProject)resource;
        }
        return selectedProject;
    }
}

