/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.model.manifest;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.eclipse.andmore.android.common.exception.AndroidException;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.common.utilities.AndroidStatus;
import org.eclipse.andmore.android.common.utilities.i18n.UtilitiesNLS;
import org.eclipse.andmore.android.model.manifest.dom.AbstractBuildingBlockNode;
import org.eclipse.andmore.android.model.manifest.dom.ActionNode;
import org.eclipse.andmore.android.model.manifest.dom.ActivityNode;
import org.eclipse.andmore.android.model.manifest.dom.AndroidManifestNode;
import org.eclipse.andmore.android.model.manifest.dom.ApplicationNode;
import org.eclipse.andmore.android.model.manifest.dom.CommentNode;
import org.eclipse.andmore.android.model.manifest.dom.IntentFilterNode;
import org.eclipse.andmore.android.model.manifest.dom.ManifestNode;
import org.eclipse.andmore.android.model.manifest.parser.AndroidManifestParser;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class AndroidManifestFile
extends AndroidManifestParser {
    public void addNode(AndroidManifestNode node) {
        if (node != null && !this.rootNodes.contains(node)) {
            this.rootNodes.add(node);
        }
    }

    public void removeNode(AndroidManifestNode node) {
        if (node != null && !this.rootNodes.contains(node)) {
            this.rootNodes.add(node);
        }
    }

    public AndroidManifestNode[] getNodes() {
        AndroidManifestNode[] nodes = new AndroidManifestNode[this.rootNodes.size()];
        nodes = this.rootNodes.toArray(nodes);
        return nodes;
    }

    public ManifestNode getManifestNode() {
        ManifestNode manifestNode = null;
        for (AndroidManifestNode node : this.rootNodes) {
            if (node.getNodeType() != AndroidManifestNode.NodeType.Manifest) continue;
            manifestNode = (ManifestNode)node;
            break;
        }
        return manifestNode;
    }

    public ApplicationNode getApplicationNode() {
        return this.getManifestNode().getApplicationNode();
    }

    public AbstractBuildingBlockNode getBuildingBlockNode(AndroidManifestNode.NodeType type, String androidName) {
        AbstractBuildingBlockNode resultNode = null;
        LinkedList<AbstractBuildingBlockNode> candidateList = new LinkedList<AbstractBuildingBlockNode>();
        ManifestNode manifestNode = this.getManifestNode();
        String manifestPackage = manifestNode.getNodeProperties().get("package");
        String androidNamePackage = androidName.substring(0, androidName.lastIndexOf(46));
        String shortAndroidName = new String();
        if (manifestPackage.equals(androidNamePackage)) {
            shortAndroidName = androidName.substring(androidName.lastIndexOf(46));
        }
        ApplicationNode applicationNode = this.getApplicationNode();
        switch (type) {
            case Activity: {
                candidateList.addAll(applicationNode.getActivityNodes());
                break;
            }
            case Provider: {
                candidateList.addAll(applicationNode.getProviderNodes());
                break;
            }
            case Receiver: {
                candidateList.addAll(applicationNode.getReceiverNodes());
                break;
            }
            case Service: {
                candidateList.addAll(applicationNode.getServiceNodes());
                break;
            }
        }
        for (AbstractBuildingBlockNode node : candidateList) {
            if (shortAndroidName != null && shortAndroidName.length() > 0 && node.getNodeProperties().get("android:name").equals(shortAndroidName)) {
                resultNode = node;
                break;
            }
            if (!node.getNodeProperties().get("android:name").equals(androidName)) continue;
            resultNode = node;
            break;
        }
        return resultNode;
    }

    public IDocument getContent() throws AndroidException {
        Document document = null;
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            AndmoreLogger.error(AndroidManifestFile.class, UtilitiesNLS.EXC_AndroidManifestFile_ErrorCreatingTheDocumentBuilder, (Throwable)e);
            throw new AndroidException(UtilitiesNLS.EXC_AndroidManifestFile_ErrorCreatingTheDocumentBuilder);
        }
        org.w3c.dom.Document xmlDocument = documentBuilder.newDocument();
        for (AndroidManifestNode node : this.rootNodes) {
            this.addNode(xmlDocument, null, node);
        }
        document = new Document(this.getXmlContent(xmlDocument));
        return document;
    }

    private void addNode(org.w3c.dom.Document xmlDocument, Node xmlParentNode, AndroidManifestNode nodeToAdd) {
        Node xmlNode;
        if (nodeToAdd instanceof CommentNode) {
            CommentNode commentNode = (CommentNode)nodeToAdd;
            xmlNode = xmlDocument.createComment(commentNode.getComment());
        } else {
            AndroidManifestNode child;
            Attr attr;
            NamedNodeMap xmlAttributes;
            xmlNode = xmlDocument.createElement(nodeToAdd.getNodeName());
            Map<String, String> attributes = nodeToAdd.getNodeProperties();
            Map<String, String> unknownAttributes = nodeToAdd.getNodeUnknownProperties();
            AndroidManifestNode[] children = nodeToAdd.getChildren();
            AndroidManifestNode[] unknown = nodeToAdd.getUnkownChildren();
            if (attributes != null && attributes.size() > 0) {
                xmlAttributes = xmlNode.getAttributes();
                for (String attrName : attributes.keySet()) {
                    attr = xmlDocument.createAttribute(attrName);
                    attr.setValue(attributes.get(attrName));
                    xmlAttributes.setNamedItem(attr);
                }
            }
            if (unknownAttributes != null && unknownAttributes.size() > 0) {
                xmlAttributes = xmlNode.getAttributes();
                for (String attrName : unknownAttributes.keySet()) {
                    attr = xmlDocument.createAttribute(attrName);
                    attr.setNodeValue(unknownAttributes.get(attrName));
                    xmlAttributes.setNamedItem(attr);
                }
            }
            AndroidManifestNode[] androidManifestNodeArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                child = androidManifestNodeArray[n2];
                this.addNode(xmlDocument, xmlNode, child);
                ++n2;
            }
            androidManifestNodeArray = unknown;
            n = unknown.length;
            n2 = 0;
            while (n2 < n) {
                child = androidManifestNodeArray[n2];
                this.addNode(xmlDocument, xmlNode, child);
                ++n2;
            }
        }
        if (xmlParentNode == null) {
            xmlDocument.appendChild(xmlNode);
        } else {
            xmlParentNode.appendChild(xmlNode);
        }
    }

    private String getXmlContent(org.w3c.dom.Document xmlDocument) throws AndroidException {
        OutputFormat outputFormat = new OutputFormat();
        XMLSerializer xmlSerializer = new XMLSerializer();
        StringWriter writer = new StringWriter();
        String content = null;
        outputFormat.setEncoding("UTF-8");
        outputFormat.setLineSeparator(System.getProperty("line.separator"));
        outputFormat.setIndenting(true);
        xmlSerializer.setOutputCharStream((Writer)writer);
        xmlSerializer.setOutputFormat(outputFormat);
        try {
            try {
                xmlSerializer.serialize(xmlDocument);
                content = writer.toString();
            }
            catch (IOException e) {
                AndmoreLogger.error(AndroidManifestFile.class, UtilitiesNLS.EXC_AndroidManifestFile_ErrorFormattingTheXMLOutput, (Throwable)e);
                throw new AndroidException(UtilitiesNLS.EXC_AndroidManifestFile_ErrorFormattingTheXMLOutput);
            }
        }
        catch (Throwable throwable) {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException iOException) {}
        }
        return content;
    }

    public IStatus[] getProblems() {
        ManifestNode manifestNode = this.getManifestNode();
        IStatus[] errors = manifestNode == null ? new IStatus[]{new AndroidStatus(4, UtilitiesNLS.ERR_AndroidManifestFile_TheFileAndroidManifestXmlIsMalFormed)} : this.getManifestNode().getRecursiveNodeErrors();
        return errors;
    }

    public IStatus[] getErrors() {
        LinkedList<IStatus> errors = new LinkedList<IStatus>();
        IStatus[] iStatusArray = this.getProblems();
        int n = iStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus status = iStatusArray[n2];
            if (status.getSeverity() == 4) {
                errors.add(status);
            }
            ++n2;
        }
        return errors.toArray(new IStatus[0]);
    }

    public boolean hasErrors() {
        boolean hasErrors = false;
        IStatus[] iStatusArray = this.getProblems();
        int n = iStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus status = iStatusArray[n2];
            if (status.getSeverity() == 4) {
                hasErrors = true;
                break;
            }
            ++n2;
        }
        return hasErrors;
    }

    public AndroidManifestNode getNode(AndroidManifestNode.NodeType nodeType) {
        AndroidManifestNode requiredNode = null;
        AndroidManifestNode[] manifestChildren = null;
        for (AndroidManifestNode node : this.rootNodes) {
            if (!(node instanceof ManifestNode)) continue;
            manifestChildren = ((ManifestNode)node).getChildren();
            break;
        }
        if (manifestChildren != null && manifestChildren.length > 0) {
            AndroidManifestNode[] androidManifestNodeArray = manifestChildren;
            int n = manifestChildren.length;
            int n2 = 0;
            while (n2 < n) {
                AndroidManifestNode manifestChild = androidManifestNodeArray[n2];
                if (manifestChild.getNodeType().equals((Object)nodeType)) {
                    requiredNode = manifestChild;
                    break;
                }
                ++n2;
            }
        }
        return requiredNode;
    }

    public boolean setAsMainActivity(String className, boolean isMainActivity) {
        boolean result = false;
        List<ActivityNode> activityNodes = this.getApplicationNode().getActivityNodes();
        for (ActivityNode activityNode : activityNodes) {
            if (!activityNode.getName().equals(className)) continue;
            result = activityNode.setAsMainActivity(isMainActivity);
            break;
        }
        return result;
    }

    public ActivityNode getMainActivity() {
        ActivityNode mainActivity = null;
        ApplicationNode appNode = this.getApplicationNode();
        List<ActivityNode> activities = appNode.getActivityNodes();
        for (ActivityNode activity : activities) {
            for (IntentFilterNode intent : activity.getIntentFilterNodes()) {
                for (ActionNode actionNode : intent.getActionNodes()) {
                    if (!actionNode.getNodeProperties().get("android:name").equals("android.intent.action.MAIN")) continue;
                    mainActivity = activity;
                    break;
                }
                if (mainActivity != null) break;
            }
            if (mainActivity != null) break;
        }
        return mainActivity;
    }
}

