/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.common.utilities;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.andmore.android.common.CommonPlugin;
import org.eclipse.andmore.android.common.exception.AndroidException;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.common.utilities.i18n.UtilitiesNLS;
import org.eclipse.andmore.android.manifest.AndroidProjectManifestFile;
import org.eclipse.andmore.android.model.manifest.AndroidManifestFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.internal.browser.WebBrowserEditor;
import org.eclipse.ui.internal.browser.WebBrowserEditorInput;
import org.eclipse.ui.internal.dialogs.WorkbenchPreferenceDialog;
import org.osgi.framework.Bundle;

public class EclipseUtils {
    private static final String STUDIO_ANDROID_CONSOLE_ID = "Studio for Android";
    private static final String ORG_ECLIPSE_UI_NET_NET_PREFERENCES = "org.eclipse.ui.net.NetPreferences";
    private static final String ORG_ECLIPSE_EQUINOX_SECURE_STORAGE_PREFERENCES = "org.eclipse.equinox.security.ui.storage";

    public static void showErrorDialog(final String dialogTitle, final String dialogMessage, final IStatus status) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                Shell aShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                Shell shell = new Shell(aShell);
                Rectangle parentSize = aShell.getParent() != null ? aShell.getParent().getBounds() : shell.getBounds();
                ErrorDialog errorDlg = new ErrorDialog(shell, dialogTitle, dialogMessage, status, 4);
                Rectangle dialogSize = shell.getBounds();
                int x = (parentSize.width - dialogSize.width) / 2 + parentSize.x;
                int y = (parentSize.height - dialogSize.height) / 2 + parentSize.y;
                shell.setLocation(x, y);
                errorDlg.open();
            }
        });
    }

    public static int showInformationDialog(String dialogTitle, String dialogMessage, String[] buttonLabels) {
        return EclipseUtils.showInformationDialog(dialogTitle, dialogMessage, null, buttonLabels, 2);
    }

    public static int showInformationDialog(String dialogTitle, String dialogMessage, String[] buttonLabels, int dialogImageType) {
        return EclipseUtils.showInformationDialog(dialogTitle, dialogMessage, null, buttonLabels, dialogImageType);
    }

    public static int showInformationDialogWithDetails(String dialogTitle, String dialogMessage, String detailsMessage, String[] buttonLabels) {
        return EclipseUtils.showInformationDialog(dialogTitle, dialogMessage, detailsMessage, buttonLabels, 2);
    }

    private static int showInformationDialog(final String dialogTitle, final String dialogMessage, final String detailsMessage, final String[] buttonLabels, final int dialogImageType) {
        final int[] returnCode = new int[1];
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                Rectangle parentSize = shell.getParent() != null ? shell.getParent().getBounds() : shell.getBounds();
                String[] internButtonLabels = buttonLabels;
                if (internButtonLabels == null) {
                    internButtonLabels = new String[]{"OK"};
                }
                MessageDialog dlg = detailsMessage == null ? new MessageDialog(shell, dialogTitle, null, dialogMessage, dialogImageType, internButtonLabels, 0) : new MessageDialog(shell, dialogTitle, null, dialogMessage, dialogImageType, internButtonLabels, 0){

                    protected Control createCustomArea(Composite parent) {
                        final Composite main = new Composite(parent, parent.getStyle());
                        GridLayout layout = new GridLayout();
                        main.setLayout((Layout)layout);
                        GridData data = new GridData(4, 4, true, false);
                        main.setLayoutData((Object)data);
                        final Button detailsButton = new Button(main, 8);
                        detailsButton.setText(UtilitiesNLS.UI_EclipseUtils_OpenDetails);
                        data = new GridData(131072, 0x1000000, true, false);
                        detailsButton.setLayoutData((Object)data);
                        detailsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
                            private Label detailsText;

                            public void widgetSelected(SelectionEvent e) {
                                if (this.detailsText != null && !this.detailsText.isDisposed()) {
                                    detailsButton.setText(UtilitiesNLS.UI_EclipseUtils_OpenDetails);
                                    this.detailsText.dispose();
                                } else {
                                    detailsButton.setText(UtilitiesNLS.UI_EclipseUtils_CloseDetails);
                                    this.detailsText = new Label(main, 2112);
                                    this.detailsText.setText(detailsMessage);
                                    GridData data = new GridData(4, 4, true, true);
                                    this.detailsText.setLayoutData((Object)data);
                                    GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)this.detailsText);
                                }
                                this.getShell().pack();
                            }
                        });
                        return main;
                    }
                };
                Rectangle dialogSize = shell.getBounds();
                int x = (parentSize.width - dialogSize.width) / 2 + parentSize.x;
                int y = (parentSize.height - dialogSize.height) / 2 + parentSize.y;
                shell.setLocation(x, y);
                returnCode[0] = dlg.open();
            }
        });
        return returnCode[0];
    }

    public static final boolean displayPrompt(Display display, final String title, final String message) {
        final boolean[] result = new boolean[1];
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                result[0] = MessageDialog.openQuestion((Shell)shell, (String)title, (String)message);
            }
        });
        return result[0];
    }

    public static boolean openYesNoDialog(final String dialogTitle, final String dialogMessage) {
        final Boolean[] answer = new Boolean[1];
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                MessageBox msgBox = new MessageBox(shell, 194);
                msgBox.setText(dialogTitle);
                msgBox.setMessage(dialogMessage);
                answer[0] = msgBox.open() == 64;
            }
        });
        return answer[0];
    }

    public static void showErrorDialog(AndroidException e) {
        String title = UtilitiesNLS.ERR_Gen_ErrorTitle;
        EclipseUtils.showErrorDialog(title, e.getMessage());
    }

    public static void showErrorDialog(final String title, final String message) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow ww = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                MessageDialog.openError((Shell)ww.getShell(), (String)title, (String)message);
            }
        });
    }

    public static void showInformationDialog(final String title, final String message) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchWindow ww = workbench.getActiveWorkbenchWindow();
                Shell shell = ww.getShell();
                MessageDialog.openInformation((Shell)shell, (String)title, (String)message);
            }
        });
    }

    public static void showWarningDialog(final String title, final String message) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchWindow ww = workbench.getActiveWorkbenchWindow();
                Shell shell = ww.getShell();
                MessageDialog.openWarning((Shell)shell, (String)title, (String)message);
            }
        });
    }

    public static boolean showQuestionDialog(final String title, final String message) {
        class BooleanWrapper {
            public boolean bool = false;

            BooleanWrapper() {
            }
        }
        final BooleanWrapper boolWrapper = new BooleanWrapper();
        Display.getDefault().syncExec(new Runnable(){
            {
            }

            @Override
            public void run() {
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchWindow ww = workbench.getActiveWorkbenchWindow();
                Shell shell = ww.getShell();
                boolWrapper.bool = MessageDialog.openQuestion((Shell)shell, (String)title, (String)message);
            }
        });
        return boolWrapper.bool;
    }

    public static int showQuestionWithCancelDialog(final String title, final String message) {
        class IntWrapper {
            public int diagReturn = 0;

            IntWrapper() {
            }
        }
        final IntWrapper intWrapper = new IntWrapper();
        Display.getDefault().syncExec(new Runnable(){
            {
            }

            @Override
            public void run() {
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchWindow ww = workbench.getActiveWorkbenchWindow();
                Shell shell = ww.getShell();
                MessageDialog dialog = new MessageDialog(shell, title, null, message, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
                int diagResults = dialog.open();
                switch (diagResults) {
                    case 0: {
                        intWrapper.diagReturn = 64;
                        break;
                    }
                    case 1: {
                        intWrapper.diagReturn = 128;
                        break;
                    }
                    default: {
                        intWrapper.diagReturn = 256;
                    }
                }
            }
        });
        return intWrapper.diagReturn;
    }

    public static int showQuestionYesAllCancelDialog(final String title, final String message) {
        class IntWrapper {
            public int diagReturn = 0;

            IntWrapper() {
            }
        }
        final IntWrapper intWrapper = new IntWrapper();
        Display.getDefault().syncExec(new Runnable(){
            {
            }

            @Override
            public void run() {
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchWindow ww = workbench.getActiveWorkbenchWindow();
                Shell shell = ww.getShell();
                MessageDialog dialog = new MessageDialog(shell, title, null, message, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL}, 0);
                int diagResults = dialog.open();
                switch (diagResults) {
                    case 0: {
                        intWrapper.diagReturn = 2;
                        break;
                    }
                    case 1: {
                        intWrapper.diagReturn = 4;
                        break;
                    }
                    default: {
                        intWrapper.diagReturn = 3;
                    }
                }
            }
        });
        return intWrapper.diagReturn;
    }

    public static Object getExecutable(String extensionId, String elementName) throws CoreException {
        Object executable = null;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtension fromExtension = registry.getExtension(extensionId);
        if (fromExtension != null && elementName != null) {
            IConfigurationElement[] elements;
            IConfigurationElement[] iConfigurationElementArray = elements = fromExtension.getConfigurationElements();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                if (elementName.equals(element.getName())) {
                    executable = element.createExecutableExtension("class");
                }
                ++n2;
            }
        }
        return executable;
    }

    public static IExtension[] getInstalledPlugins(String extensionPointId) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(extensionPointId);
        IExtension[] pluggedExtensions = extensionPoint != null ? extensionPoint.getExtensions() : new IExtension[]{};
        return pluggedExtensions;
    }

    public static IViewPart showView(final String viewId) throws PartInitException {
        final Object[] tempObj = new Object[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage activePage;
                IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (activeWindow != null && (activePage = activeWindow.getActivePage()) != null) {
                    try {
                        tempObj[0] = activePage.showView(viewId);
                    }
                    catch (PartInitException e) {
                        tempObj[0] = e;
                    }
                }
            }
        });
        if (tempObj[0] instanceof PartInitException) {
            throw (PartInitException)((Object)tempObj[0]);
        }
        return (IViewPart)tempObj[0];
    }

    public static IViewPart getActiveView(final String viewId) {
        final Object[] tempObj = new Object[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IViewReference ref;
                IWorkbenchPage activePage;
                IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (activeWindow != null && (activePage = activeWindow.getActivePage()) != null && (ref = activePage.findViewReference(viewId)) != null) {
                    IViewPart part = ref.getView(false);
                    tempObj[0] = part;
                }
            }
        });
        return (IViewPart)tempObj[0];
    }

    public static Collection<IViewPart> getAllOpenedViewsWithId(final String viewId) {
        final LinkedHashSet<IViewPart> openedViews = new LinkedHashSet<IViewPart>();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow[] allWindows;
                IWorkbenchWindow[] iWorkbenchWindowArray = allWindows = PlatformUI.getWorkbench().getWorkbenchWindows();
                int n = allWindows.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkbenchPage[] allPagesInWindow;
                    IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                    IWorkbenchPage[] iWorkbenchPageArray = allPagesInWindow = window.getPages();
                    int n3 = allPagesInWindow.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IWorkbenchPage page = iWorkbenchPageArray[n4];
                        IViewPart view = page.findView(viewId);
                        if (view != null) {
                            openedViews.add(view);
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
        });
        return openedViews;
    }

    public static Collection<IEditorPart> getAllOpenedEditors() {
        final LinkedHashSet<IEditorPart> editors = new LinkedHashSet<IEditorPart>();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow[] allWindows;
                IWorkbenchWindow[] iWorkbenchWindowArray = allWindows = PlatformUI.getWorkbench().getWorkbenchWindows();
                int n = allWindows.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkbenchPage[] allPagesInWindow;
                    IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                    IWorkbenchPage[] iWorkbenchPageArray = allPagesInWindow = window.getPages();
                    int n3 = allPagesInWindow.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IEditorReference[] editorRefs;
                        IWorkbenchPage page = iWorkbenchPageArray[n4];
                        IEditorReference[] iEditorReferenceArray = editorRefs = page.getEditorReferences();
                        int n5 = editorRefs.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IEditorReference editorRef = iEditorReferenceArray[n6];
                            editors.add(editorRef.getEditor(false));
                            ++n6;
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
        });
        return editors;
    }

    public static IWorkbenchPage getPageForEditor(final IEditorPart editor) {
        final Object[] tempObj = new Object[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow[] allWindows;
                IWorkbenchWindow[] iWorkbenchWindowArray = allWindows = PlatformUI.getWorkbench().getWorkbenchWindows();
                int n = allWindows.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkbenchPage[] allPagesInWindow;
                    IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                    IWorkbenchPage[] iWorkbenchPageArray = allPagesInWindow = window.getPages();
                    int n3 = allPagesInWindow.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IWorkbenchPage page = iWorkbenchPageArray[n4];
                        if (page.findEditor(editor.getEditorInput()) != null) {
                            tempObj[0] = page;
                            break;
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
        });
        return (IWorkbenchPage)tempObj[0];
    }

    public static IEditorReference openedWebEditor(IWorkbenchPage page, URL wantedUrl) {
        IEditorReference wantedWebEditor = null;
        if (page != null) {
            IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
            int n = iEditorReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference editor = iEditorReferenceArray[n2];
                if ("org.eclipse.ui.browser.editor".equals(editor.getId())) {
                    try {
                        WebBrowserEditorInput webEditorInput = (WebBrowserEditorInput)editor.getEditorInput();
                        URL openedURL = webEditorInput.getURL();
                        if (openedURL != null && openedURL.equals(wantedUrl)) {
                            wantedWebEditor = editor;
                            break;
                        }
                    }
                    catch (Exception exception) {
                        AndmoreLogger.error(EclipseUtils.class, "Failed to get URL displayed by the opened Web Editor");
                    }
                }
                ++n2;
            }
        }
        if (wantedWebEditor != null) {
            AndmoreLogger.debug(EclipseUtils.class, "There is already an opened Web Browser Editor displaying the wanted URL. Simply activate it.");
            page.activate((IWorkbenchPart)wantedWebEditor.getEditor(true));
        } else {
            AndmoreLogger.debug(EclipseUtils.class, "Open new Web Browser Editor for: " + wantedUrl);
            WebBrowserEditorInput input = new WebBrowserEditorInput(wantedUrl);
            WebBrowserEditor.open((WebBrowserEditorInput)input);
        }
        return wantedWebEditor;
    }

    public static String getInstallLocation(String identifier) {
        return EclipseUtils.getInstallLocation(Platform.getBundle((String)identifier));
    }

    public static String getInstallLocation(Bundle bundle) {
        String installLocation = "";
        try {
            URL locationUrl = FileLocator.find((Bundle)bundle, (IPath)new Path("/"), null);
            URL fileUrl = FileLocator.toFileURL((URL)locationUrl);
            installLocation = new File(fileUrl.getFile()).getAbsolutePath();
        }
        catch (Exception e) {
            AndmoreLogger.error(EclipseUtils.class, "Error finding install location for bundle: " + bundle.getBundleId(), (Throwable)e);
        }
        return installLocation;
    }

    public static void openPreference(Shell shell, String nodeID) {
        PreferenceManager manager = PlatformUI.getWorkbench().getPreferenceManager();
        IPreferenceNode networkNode = null;
        for (IPreferenceNode node : manager.getElements(0)) {
            if (!node.getId().equals(nodeID)) continue;
            networkNode = node;
            break;
        }
        PreferenceManager prefMan = new PreferenceManager();
        if (networkNode != null) {
            prefMan.addToRoot(networkNode);
        }
        WorkbenchPreferenceDialog preferencesDialog = new WorkbenchPreferenceDialog(shell, prefMan);
        preferencesDialog.create();
        preferencesDialog.open();
    }

    public static void openSecureStoragePreferences(Shell shell) {
        EclipseUtils.openPreference(shell, ORG_ECLIPSE_EQUINOX_SECURE_STORAGE_PREFERENCES);
    }

    public static void openNetworkPreferences(Shell shell) {
        EclipseUtils.openPreference(shell, ORG_ECLIPSE_UI_NET_NET_PREFERENCES);
    }

    public static IStatus findMostSevereError(MultiStatus errorStatus) {
        IStatus mostSevere = null;
        if (!errorStatus.isOK()) {
            IStatus[] iStatusArray = errorStatus.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus status = iStatusArray[n2];
                if (mostSevere == null) {
                    mostSevere = status;
                }
                if (status.getSeverity() > mostSevere.getSeverity()) {
                    mostSevere = status;
                }
                ++n2;
            }
        }
        return mostSevere;
    }

    public static String readEmbeddedResource(Bundle bundle, String resourcePath) {
        String embeddedResourcePath;
        block26: {
            InputStream is = null;
            BufferedReader bufferedReader = null;
            embeddedResourcePath = null;
            try {
                try {
                    URL url = bundle.getEntry("/" + resourcePath);
                    if (url != null) {
                        is = url.openStream();
                    }
                    if (is != null) {
                        String line;
                        bufferedReader = new BufferedReader(new InputStreamReader(is));
                        StringBuilder result = new StringBuilder(bufferedReader.readLine());
                        while ((line = bufferedReader.readLine()) != null) {
                            result.append('\n');
                            result.append(line);
                        }
                        embeddedResourcePath = result.toString();
                    }
                }
                catch (IOException ioEx) {
                    AndmoreLogger.error(CommonPlugin.class, "Error while reading an embedded resource", (Throwable)ioEx);
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block26;
                }
            }
            catch (Throwable throwable) {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {}
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return embeddedResourcePath;
    }

    public static IPackageFragment getDefaultPackageFragment(IJavaProject javaProject) throws JavaModelException {
        IPackageFragment pack = null;
        AndroidManifestFile manifest = null;
        if (javaProject != null && javaProject.isOpen()) {
            IPackageFragment[] packs;
            IPackageFragment[] allPacks;
            String defaultPackage;
            try {
                manifest = AndroidProjectManifestFile.getFromProject(javaProject.getProject());
            }
            catch (AndroidException androidException) {
            }
            catch (CoreException coreException) {}
            if (manifest != null && (defaultPackage = manifest.getManifestNode().getPackageName()) != null && defaultPackage.trim().length() > 0 && (allPacks = javaProject.getPackageFragments()) != null) {
                IPackageFragment[] iPackageFragmentArray = allPacks;
                int n = allPacks.length;
                int n2 = 0;
                while (n2 < n) {
                    IPackageFragment frag = iPackageFragmentArray[n2];
                    if (frag.getElementName().equals(defaultPackage)) {
                        pack = frag;
                        break;
                    }
                    ++n2;
                }
            }
            if (pack == null && (packs = javaProject.getPackageFragments()) != null) {
                int i = 0;
                while (i < packs.length && pack == null) {
                    if (packs[i].getKind() != 2 && !EclipseUtils.isInsideGenFolder(packs[i]) && !packs[i].isDefaultPackage() && packs[i].getElementName().contains(".") && packs[i].exists()) {
                        pack = packs[i];
                        break;
                    }
                    ++i;
                }
            }
        }
        return pack;
    }

    private static boolean isInsideGenFolder(IPackageFragment fragment) {
        boolean isInside = fragment.getParent() instanceof IPackageFragmentRoot && fragment.getParent().getElementName().equals("gen");
        return isInside;
    }

    public static IStatus addLibsToProjects(List<IJavaProject> javaProjects, List<IPath> libsPaths, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        subMonitor.beginTask(UtilitiesNLS.ProjectUtils_AddLibsProgress_ConfiguringClassPaths, (javaProjects.size() * 2 + libsPaths.size()) * 1000);
        IStatus status = Status.OK_STATUS;
        IClasspathEntry[] classPathEntries = new IClasspathEntry[libsPaths.size()];
        int i = 0;
        subMonitor.subTask(UtilitiesNLS.ProjectUtils_AddLibsProgress_PreparingPaths);
        for (IPath libPath : libsPaths) {
            IClasspathEntry classpathEntry;
            classPathEntries[i] = classpathEntry = JavaCore.newLibraryEntry((IPath)libPath, null, null);
            ++i;
            subMonitor.worked(1000);
        }
        subMonitor.subTask(UtilitiesNLS.ProjectUtils_AddLibsProgress_ConfiguringProjects);
        for (IJavaProject javaProject : javaProjects) {
            try {
                IClasspathEntry[] rawClasspath = javaProject.getRawClasspath();
                int length = rawClasspath.length;
                int newEntriesLength = classPathEntries.length;
                int newLenght = length + newEntriesLength;
                IClasspathEntry[] newClassPath = new IClasspathEntry[newLenght];
                System.arraycopy(rawClasspath, 0, newClassPath, 0, length);
                System.arraycopy(classPathEntries, 0, newClassPath, length, newEntriesLength);
                subMonitor.worked(1000);
                javaProject.setRawClasspath(newClassPath, (IProgressMonitor)subMonitor.newChild(1000));
            }
            catch (JavaModelException e) {
                status = new Status(4, "org.eclipse.andmore.android.common", UtilitiesNLS.ProjectUtils_AddLibsProgress_ErrorSettingClasspaths, (Throwable)e);
                break;
            }
        }
        subMonitor.done();
        return status;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isLibOnClasspath(IJavaProject javaProject, IPath libPath) {
        try {
            IClasspathEntry[] rawClasspath;
            IClasspathEntry[] iClasspathEntryArray = rawClasspath = javaProject.getRawClasspath();
            int n = rawClasspath.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IClasspathEntry classpathEntry = iClasspathEntryArray[n2];
                if (classpathEntry.getPath().equals((Object)libPath)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    public static IOConsoleOutputStream getStudioConsoleOutputStream(boolean activate) {
        IConsole[] consoles;
        IOConsole activeConsole = null;
        IConsole[] iConsoleArray = consoles = ConsolePlugin.getDefault().getConsoleManager().getConsoles();
        int n = consoles.length;
        int n2 = 0;
        while (n2 < n) {
            IConsole console = iConsoleArray[n2];
            if (console.getName().equals(STUDIO_ANDROID_CONSOLE_ID)) {
                activeConsole = console;
            }
            ++n2;
        }
        if (activeConsole == null) {
            activeConsole = new IOConsole(STUDIO_ANDROID_CONSOLE_ID, null);
            ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{activeConsole});
        }
        if (activate) {
            ((IOConsole)activeConsole).activate();
        }
        IOConsoleOutputStream consoleOut = ((IOConsole)activeConsole).newOutputStream();
        return consoleOut;
    }
}

