/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.ndk.internal.templates;

import java.util.ArrayList;
import org.eclipse.andmore.ndk.internal.Messages;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.process.ProcessArgument;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.core.templateengine.process.ProcessRunner;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class SetFolders
extends ProcessRunner {
    public void process(TemplateCore template, ProcessArgument[] args, String processId, IProgressMonitor monitor) throws ProcessFailureException {
        String projectName = null;
        String[] sourceFolders = null;
        String[] outputFolders = null;
        ProcessArgument[] processArgumentArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessArgument arg = processArgumentArray[n2];
            String argName = arg.getName();
            if (argName.equals("projectName")) {
                projectName = arg.getSimpleValue();
            } else if (argName.equals("sourceFolders")) {
                sourceFolders = arg.getSimpleArrayValue();
            } else if (argName.equals("outputFolders")) {
                outputFolders = arg.getSimpleArrayValue();
            }
            ++n2;
        }
        if (projectName == null) {
            throw new ProcessFailureException(Messages.SetFolders_Missing_project_name);
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (!project.exists()) {
            throw new ProcessFailureException(Messages.SetFolders_Project_does_not_exist);
        }
        if (sourceFolders == null && outputFolders == null) {
            throw new ProcessFailureException(Messages.SetFolders_No_folders);
        }
        try {
            IFolder folder;
            ICProject cproject = CCorePlugin.getDefault().getCoreModel().create(project);
            IPathEntry[] pathEntries = cproject.getRawPathEntries();
            ArrayList<Object> newEntries = new ArrayList<Object>(pathEntries.length);
            Object[] objectArray = pathEntries;
            int n3 = pathEntries.length;
            int n4 = 0;
            while (n4 < n3) {
                IPathEntry pathEntry = objectArray[n4];
                if (pathEntry.getEntryKind() != 8 && pathEntry.getEntryKind() != 128) {
                    newEntries.add(pathEntry);
                }
                ++n4;
            }
            if (sourceFolders != null) {
                objectArray = sourceFolders;
                n3 = sourceFolders.length;
                n4 = 0;
                while (n4 < n3) {
                    IPathEntry sourceFolder = objectArray[n4];
                    folder = project.getFolder((IPath)new Path((String)sourceFolder));
                    if (!folder.exists()) {
                        folder.create(true, true, monitor);
                    }
                    newEntries.add(CoreModel.newSourceEntry((IPath)folder.getFullPath()));
                    ++n4;
                }
            }
            if (outputFolders != null) {
                objectArray = outputFolders;
                n3 = outputFolders.length;
                n4 = 0;
                while (n4 < n3) {
                    IPathEntry outputFolder = objectArray[n4];
                    folder = project.getFolder((IPath)new Path((String)outputFolder));
                    if (!folder.exists()) {
                        folder.create(true, true, monitor);
                    }
                    newEntries.add(CoreModel.newOutputEntry((IPath)folder.getFullPath()));
                    ++n4;
                }
            }
            cproject.setRawPathEntries(newEntries.toArray(new IPathEntry[newEntries.size()]), monitor);
        }
        catch (CoreException e) {
            throw new ProcessFailureException((Throwable)e);
        }
    }
}

