/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.ndk.internal.preferences;

import org.eclipse.andmore.ndk.internal.Activator;
import org.eclipse.andmore.ndk.internal.Messages;
import org.eclipse.andmore.ndk.internal.NdkManager;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class NdkPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private NdkDirectoryFieldEditor mNdkDirectoryEditor;

    public NdkPreferencePage() {
        super(1);
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.setDescription(Messages.NDKPreferencePage_Preferences);
    }

    protected void createFieldEditors() {
        this.mNdkDirectoryEditor = new NdkDirectoryFieldEditor("ndkLocation", Messages.NDKPreferencePage_Location, this.getFieldEditorParent());
        this.addField((FieldEditor)this.mNdkDirectoryEditor);
    }

    public void init(IWorkbench workbench) {
    }

    public void dispose() {
        super.dispose();
        if (this.mNdkDirectoryEditor != null) {
            this.mNdkDirectoryEditor.dispose();
            this.mNdkDirectoryEditor = null;
        }
    }

    private static class NdkDirectoryFieldEditor
    extends DirectoryFieldEditor {
        public NdkDirectoryFieldEditor(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
            this.setEmptyStringAllowed(true);
        }

        protected boolean doCheckState() {
            if (!super.doCheckState()) {
                this.setErrorMessage(Messages.NDKPreferencePage_not_a_valid_directory);
                return false;
            }
            String dirname = this.getTextControl().getText().trim();
            if (!dirname.isEmpty() && !NdkManager.isValidNdkLocation(dirname)) {
                this.setErrorMessage(Messages.NDKPreferencePage_not_a_valid_NDK_directory);
                return false;
            }
            return true;
        }

        public Text getTextControl(Composite parent) {
            this.setValidateStrategy(0);
            return super.getTextControl(parent);
        }
    }
}

