/*
 * Decompiled with CFR 0.152.
 */
package org.liblzf;

public class CLZF {
    static int HLOG = 14;
    static int HSIZE = 16384;
    static int MAX_LIT = 32;
    static int MAX_OFF = 8192;
    static int MAX_REF = 264;

    static int FRST(byte[] Array, int ptr) {
        return Array[ptr] << 8 & 0xFF00 | Array[ptr + 1] & 0xFF;
    }

    static int NEXT(int v, byte[] Array, int ptr) {
        return v << 8 | Array[ptr + 2] & 0xFF;
    }

    static int IDX(int h) {
        return ((h ^ h << 5) >> 24 - HLOG) - h * 5 & HSIZE - 1;
    }

    public static int lzf_compress(byte[] in_data, int in_len, byte[] out_data, int out_len) {
        int[] htab = new int[16384];
        for (int c = 0; c < 16384; ++c) {
            htab[c] = 0;
        }
        int iidx = 0;
        int oidx = 0;
        int hval = CLZF.FRST(in_data, iidx);
        int lit = 0;
        while (true) {
            if (iidx < in_len - 2) {
                hval = CLZF.NEXT(hval, in_data, iidx);
                int hslot = CLZF.IDX(hval);
                int reference = htab[hslot];
                htab[hslot] = iidx;
                int off = iidx - reference - 1;
                if (off < MAX_OFF && iidx + 4 < in_len && reference > 0 && in_data[reference + 0] == in_data[iidx + 0] && in_data[reference + 1] == in_data[iidx + 1] && in_data[reference + 2] == in_data[iidx + 2]) {
                    int len = 2;
                    int maxlen = in_len - iidx - len;
                    int n = maxlen = maxlen > MAX_REF ? MAX_REF : maxlen;
                    if (oidx + lit + 1 + 3 >= out_len) {
                        return 0;
                    }
                    while (++len < maxlen && in_data[reference + len] == in_data[iidx + len]) {
                    }
                    if (lit != 0) {
                        out_data[oidx++] = (byte)(lit - 1);
                        lit = -lit;
                        do {
                            out_data[oidx++] = in_data[iidx + lit];
                        } while (++lit != 0);
                    }
                    ++iidx;
                    if ((len -= 2) < 7) {
                        out_data[oidx++] = (byte)((off >> 8) + (len << 5));
                    } else {
                        out_data[oidx++] = (byte)((off >> 8) + 224);
                        out_data[oidx++] = (byte)(len - 7);
                    }
                    out_data[oidx++] = (byte)off;
                    hval = CLZF.FRST(in_data, iidx += len - 1);
                    hval = CLZF.NEXT(hval, in_data, iidx);
                    htab[CLZF.IDX((int)hval)] = iidx++;
                    hval = CLZF.NEXT(hval, in_data, iidx);
                    htab[CLZF.IDX((int)hval)] = iidx++;
                    continue;
                }
            } else if (iidx == in_len) break;
            ++iidx;
            if (++lit != MAX_LIT) continue;
            if (oidx + 1 + MAX_LIT >= out_len) {
                return 0;
            }
            out_data[oidx++] = (byte)(MAX_LIT - 1);
            lit = -lit;
            do {
                out_data[oidx++] = in_data[iidx + lit];
            } while (++lit != 0);
        }
        if (lit != 0) {
            if (oidx + lit + 1 >= out_len) {
                return 0;
            }
            out_data[oidx++] = (byte)(lit - 1);
            lit = -lit;
            do {
                out_data[oidx++] = in_data[iidx + lit];
            } while (++lit != 0);
        }
        return oidx;
    }

    public static int lzf_decompress(byte[] in_data, int in_len, byte[] out_data, int out_len) {
        int iidx = 0;
        int oidx = 0;
        do {
            int ctrl;
            if ((ctrl = in_data[iidx++] & 0xFF) < 32) {
                if (oidx + ++ctrl > out_len) {
                    return 0;
                }
                do {
                    out_data[oidx++] = in_data[iidx++];
                } while (--ctrl != 0);
                continue;
            }
            int len = ctrl >> 5;
            int reference = oidx - ((ctrl & 0x1F) << 8) - 1;
            if (len == 7) {
                len += in_data[iidx++] & 0xFF;
            }
            reference -= in_data[iidx++] & 0xFF;
            if (oidx + len + 2 > out_len) {
                return 0;
            }
            if (reference < 0) {
                return 0;
            }
            out_data[oidx++] = out_data[reference++];
            out_data[oidx++] = out_data[reference++];
            do {
                out_data[oidx++] = out_data[reference++];
            } while (--len != 0);
        } while (iidx < in_len);
        return oidx;
    }
}

