/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.gltrace.state.transforms;

import org.eclipse.andmore.gltrace.state.GLIntegerProperty;
import org.eclipse.andmore.gltrace.state.GLStateType;
import org.eclipse.andmore.gltrace.state.IGLProperty;
import org.eclipse.andmore.gltrace.state.transforms.GLPropertyAccessor;
import org.eclipse.andmore.gltrace.state.transforms.IGLPropertyAccessor;

public class TextureUnitPropertyAccessor
implements IGLPropertyAccessor {
    private final int mContextId;
    private final IGLPropertyAccessor mActiveTextureAccessor;
    private final GLStateType mTargetType;

    public TextureUnitPropertyAccessor(int contextId, GLStateType targetPropertyType) {
        this.mContextId = contextId;
        this.mTargetType = targetPropertyType;
        this.mActiveTextureAccessor = GLPropertyAccessor.makeAccessor(this.mContextId, new Object[]{GLStateType.TEXTURE_STATE, GLStateType.ACTIVE_TEXTURE_UNIT});
    }

    @Override
    public IGLProperty getProperty(IGLProperty state) {
        IGLProperty activeTextureProperty = this.mActiveTextureAccessor.getProperty(state);
        if (!(activeTextureProperty instanceof GLIntegerProperty)) {
            return null;
        }
        Integer activeTexture = (Integer)activeTextureProperty.getValue();
        IGLPropertyAccessor targetAccessor = GLPropertyAccessor.makeAccessor(this.mContextId, new Object[]{GLStateType.TEXTURE_STATE, GLStateType.TEXTURE_UNITS, activeTexture, this.mTargetType});
        return targetAccessor.getProperty(state);
    }

    @Override
    public String getPath() {
        return String.format("TEXTURE_STATE/TEXTURE_UNITS/${activeTextureUnit}/%s", new Object[]{this.mTargetType});
    }
}

