/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.gltrace.state.transforms;

import org.eclipse.andmore.gltrace.state.GLIntegerProperty;
import org.eclipse.andmore.gltrace.state.GLStateType;
import org.eclipse.andmore.gltrace.state.IGLProperty;
import org.eclipse.andmore.gltrace.state.transforms.GLPropertyAccessor;
import org.eclipse.andmore.gltrace.state.transforms.IGLPropertyAccessor;
import org.eclipse.andmore.gltrace.state.transforms.TextureUnitPropertyAccessor;

public class TexturePropertyAccessor
implements IGLPropertyAccessor {
    private final int mContextId;
    private final GLStateType mTargetUnitType;
    private final int mMipmapLevel;
    private final GLStateType mTextureType;
    private TextureUnitPropertyAccessor mTextureUnitPropertyAccessor;

    public TexturePropertyAccessor(int contextId, GLStateType textureUnitTarget, int level, GLStateType textureTargetName) {
        this.mContextId = contextId;
        this.mTargetUnitType = textureUnitTarget;
        this.mMipmapLevel = level;
        this.mTextureType = textureTargetName;
        this.mTextureUnitPropertyAccessor = new TextureUnitPropertyAccessor(this.mContextId, this.mTargetUnitType);
    }

    public TexturePropertyAccessor(int contextId, GLStateType textureUnitTarget, GLStateType textureTargetName) {
        this(contextId, textureUnitTarget, -1, textureTargetName);
    }

    @Override
    public IGLProperty getProperty(IGLProperty state) {
        IGLProperty targetTexture = this.mTextureUnitPropertyAccessor.getProperty(state);
        if (!(targetTexture instanceof GLIntegerProperty)) {
            return null;
        }
        Integer textureId = (Integer)targetTexture.getValue();
        IGLPropertyAccessor textureAccessor = this.mMipmapLevel >= 0 ? GLPropertyAccessor.makeAccessor(this.mContextId, new Object[]{GLStateType.TEXTURE_STATE, GLStateType.TEXTURES, textureId, GLStateType.TEXTURE_MIPMAPS, this.mMipmapLevel, this.mTextureType}) : GLPropertyAccessor.makeAccessor(this.mContextId, new Object[]{GLStateType.TEXTURE_STATE, GLStateType.TEXTURES, textureId, this.mTextureType});
        return textureAccessor.getProperty(state);
    }

    @Override
    public String getPath() {
        return String.format("TEXTURE_STATE/TEXTURES/${activeTexture}/%s", new Object[]{this.mTextureType});
    }
}

