/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.gltrace.state.transforms;

import org.eclipse.andmore.gltrace.state.GLListProperty;
import org.eclipse.andmore.gltrace.state.IGLProperty;
import org.eclipse.andmore.gltrace.state.transforms.IGLPropertyAccessor;
import org.eclipse.andmore.gltrace.state.transforms.IStateTransform;

public class ListElementAddTransform
implements IStateTransform {
    private final IGLPropertyAccessor mAccessor;
    private final IGLProperty mElement;

    public ListElementAddTransform(IGLPropertyAccessor accessor, IGLProperty element) {
        this.mAccessor = accessor;
        this.mElement = element;
    }

    @Override
    public void apply(IGLProperty currentState) {
        GLListProperty list = this.getList(currentState);
        if (list != null) {
            list.add(this.mElement);
        }
    }

    @Override
    public void revert(IGLProperty currentState) {
        GLListProperty list = this.getList(currentState);
        if (list != null) {
            list.remove(this.mElement);
        }
    }

    @Override
    public IGLProperty getChangedProperty(IGLProperty currentState) {
        return this.getList(currentState);
    }

    private GLListProperty getList(IGLProperty state) {
        IGLProperty p = state;
        if (this.mAccessor != null) {
            p = this.mAccessor.getProperty(p);
        }
        if (p instanceof GLListProperty) {
            return (GLListProperty)p;
        }
        return null;
    }
}

