/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.gltrace.model;

import com.android.utils.SparseArray;
import java.util.Collections;
import java.util.List;
import org.eclipse.andmore.gltrace.GLProtoBuf;
import org.eclipse.andmore.gltrace.state.transforms.IStateTransform;

public class GLCall {
    public static final int PROPERTY_MARKERNAME = 0;
    public static final int PROPERTY_VERTEX_ATTRIB_POINTER_SIZE = 1;
    public static final int PROPERTY_VERTEX_ATTRIB_POINTER_TYPE = 2;
    public static final int PROPERTY_VERTEX_ATTRIB_POINTER_DATA = 3;
    private int mIndex;
    private final long mStartTime;
    private final long mTraceFileOffset;
    private final boolean mHasFb;
    private final String mDisplayString;
    private final GLProtoBuf.GLMessage.Function mFunction;
    private final int mContextId;
    private final int mWallDuration;
    private final int mThreadDuration;
    private List<IStateTransform> mStateTransforms = Collections.emptyList();
    private String mStateTransformationCreationErrorMessage;
    private SparseArray<Object> mProperties;

    public GLCall(int index, long startTime, long traceFileOffset, String displayString, GLProtoBuf.GLMessage.Function function, boolean hasFb, int contextId, int wallTime, int threadTime) {
        this.mIndex = index;
        this.mStartTime = startTime;
        this.mTraceFileOffset = traceFileOffset;
        this.mDisplayString = displayString;
        this.mFunction = function;
        this.mHasFb = hasFb;
        this.mContextId = contextId;
        this.mWallDuration = wallTime;
        this.mThreadDuration = threadTime;
    }

    public int getIndex() {
        return this.mIndex;
    }

    public void setIndex(int i) {
        this.mIndex = i;
    }

    public long getOffsetInTraceFile() {
        return this.mTraceFileOffset;
    }

    public GLProtoBuf.GLMessage.Function getFunction() {
        return this.mFunction;
    }

    public int getContextId() {
        return this.mContextId;
    }

    public boolean hasFb() {
        return this.mHasFb;
    }

    public long getStartTime() {
        return this.mStartTime;
    }

    public int getWallDuration() {
        return this.mWallDuration;
    }

    public int getThreadDuration() {
        return this.mThreadDuration;
    }

    public void setStateTransformations(List<IStateTransform> transforms) {
        this.mStateTransforms = transforms;
    }

    public void setStateTransformationCreationError(String errorMessage) {
        this.mStateTransformationCreationErrorMessage = errorMessage;
    }

    public boolean hasErrors() {
        return this.mStateTransformationCreationErrorMessage != null;
    }

    public String getError() {
        return this.mStateTransformationCreationErrorMessage;
    }

    public List<IStateTransform> getStateTransformations() {
        return this.mStateTransforms;
    }

    public String toString() {
        return this.mDisplayString;
    }

    public void addProperty(int propertyName, Object value) {
        if (this.mProperties == null) {
            this.mProperties = new SparseArray(1);
        }
        this.mProperties.put(propertyName, value);
    }

    public Object getProperty(int propertyName) {
        if (this.mProperties == null) {
            return null;
        }
        return this.mProperties.get(propertyName);
    }
}

