/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.gltrace;

import java.io.DataOutputStream;
import java.io.IOException;

public class TraceCommandWriter {
    private static final int CMD_SIZE = 4;
    private static final int READ_FB_ON_EGLSWAP_BIT = 0;
    private static final int READ_FB_ON_GLDRAW_BIT = 1;
    private static final int READ_TEXTURE_DATA_ON_GLTEXIMAGE_BIT = 2;
    private final DataOutputStream mStream;

    public TraceCommandWriter(DataOutputStream traceCommandStream) {
        this.mStream = traceCommandStream;
    }

    public void setTraceOptions(boolean readFbOnEglSwap, boolean readFbOnGlDraw, boolean readTextureOnGlTexImage) throws IOException {
        int eglSwap = readFbOnEglSwap ? 1 : 0;
        int glDraw = readFbOnGlDraw ? 2 : 0;
        int tex = readTextureOnGlTexImage ? 4 : 0;
        int cmd = eglSwap | glDraw | tex;
        this.mStream.writeInt(4);
        this.mStream.writeInt(cmd);
        this.mStream.flush();
    }

    public void close() {
        try {
            this.mStream.close();
        }
        catch (IOException iOException) {}
    }
}

