/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.gltrace;

import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.andmore.ddms.IClientAction;
import org.eclipse.andmore.gltrace.CollectTraceAction;
import org.eclipse.andmore.gltrace.GLTraceOptionsDialog;
import org.eclipse.andmore.gltrace.GlTracePlugin;
import org.eclipse.andmore.gltrace.TraceOptions;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DeviceViewAction
implements IClientAction {
    private static final StartTraceAction sAction = new StartTraceAction();

    public Action getAction() {
        return sAction;
    }

    public void selectedClientChanged(Client c) {
        sAction.setClient(c);
    }

    private static final class StartTraceAction
    extends Action {
        private static final int LOCAL_FORWARDED_PORT = 6049;
        private Client mClient;

        public StartTraceAction() {
            super("Start OpenGL Trace");
            this.setImageDescriptor(GlTracePlugin.getImageDescriptor("/icons/connect.png"));
            this.setClient(null);
        }

        public void setClient(Client c) {
            this.mClient = c;
            this.clientChanged();
        }

        private void clientChanged() {
            if (this.mClient == null) {
                this.setEnabled(false);
                return;
            }
            ClientData cd = this.mClient.getClientData();
            if (cd.hasFeature("opengl-tracing")) {
                this.setEnabled(true);
                this.setToolTipText("Trace OpenGL calls");
            } else {
                this.setEnabled(false);
                this.setToolTipText("Selected VM does not support tracing OpenGL calls");
            }
        }

        public void run() {
            if (this.mClient == null) {
                return;
            }
            Shell shell = Display.getDefault().getActiveShell();
            GLTraceOptionsDialog dlg = new GLTraceOptionsDialog(shell, false, this.mClient.getClientData().getClientDescription());
            if (dlg.open() != 0) {
                return;
            }
            this.mClient.startOpenGlTracing();
            try {
                CollectTraceAction.setupForwarding(this.mClient.getDevice(), 6049);
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)shell, (String)"Setup GL Trace", (String)("Error while setting up port forwarding: " + e.getMessage()));
                return;
            }
            try {
                new ProgressMonitorDialog(shell).run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        Thread.sleep(3000L);
                    }
                });
            }
            catch (Exception exception) {}
            TraceOptions traceOptions = dlg.getTraceOptions();
            CollectTraceAction.startTracing(shell, traceOptions, 6049);
            this.mClient.stopOpenGlTracing();
            CollectTraceAction.disablePortForwarding(this.mClient.getDevice(), 6049);
            CollectTraceAction.openInEditor(shell, traceOptions.traceDestination);
        }
    }
}

