/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.packaging.ui.export;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.security.UnrecoverableKeyException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import org.eclipse.andmore.android.AdtUtils;
import org.eclipse.andmore.android.SdkUtils;
import org.eclipse.andmore.android.certmanager.core.KeyStoreManager;
import org.eclipse.andmore.android.certmanager.exception.InvalidPasswordException;
import org.eclipse.andmore.android.certmanager.exception.KeyStoreManagerException;
import org.eclipse.andmore.android.certmanager.job.CreateKeyJob;
import org.eclipse.andmore.android.certmanager.packaging.PackageFile;
import org.eclipse.andmore.android.certmanager.packaging.sign.PackageFileSigner;
import org.eclipse.andmore.android.certmanager.packaging.sign.SignException;
import org.eclipse.andmore.android.certmanager.ui.model.IKeyStore;
import org.eclipse.andmore.android.certmanager.ui.model.IKeyStoreEntry;
import org.eclipse.andmore.android.certmanager.ui.model.ITreeNode;
import org.eclipse.andmore.android.certmanager.ui.wizards.CreateKeyWizard;
import org.eclipse.andmore.android.certmanager.ui.wizards.CreateKeystoreWizard;
import org.eclipse.andmore.android.certmanager.ui.wizards.SelectExistentKeystoreWizard;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.common.utilities.EclipseUtils;
import org.eclipse.andmore.android.packaging.ui.PackagingUIPlugin;
import org.eclipse.andmore.android.packaging.ui.i18n.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class PackageExportWizardArea {
    private final IStructuredSelection selection;
    private Text destinationText;
    private Button selectAllButton;
    private Button deselectAllButton;
    private Button packageDestinationBrowseButton;
    private Button defaultDestination;
    private Button signCheckBox;
    private final Composite parentComposite;
    private final boolean signingEnabled;
    private final HashMap<IProject, Integer> projectSeverity;
    private Tree tree;
    private String message;
    private int severity;
    private boolean treeSelectionChanged;
    private final Image icon_ok;
    private final Image icon_nok;
    private Combo keystores;
    private Combo keysCombo;
    private Group signingGroup;
    private Button buttonAddKey;
    private static ArrayList<IKeyStore> keystoreList = new ArrayList();
    private final Map<IKeyStore, String> keystorePasswords = new HashMap<IKeyStore, String>();
    private IKeyStore previousSelectedKeystore;
    private String previousSelectedKey;
    private Button buttonExisting;
    private Button buttonAddNew;

    public PackageExportWizardArea(IStructuredSelection selection, Composite parent, boolean signingEnabled) {
        this.selection = this.normalizeSelection(selection);
        this.parentComposite = parent;
        this.signingEnabled = signingEnabled;
        this.projectSeverity = new HashMap();
        this.validateProjects();
        ImageDescriptor adtProjectImageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipe.andmore", (String)"icons/android_project.png");
        ImageDescriptor errorImageDescriptor = JavaPluginImages.DESC_OVR_ERROR;
        ImageDescriptor projectImage = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_PROJECT");
        ImageDescriptor[] overlays = new ImageDescriptor[5];
        overlays[1] = adtProjectImageDescriptor;
        this.icon_ok = new DecorationOverlayIcon(projectImage.createImage(), overlays).createImage();
        overlays[2] = errorImageDescriptor;
        this.icon_nok = new DecorationOverlayIcon(projectImage.createImage(), overlays).createImage();
        this.createControl(parent);
        this.treeSelectionChanged = false;
    }

    private String directoryDialog(String originalPath) {
        DirectoryDialog directoryDialog = new DirectoryDialog(this.parentComposite.getShell());
        File directory = new File(originalPath);
        if (directory.exists()) {
            directoryDialog.setFilterPath(directory.getPath());
        }
        String returnedPath = directoryDialog.open();
        return returnedPath;
    }

    private IStructuredSelection normalizeSelection(IStructuredSelection selection) {
        ArrayList<IProject> normalized = new ArrayList<IProject>();
        for (Object item : selection) {
            IProject project;
            IResource resource = null;
            if (item instanceof IResource) {
                resource = (IResource)item;
            } else if (item instanceof IAdaptable) {
                try {
                    resource = (IResource)((IAdaptable)item).getAdapter(IResource.class);
                }
                catch (Exception exception) {
                    AndmoreLogger.warn((String)"Error retrieving projects.");
                }
            }
            if (resource == null || normalized.contains(project = resource.getProject())) continue;
            normalized.add(project);
        }
        return new StructuredSelection(normalized);
    }

    private void populateTree() {
        this.tree.removeAll();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        try {
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                if (project.isOpen() && project.getNature("org.eclipe.andmore.AndroidNature") != null && !SdkUtils.isLibraryProject((IProject)project)) {
                    TreeItem item = new TreeItem(this.tree, 0);
                    item.setData((Object)project);
                    item.setText(project.getName());
                    item.setImage(this.projectSeverity.get(project) == 3 ? this.icon_nok : this.icon_ok);
                    if (this.selection.toList().contains(project)) {
                        item.setChecked(true);
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            AndmoreLogger.error(PackageExportWizardArea.class, (String)("Error populating tree: " + e.getMessage()));
        }
    }

    private void createDestinationGroup(Composite mainComposite) {
        Group destinationGroup = new Group(mainComposite, 64);
        GridLayout layout = new GridLayout(3, false);
        destinationGroup.setLayout((Layout)layout);
        GridData defaultDestGridData = new GridData(4, 0x1000000, true, false, 3, 1);
        destinationGroup.setLayoutData((Object)defaultDestGridData);
        destinationGroup.setText(Messages.PACKAGE_EXPORT_WIZARD_AREA_DESTINATION_LABEL);
        this.defaultDestination = new Button((Composite)destinationGroup, 32);
        defaultDestGridData = new GridData(4, 4, true, false, 3, 1);
        this.defaultDestination.setLayoutData((Object)defaultDestGridData);
        this.defaultDestination.addListener(13, (Listener)new DefaultDestinationListener());
        this.defaultDestination.setText(Messages.PACKAGE_EXPORT_WIZARD_USE_DEFAULT_DESTINATION);
        this.defaultDestination.setSelection(true);
        Label packageDestinationLabel = new Label((Composite)destinationGroup, 0);
        packageDestinationLabel.setText(Messages.PACKAGE_EXPORT_WIZARD_PACKAGE_DESTINATION_LABEL);
        GridData folderGridData = new GridData(16384, 0x1000000, false, false);
        packageDestinationLabel.setLayoutData((Object)folderGridData);
        this.destinationText = new Text((Composite)destinationGroup, 2052);
        folderGridData = new GridData(4, 0x1000000, true, false, 1, 1);
        this.destinationText.setLayoutData((Object)folderGridData);
        this.destinationText.setEnabled(!this.defaultDestination.getSelection());
        this.destinationText.addListener(24, (Listener)new DestinationTextListener());
        this.packageDestinationBrowseButton = new Button((Composite)destinationGroup, 8);
        folderGridData = new GridData(4, 0x1000000, false, false, 1, 1);
        this.packageDestinationBrowseButton.setLayoutData((Object)folderGridData);
        this.packageDestinationBrowseButton.setText(Messages.PACKAGE_EXPORT_WIZARD_AREA_BROWSE_BUTTON_LABEL);
        this.packageDestinationBrowseButton.setEnabled(!this.defaultDestination.getSelection());
        this.packageDestinationBrowseButton.addListener(13, (Listener)new PackageDestinationButtonListener());
    }

    public final String[] getKeys(IKeyStore iKeyStore) throws KeyStoreManagerException, InvalidPasswordException {
        List aliases = new ArrayList();
        aliases = iKeyStore.getAliases(this.getKeyStorePassword(iKeyStore));
        return aliases.toArray(new String[0]);
    }

    public String openNewKeyWizard(IKeyStore keyStore, IJobChangeListener createKeyJobListener) {
        CreateKeyWizard wizard = new CreateKeyWizard(keyStore, this.getKeyStorePassword(this.getSelectedKeyStore()), createKeyJobListener);
        WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
        dialog.open();
        return wizard.getAlias();
    }

    private void selectKeystore(IKeyStore newKeystore) {
        if (newKeystore != null) {
            int index = keystoreList.indexOf(newKeystore);
            if (this.keystores.getItemCount() > index) {
                this.keystores.select(index);
                this.loadKeys(newKeystore);
                this.setEnablement(true);
            }
        } else {
            this.keystores.deselectAll();
        }
        this.previousSelectedKeystore = this.getSelectedKeyStore();
    }

    private void selectKeystoreWithoutLoadingKeys(IKeyStore newKeystore) {
        if (newKeystore != null) {
            int index = keystoreList.indexOf(newKeystore);
            this.keysCombo.removeAll();
            if (this.keystores.getItemCount() > index) {
                this.keystores.select(index);
                this.setEnablement(true);
            }
        } else {
            this.keystores.deselectAll();
        }
        this.previousSelectedKeystore = this.getSelectedKeyStore();
    }

    private boolean loadKeys(IKeyStore newKeystore) {
        boolean successfullyLoaded = true;
        this.keysCombo.removeAll();
        try {
            String[] keys = this.getKeys(newKeystore);
            if (keys != null) {
                this.keysCombo.setItems(keys);
            }
        }
        catch (Exception exception) {
            successfullyLoaded = false;
            AndmoreLogger.info(PackageExportWizardArea.class, (String)NLS.bind((String)"Could not load keys for keystore: {0}", (Object)newKeystore.getFile().getAbsolutePath()));
        }
        this.selectKey(0);
        return successfullyLoaded;
    }

    private void selectKey(String key) {
        String[] keys = this.keysCombo.getItems();
        int index = -1;
        int i = 0;
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String k = stringArray[n2];
            if (k.equals(key)) {
                index = i;
                break;
            }
            ++i;
            ++n2;
        }
        this.selectKey(index);
    }

    private void selectKey(int index) {
        if (index >= 0 && index < this.keysCombo.getItemCount()) {
            this.keysCombo.select(index);
            this.setEnablement(true);
        } else {
            this.keysCombo.deselectAll();
        }
    }

    private void restorePreviousSelections() {
        this.selectKeystore(this.previousSelectedKeystore);
        this.selectKey(this.previousSelectedKey);
    }

    private String getSelectedKey() {
        String result = null;
        if (this.keysCombo.getSelectionIndex() >= 0) {
            result = this.keysCombo.getText();
        }
        return result;
    }

    protected IKeyStore getSelectedKeyStore() {
        IKeyStore result = null;
        if (this.keystores.getSelectionIndex() >= 0) {
            result = keystoreList.get(this.keystores.getSelectionIndex());
        }
        return result;
    }

    private void createSignGroup(Composite mainComposite) {
        this.signingGroup = new Group(mainComposite, 64);
        GridLayout layout = new GridLayout(4, false);
        GridData layoutData = new GridData(4, 0x1000000, true, false, 4, 1);
        this.signingGroup.setLayout((Layout)layout);
        this.signingGroup.setLayoutData((Object)layoutData);
        this.signingGroup.setText(Messages.PACKAGE_EXPORT_WIZARD_AREA_SIGNING_TAB_TEXT);
        this.signCheckBox = new Button((Composite)this.signingGroup, 32);
        layoutData = new GridData(16384, 0x1000000, true, false, 4, 1);
        this.signCheckBox.setLayoutData((Object)layoutData);
        this.signCheckBox.setText(Messages.PACKAGE_EXPORT_WIZARD_AREA_SIGN_CHECK_LABEL);
        this.signCheckBox.addListener(13, (Listener)new SignButtonListener());
        this.signCheckBox.setSelection(true);
        Label keystoreLabel = new Label((Composite)this.signingGroup, 0);
        keystoreLabel.setText(Messages.PACKAGE_EXPORT_WIZARD_AREA_SIGN_KEYSTORE_LABEL);
        GridData gridData = new GridData(1, 0x1000000, false, false, 1, 1);
        keystoreLabel.setLayoutData((Object)gridData);
        this.keystores = new Combo((Composite)this.signingGroup, 12);
        gridData = new GridData(4, 0x1000000, true, false, 1, 1);
        gridData.widthHint = 250;
        this.keystores.setLayoutData((Object)gridData);
        this.populateKeystoresFromView();
        this.keystores.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IKeyStore selectedKeystore = (IKeyStore)keystoreList.get(PackageExportWizardArea.this.keystores.getSelectionIndex());
                boolean keysLoaded = PackageExportWizardArea.this.loadKeys(selectedKeystore);
                if (!keysLoaded) {
                    ITreeNode keystoreNode = (ITreeNode)selectedKeystore;
                    if (keystoreNode.getNodeStatus().getCode() == 1) {
                        EclipseUtils.showInformationDialog((String)Messages.PackageExportWizardArea_WrongKeystoreTypeDialogTitle, (String)NLS.bind((String)Messages.PackageExportWizardArea_WrongKeystoreTypeDialogMessage, (Object)keystoreNode.getName()));
                    }
                    PackageExportWizardArea.this.restorePreviousSelections();
                } else {
                    PackageExportWizardArea.this.previousSelectedKeystore = PackageExportWizardArea.this.getSelectedKeyStore();
                    PackageExportWizardArea.this.previousSelectedKey = PackageExportWizardArea.this.getSelectedKey();
                }
                PackageExportWizardArea.this.setEnablement(true);
            }
        });
        if (this.keystores.getItemCount() <= 0) {
            this.signCheckBox.setSelection(false);
        }
        this.buttonExisting = new Button((Composite)this.signingGroup, 0);
        this.buttonAddNew = new Button((Composite)this.signingGroup, 0);
        gridData = new GridData(4, 0x1000000, false, false, 1, 1);
        this.buttonExisting.setLayoutData((Object)gridData);
        gridData = new GridData(4, 0x1000000, false, false, 1, 1);
        this.buttonAddNew.setLayoutData((Object)gridData);
        this.buttonExisting.setText(Messages.PackageExportWizardArea_MenuItem_UseExistent);
        this.buttonExisting.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PackageExportWizardArea.this.openSelectKeystoreWizard();
            }
        });
        this.buttonAddNew.setText(Messages.PackageExportWizardArea_MenuItem_AddNew);
        this.buttonAddNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CreateKeystoreWizard createKeystoreWizard = new CreateKeystoreWizard((IJobChangeListener)new CreateKeystoreJobListener());
                WizardDialog dialog = new WizardDialog(PackageExportWizardArea.this.parentComposite.getShell(), (IWizard)createKeystoreWizard);
                dialog.create();
                if (dialog.open() == 0) {
                    String keystorePassword = createKeystoreWizard.getCreatedKeystorePassword();
                    PackageExportWizardArea.this.addKeystore((IKeyStore)createKeystoreWizard.getCreatedKeystoreNode(), true, keystorePassword);
                    PackageExportWizardArea.this.selectKeystoreWithoutLoadingKeys((IKeyStore)createKeystoreWizard.getCreatedKeystoreNode());
                }
            }
        });
        Label keyLabel = new Label((Composite)this.signingGroup, 0);
        keyLabel.setText(Messages.PACKAGE_EXPORT_WIZARD_AREA_SIGN_KEY_LABEL);
        gridData = new GridData(1, 0x1000000, false, false, 1, 1);
        keyLabel.setLayoutData((Object)gridData);
        this.keysCombo = new Combo((Composite)this.signingGroup, 12);
        gridData = new GridData(4, 0x1000000, true, false, 2, 1);
        this.keysCombo.setLayoutData((Object)gridData);
        if (this.keysCombo.getItemCount() <= 0) {
            this.signCheckBox.setSelection(false);
        }
        this.keysCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                PackageExportWizardArea.this.previousSelectedKey = PackageExportWizardArea.this.getSelectedKey();
                PackageExportWizardArea.this.parentComposite.notifyListeners(24, new Event());
            }
        });
        this.buttonAddKey = new Button((Composite)this.signingGroup, 8);
        this.buttonAddKey.setText(Messages.PackageExportWizardArea_AddKeyButton_Text);
        gridData = new GridData(4, 0x1000000, false, false, 1, 1);
        this.buttonAddKey.setLayoutData((Object)gridData);
        this.buttonAddKey.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IKeyStore keyStore = null;
                if (PackageExportWizardArea.this.keystores.getSelectionIndex() >= 0) {
                    keyStore = (IKeyStore)keystoreList.get(PackageExportWizardArea.this.keystores.getSelectionIndex());
                }
                if (keyStore != null) {
                    PackageExportWizardArea.this.openNewKeyWizard(keyStore, (IJobChangeListener)new CreateKeyJobListener());
                }
                PackageExportWizardArea.this.setEnablement(true);
            }
        });
        this.setEnablement(false);
    }

    protected void populateKeystoresFromView() {
        try {
            List keyStores;
            if (!keystoreList.isEmpty()) {
                keystoreList.clear();
                this.keystores.removeAll();
            }
            if (KeyStoreManager.getInstance() != null && KeyStoreManager.getInstance().getKeyStores() != null && (keyStores = KeyStoreManager.getInstance().getKeyStores()) != null) {
                for (IKeyStore keyStore : keyStores) {
                    this.insertKeystoreIntoCombo(keyStore);
                }
            }
        }
        catch (KeyStoreManagerException e) {
            AndmoreLogger.error(PackageExportWizardArea.class, (String)"Error retrieving keystore list", (Throwable)e);
        }
    }

    protected void insertKeystoreIntoCombo(IKeyStore iKeyStore) {
        File ksFile = iKeyStore.getFile();
        this.keystores.add(String.valueOf(ksFile.getName()) + " - ( " + ksFile.getPath() + " )");
        keystoreList.add(iKeyStore);
    }

    protected void addKeystore(IKeyStore iKeyStore, boolean canSavePassword, String password) {
        this.keystorePasswords.put(iKeyStore, password);
        this.insertKeystoreIntoCombo(iKeyStore);
    }

    private void updateDefaultDestination() {
        ArrayList<IProject> selectedProjects = this.getSelectedProjects();
        if (this.defaultDestination.getSelection()) {
            if (selectedProjects != null && selectedProjects.size() == 1) {
                this.destinationText.setText(selectedProjects.get(0).getLocation().toOSString());
            } else {
                this.destinationText.setText(ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString());
            }
        }
    }

    private ArrayList<IProject> getSelectedProjects() {
        ArrayList<IProject> projects = new ArrayList<IProject>();
        TreeItem[] treeItemArray = this.tree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (item.getChecked()) {
                projects.add((IProject)item.getData());
            }
            ++n2;
        }
        return projects;
    }

    private ArrayList<TreeItem> getSelectedItems() {
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        TreeItem[] treeItemArray = this.tree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (item.getChecked()) {
                items.add(item);
            }
            ++n2;
        }
        return items;
    }

    public void createControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        GridData gridData = new GridData(4, 4, true, true, 3, 1);
        mainComposite.setLayout((Layout)gridLayout);
        mainComposite.setLayoutData((Object)gridData);
        this.tree = new Tree(mainComposite, 2594);
        gridData = new GridData(4, 4, true, true, 2, 2);
        gridData.heightHint = 150;
        this.tree.setLayoutData((Object)gridData);
        this.tree.addListener(13, (Listener)new TreeListener());
        this.populateTree();
        this.selectAllButton = new Button(mainComposite, 8);
        gridData = new GridData(4, 128, false, false, 1, 1);
        this.selectAllButton.setLayoutData((Object)gridData);
        this.selectAllButton.setText(Messages.PACKAGE_EXPORT_WIZARD_AREA_SELECT_ALL_BUTTON);
        this.selectAllButton.addListener(13, (Listener)new TreeSelectionButtonListener(true));
        this.deselectAllButton = new Button(mainComposite, 8);
        gridData = new GridData(4, 128, false, false, 1, 1);
        this.deselectAllButton.setLayoutData((Object)gridData);
        this.deselectAllButton.setText(Messages.PACKAGE_EXPORT_WIZARD_AREA_DESELECT_ALL_BUTTON);
        this.deselectAllButton.addListener(13, (Listener)new TreeSelectionButtonListener(false));
        this.createDestinationGroup(mainComposite);
        if (this.signingEnabled) {
            this.createSignGroup(mainComposite);
        }
        String path = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
        Object prj = this.selection.getFirstElement();
        if (prj != null && this.selection.size() == 1) {
            if (prj instanceof IProject) {
                String realPath = ((IProject)prj).getLocation().toOSString();
                this.destinationText.setText(realPath);
            } else if (prj instanceof IResource) {
                String realPath = String.valueOf(path) + ((IResource)prj).getProject().getFullPath().toOSString();
                this.destinationText.setText(realPath);
            }
        } else {
            this.destinationText.setText(path);
        }
        if (!parent.isFocusControl()) {
            parent.forceFocus();
        }
    }

    private void validateProjects() {
        try {
            IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                if (project.isOpen()) {
                    int projectSev;
                    int sev = project.findMaxProblemSeverity(null, true, 2);
                    switch (sev) {
                        case 2: {
                            projectSev = 3;
                            break;
                        }
                        case 0: {
                            projectSev = 1;
                            break;
                        }
                        case 1: {
                            projectSev = 2;
                            break;
                        }
                        default: {
                            projectSev = 0;
                        }
                    }
                    this.projectSeverity.put(project, new Integer(projectSev));
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {
            AndmoreLogger.error(PackageExportWizardArea.class, (String)"Impossible to get project severity");
        }
    }

    public boolean canFinish() {
        boolean result;
        String messageAux = null;
        int severity_aux = 0;
        if (!this.hasItemChecked()) {
            messageAux = Messages.SELECTOR_MESSAGE_NO_SELECTION;
            severity_aux = this.treeSelectionChanged ? 3 : 1;
        }
        if (messageAux == null) {
            Iterator<IProject> iterator = this.getSelectedProjects().iterator();
            while (iterator.hasNext() && severity_aux != 3) {
                severity_aux = this.projectSeverity.get(iterator.next());
            }
            if (severity_aux == 3) {
                messageAux = Messages.PACKAGE_EXPORT_WIZARD_AREA_PROJECTS_WITH_ERRORS_SELECTED;
            }
        }
        Path path = new Path(this.destinationText.getText());
        if (!this.defaultDestination.getSelection() && messageAux == null) {
            if (this.destinationText.getText().equals("")) {
                messageAux = Messages.SELECTOR_MESSAGE_LOCATION_ERROR_INVALID;
                severity_aux = 1;
            }
            if (messageAux == null && Platform.getOS().equalsIgnoreCase("win32")) {
                if (path.toString().length() > 255) {
                    messageAux = Messages.SELECTOR_MESSAGE_LOCATION_ERROR_PATH_TOO_LONG;
                    severity_aux = 3;
                }
                String device = path.getDevice();
                File deviceFile = null;
                if (device != null) {
                    deviceFile = new File(path.getDevice());
                }
                if (device != null && !deviceFile.exists()) {
                    messageAux = String.valueOf(Messages.SELECTOR_MESSAGE_LOCATION_ERROR_INVALID_DEVICE) + " [" + device + "]";
                    severity_aux = 3;
                }
            }
            if (messageAux == null && !path.isAbsolute()) {
                messageAux = Messages.SELECTOR_MESSAGE_LOCATION_ERROR_INVALID;
                severity_aux = 3;
            }
            if (messageAux == null) {
                String[] stringArray = path.segments();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String folderName = stringArray[n2];
                    if (!ResourcesPlugin.getWorkspace().validateName(folderName, 2).isOK()) {
                        messageAux = Messages.SELECTOR_MESSAGE_LOCATION_ERROR_INVALID;
                        severity_aux = 3;
                    }
                    ++n2;
                }
            }
            if (messageAux == null && path.toFile().exists() && !path.toFile().isDirectory()) {
                messageAux = Messages.SELECTOR_MESSAGE_LOCATION_ERROR_NOT_DIRECTORY;
                severity_aux = 3;
            }
        }
        if (messageAux == null) {
            if (this.signingEnabled && this.signCheckBox != null && this.signCheckBox.getSelection() && (this.keystores == null || this.keystores.getItemCount() <= 0)) {
                messageAux = Messages.PACKAGE_EXPORT_WIZARD_AREA_SIGN_NO_KEYSTORE_AVAILABLE;
                severity_aux = 3;
            } else if (this.signCheckBox.getSelection() && (this.keysCombo == null || this.keysCombo.getItemCount() <= 0 || this.keysCombo.getSelectionIndex() < 0 || this.keysCombo.getItem(this.keysCombo.getSelectionIndex()) == null || this.keysCombo.getItem(this.keysCombo.getSelectionIndex()).equals(""))) {
                messageAux = Messages.PACKAGE_EXPORT_WIZARD_AREA_SIGN_NO_KEYSTORE_OR_KEY_SELECTED;
                severity_aux = 3;
            }
        }
        if (messageAux == null && !this.signCheckBox.getSelection()) {
            messageAux = Messages.PACKAGE_EXPORT_WIZARD_AREA_UNSIGNEDPACKAGE_WARNING;
            severity_aux = 2;
        }
        if (messageAux == null) {
            messageAux = Messages.PACKAGE_EXPORT_WIZARD_AREA_DESCRIPTION;
            severity_aux = 0;
        }
        this.message = messageAux;
        this.severity = severity_aux;
        switch (severity_aux) {
            case 3: {
                result = false;
                break;
            }
            case 2: {
                result = true;
                break;
            }
            case 1: {
                result = false;
                break;
            }
            default: {
                result = true;
            }
        }
        return result;
    }

    private boolean hasItemChecked() {
        boolean checked = false;
        TreeItem[] items = this.tree.getItems();
        int i = 0;
        while (!checked && i < items.length) {
            if (items[i].getChecked()) {
                checked = true;
            }
            ++i;
        }
        return checked;
    }

    private boolean checkDestination() throws CoreException {
        boolean destinationOK = true;
        if (!this.defaultDestination.getSelection()) {
            File destination = new File(this.destinationText.getText());
            if (!destination.exists() && (destinationOK = this.createDestinationFolderDialog()) && !destination.mkdirs()) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.andmore.android.packaging.ui", Messages.PACKAGE_EXPORT_WIZARD_AREA_ERROR_DESTINATION_CHECK));
            }
        } else {
            for (TreeItem item : this.getSelectedItems()) {
                IProject project = (IProject)item.getData();
                IPath dist = project.getLocation().append("dist");
                File file = dist.toFile();
                if (file.exists() && !file.isDirectory() && !file.delete()) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.andmore.android.packaging.ui", Messages.PACKAGE_EXPORT_WIZARD_AREA_ERROR_DESTINATION_CHECK));
                }
                if (!file.exists() && !file.mkdir()) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.andmore.android.packaging.ui", Messages.PACKAGE_EXPORT_WIZARD_AREA_ERROR_DESTINATION_CHECK));
                }
                project.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        return destinationOK;
    }

    private boolean createDestinationFolderDialog() {
        MessageBox box = new MessageBox(this.parentComposite.getShell(), 196);
        box.setMessage(Messages.PACKAGE_EXPORT_WIZARD_AREA_CREATE_DIRECTORIES_BOX_MESSAGE);
        box.setText(Messages.PACKAGE_EXPORT_WIZARD_AREA_CREATE_DIRECTORIES_BOX_TITLE);
        return box.open() == 64;
    }

    public boolean performFinish() {
        final boolean[] finished = new boolean[1];
        boolean destOK = false;
        final MultiStatus status = new MultiStatus("org.eclipse.andmore.android.packaging.ui", 0, "", null);
        ProgressMonitorDialog monitorDialog = null;
        String DESCRIPTION_TO_LOG = "operation_executed";
        try {
            destOK = this.checkDestination();
        }
        catch (CoreException e) {
            status.add(e.getStatus());
        }
        if (destOK) {
            monitorDialog = new ProgressMonitorDialog(this.parentComposite.getShell());
            try {
                monitorDialog.run(false, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor aMonitor) throws InvocationTargetException, InterruptedException {
                        int finishSize = PackageExportWizardArea.this.getSelectedItems().size() * 100;
                        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)aMonitor);
                        monitor.beginTask(Messages.PACKAGE_EXPORT_WIZARD_AREA_FINISH_ACTION_LABEL, finishSize);
                        Path exportDestinationFolder = new Path(PackageExportWizardArea.this.destinationText.getText());
                        IPath exportDestinationFile = null;
                        for (TreeItem item : PackageExportWizardArea.this.getSelectedItems()) {
                            block16: {
                                IProject eclipseProject = (IProject)item.getData();
                                try {
                                    try {
                                        monitor.worked(25);
                                        JavaProject javaProject = new JavaProject();
                                        javaProject.setProject(eclipseProject);
                                        Map apkConfigurations = SdkUtils.getAPKConfigurationsForProject((IProject)eclipseProject);
                                        HashSet<Object> apkConfNames = new HashSet<Object>();
                                        if (apkConfigurations != null) {
                                            apkConfNames.addAll(apkConfigurations.keySet());
                                        }
                                        apkConfNames.add("");
                                        SubMonitor submonitor = monitor.newChild(25);
                                        submonitor.beginTask(Messages.PACKAGE_EXPORT_WIZARD_AREA_EXPORTING_ACTION_LABEL, 300 * apkConfNames.size());
                                        for (String string : apkConfNames) {
                                            String apkName = String.valueOf(eclipseProject.getName()) + (string.isEmpty() ? string : "-" + string);
                                            if (PackageExportWizardArea.this.defaultDestination.getSelection()) {
                                                exportDestinationFolder = eclipseProject.getLocation().append("dist");
                                            }
                                            exportDestinationFile = exportDestinationFolder.append(apkName).addFileExtension("apk");
                                            File file = exportDestinationFile.toFile();
                                            submonitor.worked(100);
                                            AdtUtils.exportUnsignedReleaseApk((IProject)javaProject.getProject(), (File)file, (IProgressMonitor)submonitor);
                                            submonitor.worked(100);
                                            if (PackageExportWizardArea.this.signCheckBox.getSelection()) {
                                                IStatus signStatus = PackageExportWizardArea.this.signPackage(eclipseProject, file);
                                                status.add(signStatus);
                                            }
                                            PackageFile.zipAlign((File)file);
                                            submonitor.worked(100);
                                        }
                                        submonitor.done();
                                    }
                                    catch (CoreException e) {
                                        AndmoreLogger.error(PackageExportWizardArea.class, (String)("Error while building project or getting project output folder" + eclipseProject.getName()), (Throwable)e);
                                        status.add((IStatus)new Status(4, "org.eclipse.andmore.android.packaging.ui", String.valueOf(Messages.PACKAGE_EXPORT_WIZARD_AREA_ERROR_PROJECT_BUILD) + " " + eclipseProject.getName()));
                                        try {
                                            eclipseProject.refreshLocal(2, (IProgressMonitor)monitor.newChild(25));
                                        }
                                        catch (CoreException coreException) {}
                                        break block16;
                                    }
                                }
                                catch (Throwable throwable) {
                                    try {
                                        eclipseProject.refreshLocal(2, (IProgressMonitor)monitor.newChild(25));
                                    }
                                    catch (CoreException coreException) {}
                                    throw throwable;
                                }
                                try {
                                    eclipseProject.refreshLocal(2, (IProgressMonitor)monitor.newChild(25));
                                }
                                catch (CoreException coreException) {}
                            }
                            monitor.worked(25);
                        }
                        finished[0] = true;
                    }
                });
            }
            catch (Exception exception) {
                AndmoreLogger.warn((String)"Error finishing package export.");
            }
        }
        if (!status.isOK()) {
            status.getMessage();
            DESCRIPTION_TO_LOG = Messages.PACKAGE_EXPORT_WIZARD_AREA_READONLY_TITLE;
            ErrorDialog.openError((Shell)this.parentComposite.getShell(), (String)Messages.PACKAGE_EXPORT_WIZARD_AREA_READONLY_TITLE, (String)Messages.PACKAGE_EXPORT_WIZARD_AREA_READONLY_MESSAGE, (IStatus)status);
        }
        try {
            AndmoreLogger.collectUsageData((String)"package", (String)"application_management", (String)DESCRIPTION_TO_LOG, (String)"org.eclipse.andmore.android.packaging.ui", (String)PackagingUIPlugin.getDefault().getBundle().getVersion().toString());
        }
        catch (Throwable throwable) {}
        return finished[0];
    }

    public String getKeyEntryPassword() {
        String keyEntryPassword = new String();
        try {
            keyEntryPassword = this.getSelectedKeyStore().getPasswordProvider().getPassword(this.keysCombo.getItem(this.keysCombo.getSelectionIndex()), true);
        }
        catch (KeyStoreManagerException e) {
            AndmoreLogger.error(this.getClass(), (String)"Error retrieving keys entry password", (Throwable)e);
        }
        return keyEntryPassword;
    }

    private IStatus signPackage(IProject eclipseProject, File exportedPackage) {
        IStatus status;
        block27: {
            status = Status.OK_STATUS;
            String keyAlias = this.keysCombo.getItem(this.keysCombo.getSelectionIndex());
            String keystorePassword = this.getKeyStorePassword(this.getSelectedKeyStore());
            String keyPassword = this.getKeyEntryPassword();
            ZipFile jar = null;
            try {
                try {
                    PackageFile pack = null;
                    boolean keepTrying = keyPassword != null;
                    while (keepTrying) {
                        try {
                            jar = new JarFile(exportedPackage);
                            pack = new PackageFile((JarFile)jar);
                            pack.removeMetaEntryFiles();
                            PackageFileSigner.signPackage((PackageFile)pack, (IKeyStoreEntry)this.getSelectedKeyStore().getEntry(keyAlias, keystorePassword), (String)keyPassword, (String)"Eclipse Andmore");
                            keepTrying = false;
                        }
                        catch (UnrecoverableKeyException unrecoverableKeyException) {
                            try {
                                keyPassword = this.getSelectedKeyStore().getPasswordProvider().getPassword(keyAlias, true, false);
                            }
                            catch (KeyStoreManagerException e) {
                                status = new Status(4, "org.eclipse.andmore.android.certmanager", e.getMessage());
                                AndmoreLogger.error(this.getClass(), (String)("Could not retrieve key password on export: " + e.getMessage()));
                            }
                            if (keyPassword == null) {
                                keepTrying = false;
                                status = Status.CANCEL_STATUS;
                                continue;
                            }
                            keepTrying = true;
                        }
                        catch (InvalidPasswordException e) {
                            status = new Status(4, "org.eclipse.andmore.android.certmanager", e.getMessage());
                        }
                        catch (KeyStoreManagerException e) {
                            status = new Status(4, "org.eclipse.andmore.android.certmanager", e.getMessage());
                        }
                    }
                    if (status.isOK()) {
                        FileOutputStream fileToWrite = null;
                        try {
                            fileToWrite = new FileOutputStream(exportedPackage);
                            pack.write((OutputStream)fileToWrite);
                            break block27;
                        }
                        finally {
                            fileToWrite.close();
                        }
                    }
                    EclipseUtils.showErrorDialog((String)"Package Signing", (String)"Could not sign the package.");
                }
                catch (IOException e) {
                    AndmoreLogger.error(this.getClass(), (String)("Could not sign the package: " + e.getMessage()));
                    status = new Status(4, "org.eclipse.andmore.android.packaging.ui", String.valueOf(Messages.PackageExportWizardArea_ErrorWritingSignedPackageFile) + " " + eclipseProject.getName());
                    try {
                        jar.close();
                    }
                    catch (IOException e2) {
                        AndmoreLogger.error(this.getClass(), (String)("Could not sign the package: " + e2.getMessage()));
                    }
                }
                catch (SignException e) {
                    AndmoreLogger.error(this.getClass(), (String)("Could not sign the package: " + e.getMessage()));
                    status = new Status(4, "org.eclipse.andmore.android.packaging.ui", String.valueOf(Messages.PackageExportWizardArea_ErrorSigningPackage) + " " + eclipseProject.getName());
                    try {
                        jar.close();
                    }
                    catch (IOException e3) {
                        AndmoreLogger.error(this.getClass(), (String)("Could not sign the package: " + e3.getMessage()));
                    }
                }
            }
            finally {
                try {
                    jar.close();
                }
                catch (IOException e) {
                    AndmoreLogger.error(this.getClass(), (String)("Could not sign the package: " + e.getMessage()));
                }
            }
        }
        return status;
    }

    public String getMessage() {
        return this.message;
    }

    public int getSeverity() {
        return this.severity;
    }

    private void setEnablement(boolean notify) {
        boolean signEnabled = this.signCheckBox.getSelection();
        this.keysCombo.setEnabled(signEnabled);
        this.keystores.setEnabled(signEnabled);
        this.buttonAddKey.setEnabled(signEnabled);
        this.buttonExisting.setEnabled(signEnabled);
        this.buttonAddNew.setEnabled(signEnabled);
        if (signEnabled) {
            if (this.keystores.getSelectionIndex() < 0) {
                this.buttonAddKey.setEnabled(false);
                this.keysCombo.setEnabled(false);
                this.keysCombo.removeAll();
            }
            if (this.keystores.getItemCount() <= 0) {
                this.keysCombo.setEnabled(false);
                this.keystores.setEnabled(false);
                this.buttonAddKey.setEnabled(false);
                this.buttonExisting.setEnabled(signEnabled);
                this.buttonAddNew.setEnabled(signEnabled);
            }
        }
        if (notify) {
            this.parentComposite.notifyListeners(24, new Event());
        }
    }

    protected void openSelectKeystoreWizard() {
        SelectExistentKeystoreWizard selectExistentKeystoreWizard = new SelectExistentKeystoreWizard();
        WizardDialog dialog = new WizardDialog(this.parentComposite.getShell(), (IWizard)selectExistentKeystoreWizard);
        dialog.create();
        if (dialog.open() == 0) {
            IKeyStore iKeyStore = selectExistentKeystoreWizard.getSelectedKeystore();
            boolean canSavePassword = selectExistentKeystoreWizard.canSavePassword();
            String password = selectExistentKeystoreWizard.getPassword();
            this.addKeystore(iKeyStore, canSavePassword, password);
            this.selectKeystore(iKeyStore);
        }
    }

    protected String getKeyStorePassword(IKeyStore keystore) {
        String password = this.keystorePasswords.get(keystore);
        if (password == null) {
            password = keystore.getKeyStorePassword(true);
        }
        if (password != null) {
            this.keystorePasswords.put(keystore, password);
        }
        return password;
    }

    private class CreateKeyJobListener
    extends JobChangeAdapter {
        private CreateKeyJobListener() {
        }

        public void done(final IJobChangeEvent event) {
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    IKeyStore keyStore = ((CreateKeyJob)event.getJob()).getKeyStore();
                    String key = ((CreateKeyJob)event.getJob()).getCreatedKeyAlias();
                    PackageExportWizardArea.this.loadKeys(keyStore);
                    PackageExportWizardArea.this.selectKey(key);
                }
            });
        }
    }

    private class CreateKeystoreJobListener
    extends JobChangeAdapter {
        private CreateKeystoreJobListener() {
        }

        public void done(final IJobChangeEvent event) {
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    IKeyStore keyStore = ((CreateKeyJob)event.getJob()).getKeyStore();
                    String key = ((CreateKeyJob)event.getJob()).getCreatedKeyAlias();
                    PackageExportWizardArea.this.loadKeys(keyStore);
                    PackageExportWizardArea.this.selectKeystore(keyStore);
                    PackageExportWizardArea.this.selectKey(key);
                }
            });
        }
    }

    private class DefaultDestinationListener
    implements Listener {
        private DefaultDestinationListener() {
        }

        public void handleEvent(Event event) {
            Button defaultDestination = (Button)event.widget;
            PackageExportWizardArea.this.destinationText.setEnabled(!defaultDestination.getSelection());
            PackageExportWizardArea.this.packageDestinationBrowseButton.setEnabled(!defaultDestination.getSelection());
            if (defaultDestination.getSelection()) {
                PackageExportWizardArea.this.updateDefaultDestination();
            } else {
                PackageExportWizardArea.this.destinationText.setText("");
            }
            PackageExportWizardArea.this.destinationText.notifyListeners(24, new Event());
            PackageExportWizardArea.this.parentComposite.notifyListeners(24, new Event());
        }
    }

    private class DestinationTextListener
    implements Listener {
        private DestinationTextListener() {
        }

        public void handleEvent(Event event) {
            if (!PackageExportWizardArea.this.defaultDestination.getSelection()) {
                PackageExportWizardArea.this.parentComposite.notifyListeners(24, new Event());
            }
        }
    }

    private class PackageDestinationButtonListener
    implements Listener {
        private PackageDestinationButtonListener() {
        }

        public void handleEvent(Event event) {
            String executablePath;
            String path = PackageExportWizardArea.this.destinationText.getText();
            if (path.equals("")) {
                path = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString().subSequence(0, 2).toString();
            }
            if ((executablePath = PackageExportWizardArea.this.directoryDialog(path)) != null && !executablePath.equals("")) {
                PackageExportWizardArea.this.destinationText.setText(executablePath);
            }
            PackageExportWizardArea.this.parentComposite.notifyListeners(24, new Event());
        }
    }

    private class SignButtonListener
    implements Listener {
        private SignButtonListener() {
        }

        public void handleEvent(Event event) {
            if (event.widget == PackageExportWizardArea.this.signCheckBox) {
                PackageExportWizardArea.this.setEnablement(true);
            }
        }
    }

    private class TreeListener
    implements Listener {
        private TreeListener() {
        }

        public void handleEvent(Event event) {
            PackageExportWizardArea.this.updateDefaultDestination();
            PackageExportWizardArea.this.parentComposite.notifyListeners(24, new Event());
            PackageExportWizardArea.this.treeSelectionChanged = true;
        }
    }

    private class TreeSelectionButtonListener
    implements Listener {
        private final boolean checked;

        public TreeSelectionButtonListener(boolean selectItems) {
            this.checked = selectItems;
        }

        public void handleEvent(Event event) {
            TreeItem[] treeItemArray = PackageExportWizardArea.this.tree.getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                item.setChecked(this.checked);
                ++n2;
            }
            PackageExportWizardArea.this.updateDefaultDestination();
            PackageExportWizardArea.this.parentComposite.notifyListeners(24, new Event());
            PackageExportWizardArea.this.treeSelectionChanged = true;
        }
    }
}

