/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.ddms.editors;

import com.android.uiautomator.UiAutomatorHelper;
import com.android.uiautomator.UiAutomatorModel;
import com.android.uiautomator.UiAutomatorView;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.andmore.base.InstallDetails;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.EditorPart;

public class UiAutomatorViewer
extends EditorPart {
    private String mFilePath;
    private UiAutomatorView mView;

    public void doSave(IProgressMonitor arg0) {
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isDirty() {
        return false;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof IURIEditorInput)) {
            throw new PartInitException("UI Automator Hierarchy View: unsupported input type.");
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.mFilePath = ((IURIEditorInput)input).getURI().getPath();
        File f = new File(this.mFilePath);
        this.setPartName(f.getName());
    }

    public void createPartControl(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new GridLayout(1, false));
        GridData gd = new GridData(1808);
        c.setLayoutData((Object)gd);
        this.mView = new UiAutomatorView(c, 2048);
        this.mView.setLayoutData((Object)new GridData(1808));
        if (this.mFilePath == null) {
            return;
        }
        UiAutomatorModel model = null;
        File modelFile = new File(this.mFilePath);
        try {
            model = new UiAutomatorModel(modelFile);
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)parent.getShell(), (String)("Error opening " + this.mFilePath), (String)("Unexpected error while parsing input: " + e.getMessage()));
            return;
        }
        this.mView.setModel(model, modelFile, null);
    }

    public void setFocus() {
    }

    public static boolean openEditor(final UiAutomatorHelper.UiAutomatorResult r) {
        final IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)new Path(r.uiHierarchy.getAbsolutePath()));
        if (!fileStore.fetchInfo().exists()) {
            return false;
        }
        final AtomicBoolean status = new AtomicBoolean(false);
        final IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                if (window == null) {
                    return;
                }
                IWorkbenchPage page = window.getActivePage();
                if (page == null) {
                    return;
                }
                if (!page.isEditorAreaVisible() && InstallDetails.isAdtInstalled()) {
                    try {
                        workbench.showPerspective("org.eclipse.jdt.ui.JavaPerspective", window);
                    }
                    catch (WorkbenchException workbenchException) {}
                }
                IEditorPart editor = null;
                try {
                    editor = IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
                }
                catch (PartInitException partInitException) {
                    return;
                }
                if (!(editor instanceof UiAutomatorViewer)) {
                    return;
                }
                ((UiAutomatorViewer)editor).setModel(r.model, r.uiHierarchy, r.screenshot);
                status.set(true);
            }
        });
        return status.get();
    }

    protected void setModel(UiAutomatorModel model, File modelFile, Image screenshot) {
        this.mView.setModel(model, modelFile, screenshot);
    }
}

