/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.ddms;

import com.android.ddmlib.Log;
import org.eclipse.andmore.ddms.DdmsPlugin;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class LogCatMonitorDialog
extends TitleAreaDialog {
    private static final String TITLE = "Auto Monitor Logcat";
    private static final String DEFAULT_MESSAGE = "Would you like ADT to automatically monitor logcat " + DdmsPlugin.NEWLINE + "output for messages from applications in the workspace?";
    private boolean mShouldMonitor = true;
    private static final String[] LOG_PRIORITIES = new String[]{Log.LogLevel.VERBOSE.getStringValue(), Log.LogLevel.DEBUG.getStringValue(), Log.LogLevel.INFO.getStringValue(), Log.LogLevel.WARN.getStringValue(), Log.LogLevel.ERROR.getStringValue(), Log.LogLevel.ASSERT.getStringValue()};
    private static final int ERROR_PRIORITY_INDEX = 4;
    private String mMinimumLogPriority = LOG_PRIORITIES[4];

    public LogCatMonitorDialog(Shell parentShell) {
        super(parentShell);
        this.setHelpAvailable(false);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(TITLE);
        this.setMessage(DEFAULT_MESSAGE);
        parent = (Composite)super.createDialogArea(parent);
        Composite c = new Composite(parent, 2048);
        c.setLayout((Layout)new GridLayout(2, false));
        GridData gd_c = new GridData(1808);
        gd_c.grabExcessVerticalSpace = false;
        gd_c.grabExcessHorizontalSpace = false;
        c.setLayoutData((Object)gd_c);
        Button disableButton = new Button(c, 16);
        disableButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        disableButton.setText("No, do not monitor logcat output.");
        final Button enableButton = new Button(c, 16);
        enableButton.setText("Yes, monitor logcat and display logcat view if there are" + DdmsPlugin.NEWLINE + "messages with priority higher than:");
        enableButton.setSelection(true);
        final Combo levelCombo = new Combo(c, 12);
        levelCombo.setItems(LOG_PRIORITIES);
        levelCombo.select(4);
        SelectionAdapter s = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.getSource() == enableButton) {
                    LogCatMonitorDialog.this.mShouldMonitor = enableButton.getSelection();
                    levelCombo.setEnabled(LogCatMonitorDialog.this.mShouldMonitor);
                } else if (e.getSource() == levelCombo) {
                    LogCatMonitorDialog.this.mMinimumLogPriority = LOG_PRIORITIES[levelCombo.getSelectionIndex()];
                }
            }
        };
        levelCombo.addSelectionListener((SelectionListener)s);
        enableButton.addSelectionListener((SelectionListener)s);
        return parent;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    public boolean shouldMonitor() {
        return this.mShouldMonitor;
    }

    public String getMinimumPriority() {
        return this.mMinimumLogPriority;
    }
}

