/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.vnc.vncviewer.graphics.swt.img;

import java.io.DataInput;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.sequoyah.vnc.vncviewer.graphics.IPainterContext;
import org.eclipse.sequoyah.vnc.vncviewer.graphics.swt.ISWTPainter;
import org.eclipse.sequoyah.vnc.vncviewer.graphics.swt.img.SWTRemoteDisplayImg;
import org.eclipse.sequoyah.vnc.vncviewer.network.AbstractVNCPainter;
import org.eclipse.sequoyah.vnc.vncviewer.network.PixelFormat;
import org.eclipse.sequoyah.vnc.vncviewer.network.RectHeader;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.widgets.Display;

public class Painter
extends AbstractVNCPainter
implements ISWTPainter {
    protected Image image;
    protected ImageData imgData;
    protected GC imageGC;
    protected PaletteData paletteData;
    private Display display;
    private List<SWTRemoteDisplayImg> remoteDisplays = new ArrayList<SWTRemoteDisplayImg>();

    public void addSWTRemoteDisplayImg(SWTRemoteDisplayImg sWTRemoteDisplayImg) {
        this.remoteDisplays.add(sWTRemoteDisplayImg);
    }

    public void removeSWTRemoteDisplayImg(SWTRemoteDisplayImg sWTRemoteDisplayImg) {
        this.remoteDisplays.remove(sWTRemoteDisplayImg);
    }

    public Painter(SWTRemoteDisplayImg sWTRemoteDisplayImg) {
        this.display = sWTRemoteDisplayImg.getDisplay();
    }

    public void setPixelFormat(PixelFormat pixelFormat) {
        super.setPixelFormat(pixelFormat);
        this.paletteData = new PaletteData(pixelFormat.getRedMax() << pixelFormat.getRedShift(), pixelFormat.getGreenMax() << pixelFormat.getGreenShift(), pixelFormat.getBlueMax() << pixelFormat.getBlueShift());
    }

    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        this.dispose();
        this.image = new Image((Device)this.display, n, n2);
        this.imageGC = new GC((Drawable)this.image);
        this.imgData = new ImageData(n, n2, this.pixelFormat.getDepth(), this.paletteData);
    }

    protected void fillRect(int n, int n2, int n3, int n4, int n5) {
        int[] nArray = new int[n4];
        int n6 = 0;
        while (n6 < n4) {
            nArray[n6] = n;
            ++n6;
        }
        n6 = 0;
        while (n6 < n5) {
            this.imgData.setPixels(n2, n3 + n6, n4, nArray, 0);
            ++n6;
        }
    }

    protected void setPixels(int n, int n2, int n3, int[] nArray, int n4) {
    }

    protected void setPixels(int n, int n2, int n3, int n4, int[] nArray, int n5) {
        int n6 = 0;
        while (n6 < n4) {
            this.imgData.setPixels(n, n2 + n6, n3, nArray, n3 * n6);
            ++n6;
        }
    }

    public void updateRectangle(int n, int n2, int n3, int n4) {
        for (SWTRemoteDisplayImg sWTRemoteDisplayImg : this.remoteDisplays) {
            double d = sWTRemoteDisplayImg.getZoomFactor();
            int n5 = (int)((double)n * d);
            int n6 = (int)((double)n2 * d);
            int n7 = (int)((double)(n3 - n) * d);
            int n8 = (int)((double)(n4 - n2) * d);
            sWTRemoteDisplayImg.redrawScreen(--n5, --n6, ++n7, ++n8);
        }
    }

    protected IPainterContext getPainterContext() {
        return new IPainterContext(){

            public void fillRect(int n, int n2, int n3, int n4, int n5) {
                Painter.this.fillRect(n, n2, n3, n4, n5);
            }

            public PixelFormat getPixelFormat() {
                return Painter.this.getPixelFormat();
            }

            public int getBytesPerPixel() {
                return Painter.this.bytesPerPixel;
            }

            public void processRectangle(RectHeader rectHeader, DataInput dataInput) throws Exception {
                Painter.this.processRectangle(rectHeader, dataInput);
            }

            public int readPixel(DataInput dataInput) throws Exception {
                return Painter.this.readPixel(dataInput);
            }

            public int readPixel(DataInput dataInput, int n) throws Exception {
                return Painter.this.readPixel(dataInput, n);
            }

            public void setPixels(int n, int n2, int n3, int n4, int[] nArray, int n5) {
                Painter.this.setPixels(n, n2, n3, n4, nArray, n5);
            }

            public int[] readpixels(DataInput dataInput, int n, int n2) throws Exception {
                return Painter.this.readPixels(dataInput, n, n2);
            }
        };
    }

    public void dispose() {
        if (this.image != null) {
            this.image.dispose();
            this.image = null;
        }
        if (this.imageGC != null) {
            this.imageGC.dispose();
            this.imageGC = null;
        }
    }

    public ImageData getImageData() {
        return this.imgData;
    }
}

