/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.mat.panes;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.andmore.android.AndroidPlugin;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.mat.i18n.MatNLS;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.registry.ArgumentSet;
import org.eclipse.mat.query.registry.QueryDescriptor;
import org.eclipse.mat.query.registry.QueryRegistry;
import org.eclipse.mat.query.registry.QueryResult;
import org.eclipse.mat.snapshot.IOQLQuery;
import org.eclipse.mat.snapshot.OQLParseException;
import org.eclipse.mat.snapshot.SnapshotFactory;
import org.eclipse.mat.ui.Messages;
import org.eclipse.mat.ui.editor.AbstractEditorPane;
import org.eclipse.mat.ui.editor.AbstractPaneJob;
import org.eclipse.mat.ui.editor.CompositeHeapEditorPane;
import org.eclipse.mat.ui.editor.EditorPaneRegistry;
import org.eclipse.mat.ui.util.ErrorHelper;
import org.eclipse.mat.ui.util.PaneState;
import org.eclipse.mat.ui.util.ProgressMonitorWrapper;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class AndmorePane
extends CompositeHeapEditorPane {
    private String queryFirstPart = "select * from \"";
    private String querySecondPart = ".*\"";
    private String queryString;
    private static final String PANE_TITLE = MatNLS.Andmore_Pane_Title;
    public static final String ANDMORE_PANE_ID = "org.eclipse.andmore.android.mat.AndmorePane";
    private Action executeAction;

    public void createPartControl(Composite parent) {
        this.createContainer(parent);
        String selectedApp = this.getEditorInput().getName().substring(this.getEditorInput().getName().lastIndexOf(File.separator) + 1);
        this.queryString = String.valueOf(this.queryFirstPart) + AndroidPlugin.getDefault().getPreferenceStore().getString(selectedApp) + this.querySecondPart;
        this.makeActions();
    }

    private void makeActions() {
        this.executeAction = new ExecuteQueryAction();
        this.executeAction.run();
    }

    public String getTitle() {
        return PANE_TITLE;
    }

    public void initWithArgument(Object param) {
        if (param instanceof String) {
            this.queryString = (String)param;
            this.executeAction.run();
        } else if (param instanceof QueryResult) {
            QueryResult queryResult = (QueryResult)param;
            this.initQueryResult(queryResult, null);
        } else if (param instanceof PaneState) {
            this.queryString = ((PaneState)param).getIdentifier();
            new ExecuteQueryAction((PaneState)param).run();
        }
    }

    private void initQueryResult(QueryResult queryResult, PaneState state) {
        IOQLQuery.Result subject = (IOQLQuery.Result)queryResult.getSubject();
        this.queryString = subject.getOQLQuery();
        AbstractEditorPane pane = EditorPaneRegistry.instance().createNewPane((IResult)subject, ((Object)((Object)this)).getClass());
        if (state == null) {
            for (PaneState child : this.getPaneState().getChildren()) {
                if (!this.queryString.equals(child.getIdentifier())) continue;
                state = child;
                break;
            }
            if (state == null) {
                state = new PaneState(PaneState.PaneType.COMPOSITE_CHILD, this.getPaneState(), this.queryString, true);
                state.setImage(this.getTitleImage());
            }
        }
        pane.setPaneState(state);
        this.createResultPane(pane, queryResult);
    }

    public void createExceptionPane(Exception cause, String queryString) throws PartInitException {
        StringBuilder buf = new StringBuilder(256);
        buf.append(Messages.OQLPane_ExecutedQuery);
        buf.append(queryString);
        Throwable t = null;
        if (cause instanceof SnapshotException) {
            buf.append(Messages.OQLPane_ProblemReported);
            buf.append(cause.getMessage());
            t = cause.getCause();
        } else {
            t = cause;
        }
        if (t != null) {
            StringWriter w = null;
            PrintWriter o = null;
            try {
                buf.append("\n\n");
                w = new StringWriter();
                o = new PrintWriter(w);
                t.printStackTrace(o);
                o.flush();
                buf.append(w.toString());
            }
            finally {
                try {
                    w.close();
                    o.close();
                }
                catch (IOException e) {
                    AndmoreLogger.error((String)e.getMessage());
                }
            }
        }
        try {
            AbstractEditorPane pane = EditorPaneRegistry.instance().createNewPane("TextViewPane");
            if (pane == null) {
                throw new PartInitException(Messages.OQLPane_PaneNotFound);
            }
            this.createResultPane(pane, buf.toString());
        }
        catch (CoreException e) {
            throw new PartInitException(ErrorHelper.createErrorStatus((Throwable)e));
        }
    }

    private class ExecuteQueryAction
    extends Action {
        private PaneState state;

        public ExecuteQueryAction() {
            this(null);
        }

        public ExecuteQueryAction(PaneState state) {
            this.state = state;
        }

        public void run() {
            try {
                String query = AndmorePane.this.queryString;
                try {
                    SnapshotFactory.createQuery((String)query);
                    new OQLJob((AbstractEditorPane)AndmorePane.this, query, this.state).schedule();
                }
                catch (OQLParseException e) {
                    AndmorePane.this.createExceptionPane((Exception)((Object)e), query);
                }
                catch (Exception e) {
                    AndmorePane.this.createExceptionPane(e, query);
                }
            }
            catch (PartInitException e1) {
                ErrorHelper.logThrowableAndShowMessage((Throwable)e1, (String)Messages.OQLPane_ErrorExecutingQuery);
            }
        }
    }

    class OQLJob
    extends AbstractPaneJob {
        String queryString;
        PaneState state;

        public OQLJob(AbstractEditorPane pane, String queryString, PaneState state) {
            super(queryString.toString(), pane);
            this.queryString = queryString;
            this.state = state;
            this.setUser(true);
        }

        protected IStatus doRun(IProgressMonitor monitor) {
            try {
                QueryDescriptor descriptor = QueryRegistry.instance().getQuery("oql");
                ArgumentSet argumentSet = descriptor.createNewArgumentSet(AndmorePane.this.getEditor().getQueryContext());
                argumentSet.setArgumentValue("queryString", (Object)this.queryString);
                final QueryResult result = argumentSet.execute((IProgressListener)new ProgressMonitorWrapper(monitor));
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        AndmorePane.this.initQueryResult(result, OQLJob.this.state);
                    }
                });
            }
            catch (Exception e) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            AndmorePane.this.createExceptionPane(e, OQLJob.this.queryString);
                        }
                        catch (PartInitException pie) {
                            ErrorHelper.logThrowable((Throwable)pie);
                        }
                    }
                });
            }
            return Status.OK_STATUS;
        }
    }
}

