/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.workingsets;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.internal.ui.workingsets.WorkingSetConfigurationDialog;
import org.eclipse.jdt.internal.ui.workingsets.WorkingSetMessages;
import org.eclipse.jdt.internal.ui.workingsets.WorkingSetModel;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetNewWizard;
import org.eclipse.ui.dialogs.SelectionDialog;

public final class ConfigureWorkingSetAssignementAction
extends SelectionDispatchAction {
    private static final String[] VALID_WORKING_SET_IDS = new String[]{"org.eclipse.jdt.ui.JavaWorkingSetPage", "org.eclipse.ui.resourceWorkingSetPage"};
    private WorkingSetModel fWorkingSetModel;
    private final IWorkbenchSite fSite;

    public ConfigureWorkingSetAssignementAction(IWorkbenchSite site) {
        super(site);
        this.fSite = site;
        this.setText(WorkingSetMessages.ConfigureWorkingSetAssignementAction_WorkingSets_actionLabel);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.assign_working_sets_action_context");
        this.setEnabled(false);
    }

    public void setWorkingSetModel(WorkingSetModel workingSetModel) {
        this.fWorkingSetModel = workingSetModel;
    }

    @Override
    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.canEnable(selection));
    }

    private boolean canEnable(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        List list = selection.toList();
        for (Object object : list) {
            if (object instanceof IResource || object instanceof IJavaElement) continue;
            return false;
        }
        return true;
    }

    private IAdaptable[] getSelectedElements(IStructuredSelection selection) {
        ArrayList result = new ArrayList();
        List list = selection.toList();
        for (Object object : list) {
            if (!(object instanceof IResource) && !(object instanceof IJavaElement)) continue;
            result.add(object);
        }
        return result.toArray(new IAdaptable[result.size()]);
    }

    @Override
    public void run(IStructuredSelection selection) {
        IAdaptable[] elements = this.getSelectedElements(selection);
        GrayedCheckedModel model = ConfigureWorkingSetAssignementAction.createGrayedCheckedModel(elements, this.getAllWorkingSets(), null);
        WorkingSetModelAwareSelectionDialog dialog = new WorkingSetModelAwareSelectionDialog(this.fSite.getShell(), model, elements);
        if (elements.length == 1) {
            IAdaptable element = elements[0];
            String elementName = element instanceof IResource ? BasicElementLabels.getResourceName((IResource)element) : JavaElementLabels.getElementLabel((IJavaElement)element, JavaElementLabels.ALL_DEFAULT);
            dialog.setMessage(Messages.format(WorkingSetMessages.ConfigureWorkingSetAssignementAction_DialogMessage_specific, elementName));
        } else {
            dialog.setMessage(Messages.format(WorkingSetMessages.ConfigureWorkingSetAssignementAction_DialogMessage_multi, new Integer(elements.length)));
        }
        if (dialog.open() == 0) {
            this.updateWorkingSets(dialog.getSelection(), dialog.getGrayed(), elements);
            this.selectAndReveal(elements);
        }
    }

    private static GrayedCheckedModel createGrayedCheckedModel(IAdaptable[] elements, IWorkingSet[] workingSets, Set<IWorkingSet> checkedWorkingSets) {
        GrayedCheckedModelElement[] result = new GrayedCheckedModelElement[workingSets.length];
        int i = 0;
        while (i < workingSets.length) {
            IWorkingSet workingSet = workingSets[i];
            int checkCount = 0;
            int j = 0;
            while (j < elements.length) {
                if (checkedWorkingSets == null) {
                    IAdaptable adapted = ConfigureWorkingSetAssignementAction.adapt(workingSet, elements[j]);
                    if (adapted != null && ConfigureWorkingSetAssignementAction.contains(workingSet, adapted)) {
                        ++checkCount;
                    }
                } else if (checkedWorkingSets.contains(workingSet)) {
                    ++checkCount;
                }
                ++j;
            }
            result[i] = new GrayedCheckedModelElement(workingSet, checkCount, elements.length);
            ++i;
        }
        return new GrayedCheckedModel(result);
    }

    private void updateWorkingSets(IWorkingSet[] newWorkingSets, IWorkingSet[] grayedWorkingSets, IAdaptable[] elements) {
        HashSet<IWorkingSet> selectedSets = new HashSet<IWorkingSet>(Arrays.asList(newWorkingSets));
        HashSet<IWorkingSet> grayedSets = new HashSet<IWorkingSet>(Arrays.asList(grayedWorkingSets));
        IWorkingSet[] workingSets = this.getAllWorkingSets();
        int i = 0;
        while (i < workingSets.length) {
            IWorkingSet workingSet = workingSets[i];
            if (ConfigureWorkingSetAssignementAction.isValidWorkingSet(workingSet) && !selectedSets.contains(workingSet) && !grayedSets.contains(workingSet)) {
                int j = 0;
                while (j < elements.length) {
                    IAdaptable adapted = ConfigureWorkingSetAssignementAction.adapt(workingSet, elements[j]);
                    if (adapted != null && ConfigureWorkingSetAssignementAction.contains(workingSet, adapted)) {
                        ConfigureWorkingSetAssignementAction.remove(workingSet, adapted);
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < newWorkingSets.length) {
            IWorkingSet set = newWorkingSets[i];
            if (ConfigureWorkingSetAssignementAction.isValidWorkingSet(set) && !grayedSets.contains(set)) {
                ArrayList<IWorkingSet> activeWorkingSets;
                IWorkingSet[] activeSets;
                boolean checkForYetHiddenWorkingSet = false;
                int j = 0;
                while (j < elements.length) {
                    IAdaptable adapted = ConfigureWorkingSetAssignementAction.adapt(set, elements[j]);
                    if (adapted != null && !ConfigureWorkingSetAssignementAction.contains(set, adapted)) {
                        ConfigureWorkingSetAssignementAction.add(set, adapted);
                        checkForYetHiddenWorkingSet = true;
                    }
                    ++j;
                }
                if (checkForYetHiddenWorkingSet && (activeSets = this.getActiveWorkingSets()) != null && !(activeWorkingSets = new ArrayList<IWorkingSet>(Arrays.asList(activeSets))).contains(set)) {
                    this.activateWorkingSet(set);
                }
            }
            ++i;
        }
    }

    private void activateWorkingSet(IWorkingSet workingSet) {
        if (this.fWorkingSetModel != null) {
            this.fWorkingSetModel.addActiveWorkingSet(workingSet);
        } else {
            PackageExplorerPart activePart = this.getActivePackageExplorer();
            if (activePart != null) {
                activePart.getWorkingSetModel().addActiveWorkingSet(workingSet);
            }
        }
    }

    private IWorkingSet[] getActiveWorkingSets() {
        if (this.fWorkingSetModel != null) {
            return this.fWorkingSetModel.getActiveWorkingSets();
        }
        WorkingSetModel model = null;
        PackageExplorerPart activePart = this.getActivePackageExplorer();
        if (activePart != null) {
            model = activePart.getWorkingSetModel();
        }
        return model == null ? null : model.getActiveWorkingSets();
    }

    private IWorkingSet[] getAllWorkingSets() {
        if (this.fWorkingSetModel != null) {
            return this.fWorkingSetModel.getAllWorkingSets();
        }
        return PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSets();
    }

    private static boolean isValidWorkingSet(IWorkingSet set) {
        if (set.isAggregateWorkingSet() || !set.isSelfUpdating()) {
            return false;
        }
        if (!set.isVisible()) {
            return false;
        }
        if (!set.isEditable()) {
            return false;
        }
        int i = 0;
        while (i < VALID_WORKING_SET_IDS.length) {
            if (VALID_WORKING_SET_IDS[i].equals(set.getId())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static IAdaptable adapt(IWorkingSet set, IAdaptable element) {
        IAdaptable[] adaptedElements = set.adaptElements(new IAdaptable[]{element});
        if (adaptedElements.length != 1) {
            return null;
        }
        return adaptedElements[0];
    }

    private static boolean contains(IWorkingSet set, IAdaptable adaptedElement) {
        IAdaptable[] elements = set.getElements();
        int i = 0;
        while (i < elements.length) {
            if (elements[i].equals(adaptedElement)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static void remove(IWorkingSet workingSet, IAdaptable adaptedElement) {
        HashSet<IAdaptable> set = new HashSet<IAdaptable>(Arrays.asList(workingSet.getElements()));
        set.remove(adaptedElement);
        workingSet.setElements(set.toArray(new IAdaptable[set.size()]));
    }

    private static void add(IWorkingSet workingSet, IAdaptable adaptedElement) {
        IAdaptable[] elements = workingSet.getElements();
        IAdaptable[] newElements = new IAdaptable[elements.length + 1];
        System.arraycopy(elements, 0, newElements, 0, elements.length);
        newElements[elements.length] = adaptedElement;
        workingSet.setElements(newElements);
    }

    private void selectAndReveal(IAdaptable[] elements) {
        PackageExplorerPart explorer = this.getActivePackageExplorer();
        if (explorer != null) {
            explorer.selectReveal((ISelection)new StructuredSelection((Object[])elements));
        }
    }

    private PackageExplorerPart getActivePackageExplorer() {
        IWorkbenchPart activePart;
        IWorkbenchPage page = JavaPlugin.getActivePage();
        if (page != null && (activePart = page.getActivePart()) instanceof PackageExplorerPart) {
            return (PackageExplorerPart)activePart;
        }
        return null;
    }

    private static final class GrayedCheckedModel {
        private ArrayList<GrayedCheckedModelElement> fElements;

        public GrayedCheckedModel(GrayedCheckedModelElement[] elements) {
            this.fElements = new ArrayList<GrayedCheckedModelElement>(Arrays.asList(elements));
        }

        public void addElement(GrayedCheckedModelElement element) {
            this.fElements.add(element);
        }

        public GrayedCheckedModelElement[] getElements() {
            return this.fElements.toArray(new GrayedCheckedModelElement[this.fElements.size()]);
        }

        public GrayedCheckedModelElement[] getChecked() {
            ArrayList<GrayedCheckedModelElement> result = new ArrayList<GrayedCheckedModelElement>();
            int i = 0;
            while (i < this.fElements.size()) {
                if (this.fElements.get(i).isChecked()) {
                    result.add(this.fElements.get(i));
                }
                ++i;
            }
            return result.toArray(new GrayedCheckedModelElement[result.size()]);
        }

        public GrayedCheckedModelElement[] getGrayed() {
            ArrayList<GrayedCheckedModelElement> result = new ArrayList<GrayedCheckedModelElement>();
            int i = 0;
            while (i < this.fElements.size()) {
                if (this.fElements.get(i).isGrayed()) {
                    result.add(this.fElements.get(i));
                }
                ++i;
            }
            return result.toArray(new GrayedCheckedModelElement[result.size()]);
        }

        public void selectAll() {
            int i = 0;
            while (i < this.fElements.size()) {
                this.fElements.get(i).select();
                ++i;
            }
        }

        public void deselectAll() {
            int i = 0;
            while (i < this.fElements.size()) {
                this.fElements.get(i).deselect();
                ++i;
            }
        }
    }

    private static final class GrayedCheckedModelContentProvider
    implements IStructuredContentProvider {
        private GrayedCheckedModelElement[] fElements;

        private GrayedCheckedModelContentProvider() {
        }

        public Object[] getElements(Object element) {
            return this.fElements;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.fElements = newInput instanceof GrayedCheckedModel ? ((GrayedCheckedModel)newInput).getElements() : new GrayedCheckedModelElement[0];
        }
    }

    private static final class GrayedCheckedModelElement {
        private final IWorkingSet fWorkingSet;
        private final int fElementCount;
        private int fCheckCount;

        public GrayedCheckedModelElement(IWorkingSet workingSet, int checkCount, int elementCount) {
            this.fWorkingSet = workingSet;
            this.fCheckCount = checkCount;
            this.fElementCount = elementCount;
        }

        public IWorkingSet getWorkingSet() {
            return this.fWorkingSet;
        }

        public int getCheckCount() {
            return this.fCheckCount;
        }

        public boolean isGrayed() {
            return this.isChecked() && this.fCheckCount < this.fElementCount;
        }

        public boolean isChecked() {
            return this.fCheckCount > 0;
        }

        public void deselect() {
            this.fCheckCount = 0;
        }

        public void select() {
            this.fCheckCount = this.fElementCount;
        }

        public int getElementCount() {
            return this.fElementCount;
        }
    }

    private class GrayedCheckedModelLabelProvider
    extends LabelProvider {
        private Map<ImageDescriptor, Image> fIcons = new Hashtable<ImageDescriptor, Image>();

        public void dispose() {
            for (Image icon : this.fIcons.values()) {
                icon.dispose();
            }
            super.dispose();
        }

        public Image getImage(Object object) {
            IWorkingSet workingSet = ((GrayedCheckedModelElement)object).getWorkingSet();
            ImageDescriptor imageDescriptor = workingSet.getImageDescriptor();
            if (imageDescriptor == null) {
                return null;
            }
            Image icon = this.fIcons.get(imageDescriptor);
            if (icon == null) {
                icon = imageDescriptor.createImage();
                this.fIcons.put(imageDescriptor, icon);
            }
            return icon;
        }

        public String getText(Object object) {
            GrayedCheckedModelElement modelElement = (GrayedCheckedModelElement)object;
            IWorkingSet workingSet = modelElement.getWorkingSet();
            if (!modelElement.isGrayed()) {
                return BasicElementLabels.getWorkingSetLabel(workingSet);
            }
            return Messages.format(WorkingSetMessages.ConfigureWorkingSetAssignementAction_XofY_label, new Object[]{BasicElementLabels.getWorkingSetLabel(workingSet), new Integer(modelElement.getCheckCount()), new Integer(modelElement.getElementCount())});
        }
    }

    private final class WorkingSetModelAwareSelectionDialog
    extends SelectionDialog {
        private static final String DIALOG_SETTINGS_SECTION = "WorkingSetModelAwareSelectionDialog";
        private static final String SETTINGS_SHOW_VISIBLE_ONLY = "ShowVisibleOnly";
        private CheckboxTableViewer fTableViewer;
        private boolean fShowVisibleOnly;
        private GrayedCheckedModel fModel;
        private final IAdaptable[] fElements;
        private final ArrayList<IWorkingSet> fCreatedWorkingSets;
        private IDialogSettings fSettings;

        private WorkingSetModelAwareSelectionDialog(Shell shell, GrayedCheckedModel model, IAdaptable[] elements) {
            super(shell);
            this.setTitle(WorkingSetMessages.ConfigureWorkingSetAssignementAction_WorkingSetAssignments_title);
            this.fModel = model;
            this.fElements = elements;
            this.fCreatedWorkingSets = new ArrayList();
            this.fSettings = JavaPlugin.getDefault().getDialogSettingsSection(DIALOG_SETTINGS_SECTION);
            if (this.fSettings.get(SETTINGS_SHOW_VISIBLE_ONLY) == null) {
                this.fSettings.put(SETTINGS_SHOW_VISIBLE_ONLY, true);
            }
            this.fShowVisibleOnly = this.fSettings.getBoolean(SETTINGS_SHOW_VISIBLE_ONLY);
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.jdt.ui.working_set_assignments_dialog_context");
        }

        public IWorkingSet[] getGrayed() {
            GrayedCheckedModelElement[] grayed = this.fModel.getGrayed();
            IWorkingSet[] result = new IWorkingSet[grayed.length];
            int i = 0;
            while (i < grayed.length) {
                result[i] = grayed[i].getWorkingSet();
                ++i;
            }
            return result;
        }

        public IWorkingSet[] getSelection() {
            GrayedCheckedModelElement[] checked = this.fModel.getChecked();
            IWorkingSet[] result = new IWorkingSet[checked.length];
            int i = 0;
            while (i < checked.length) {
                result[i] = checked[i].getWorkingSet();
                ++i;
            }
            return result;
        }

        protected final Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            this.createMessageArea(composite);
            Composite inner = new Composite(composite, 0);
            inner.setLayoutData((Object)new GridData(1808));
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            inner.setLayout((Layout)layout);
            Composite tableComposite = new Composite(inner, 0);
            tableComposite.setLayoutData((Object)new GridData(4, 4, true, true));
            layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            tableComposite.setLayout((Layout)layout);
            this.fTableViewer = this.createTableViewer(tableComposite);
            this.createShowVisibleOnly(tableComposite);
            this.createRightButtonBar(inner);
            Dialog.applyDialogFont((Control)composite);
            return composite;
        }

        protected void createRightButtonBar(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(1040));
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            composite.setLayout((Layout)layout);
            Button selectAll = new Button(composite, 8);
            selectAll.setText(WorkingSetMessages.ConfigureWorkingSetAssignementAction_SelectAll_button);
            this.setButtonLayoutData(selectAll);
            selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    WorkingSetModelAwareSelectionDialog.this.fTableViewer.setAllChecked(true);
                    WorkingSetModelAwareSelectionDialog.this.fModel.selectAll();
                    WorkingSetModelAwareSelectionDialog.this.fTableViewer.setGrayedElements(new Object[0]);
                    WorkingSetModelAwareSelectionDialog.this.fTableViewer.refresh();
                }
            });
            Button deselectAll = new Button(composite, 8);
            deselectAll.setText(WorkingSetMessages.ConfigureWorkingSetAssignementAction_DeselectAll_button);
            this.setButtonLayoutData(deselectAll);
            deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    WorkingSetModelAwareSelectionDialog.this.fTableViewer.setAllChecked(false);
                    WorkingSetModelAwareSelectionDialog.this.fModel.deselectAll();
                    WorkingSetModelAwareSelectionDialog.this.fTableViewer.setGrayedElements(new Object[0]);
                    WorkingSetModelAwareSelectionDialog.this.fTableViewer.refresh();
                }
            });
            new Label(composite, 0);
            Button newWorkingSet = new Button(composite, 8);
            newWorkingSet.setText(WorkingSetMessages.ConfigureWorkingSetAssignementAction_New_button);
            this.setButtonLayoutData(newWorkingSet);
            newWorkingSet.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IWorkingSet workingSet;
                    IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
                    IWorkingSetNewWizard wizard = manager.createWorkingSetNewWizard(VALID_WORKING_SET_IDS);
                    if (wizard == null) {
                        return;
                    }
                    WizardDialog dialog = new WizardDialog(WorkingSetModelAwareSelectionDialog.this.getShell(), (IWizard)wizard);
                    dialog.create();
                    if (dialog.open() == 0 && ConfigureWorkingSetAssignementAction.isValidWorkingSet(workingSet = wizard.getSelection())) {
                        manager.addWorkingSet(workingSet);
                        WorkingSetModelAwareSelectionDialog.this.addNewWorkingSet(workingSet);
                        WorkingSetModelAwareSelectionDialog.this.fCreatedWorkingSets.add(workingSet);
                    }
                }
            });
        }

        protected CheckboxTableViewer createTableViewer(Composite parent) {
            final CheckboxTableViewer result = CheckboxTableViewer.newCheckList((Composite)parent, (int)2050);
            result.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    GrayedCheckedModelElement element = (GrayedCheckedModelElement)event.getElement();
                    result.setGrayed((Object)element, false);
                    if (event.getChecked()) {
                        element.select();
                    } else {
                        element.deselect();
                    }
                    result.update((Object)element, null);
                }
            });
            GridData data = new GridData(1808);
            data.heightHint = this.convertHeightInCharsToPixels(20);
            data.widthHint = this.convertWidthInCharsToPixels(50);
            result.getTable().setLayoutData((Object)data);
            result.addFilter((ViewerFilter)new Filter());
            result.setLabelProvider((IBaseLabelProvider)new GrayedCheckedModelLabelProvider());
            result.setSorter((ViewerSorter)new GrayedCheckModelElementSorter());
            result.setContentProvider((IContentProvider)new GrayedCheckedModelContentProvider());
            result.setInput((Object)this.fModel);
            result.setCheckedElements((Object[])this.fModel.getChecked());
            result.setGrayedElements((Object[])this.fModel.getGrayed());
            return result;
        }

        protected void addNewWorkingSet(IWorkingSet workingSet) {
            int checkCount = 0;
            int i = 0;
            while (i < this.fElements.length) {
                IAdaptable adapted = ConfigureWorkingSetAssignementAction.adapt(workingSet, this.fElements[i]);
                if (adapted != null && ConfigureWorkingSetAssignementAction.contains(workingSet, adapted)) {
                    ++checkCount;
                }
                ++i;
            }
            GrayedCheckedModelElement element = new GrayedCheckedModelElement(workingSet, checkCount, this.fElements.length);
            this.fModel.addElement(element);
            this.fTableViewer.setInput((Object)this.fModel);
            this.fTableViewer.refresh();
            this.fTableViewer.setCheckedElements((Object[])this.fModel.getChecked());
            this.fTableViewer.setGrayedElements((Object[])this.fModel.getGrayed());
            this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)element));
        }

        private void createShowVisibleOnly(Composite parent) {
            PackageExplorerPart activePart = ConfigureWorkingSetAssignementAction.this.getActivePackageExplorer();
            if (ConfigureWorkingSetAssignementAction.this.fWorkingSetModel == null || activePart != null && activePart.getRootMode() == 1) {
                return;
            }
            final Button showVisibleOnly = new Button(parent, 32);
            showVisibleOnly.setText(WorkingSetMessages.ConfigureWorkingSetAssignementAction_OnlyShowVisible_check);
            showVisibleOnly.setSelection(this.fShowVisibleOnly);
            showVisibleOnly.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
            showVisibleOnly.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    WorkingSetModelAwareSelectionDialog.this.fShowVisibleOnly = showVisibleOnly.getSelection();
                    WorkingSetModelAwareSelectionDialog.this.fTableViewer.refresh();
                    WorkingSetModelAwareSelectionDialog.this.fTableViewer.setCheckedElements((Object[])WorkingSetModelAwareSelectionDialog.this.fModel.getChecked());
                    WorkingSetModelAwareSelectionDialog.this.fTableViewer.setGrayedElements((Object[])WorkingSetModelAwareSelectionDialog.this.fModel.getGrayed());
                }
            });
            Link ppwsLink = new Link(parent, 0);
            ppwsLink.setText(WorkingSetMessages.ConfigureWorkingSetAssignementAction_OnlyShowVisible_link);
            ppwsLink.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
            ppwsLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ArrayList<IWorkingSet> workingSets = new ArrayList<IWorkingSet>(Arrays.asList(ConfigureWorkingSetAssignementAction.this.fWorkingSetModel.getAllWorkingSets()));
                    boolean isSortingEnabled = ConfigureWorkingSetAssignementAction.this.fWorkingSetModel.isSortingEnabled();
                    WorkingSetConfigurationDialog dialog = new WorkingSetConfigurationDialog(WorkingSetModelAwareSelectionDialog.this.getShell(), workingSets.toArray(new IWorkingSet[workingSets.size()]), isSortingEnabled);
                    dialog.setSelection(ConfigureWorkingSetAssignementAction.this.fWorkingSetModel.getActiveWorkingSets());
                    if (dialog.open() == 0) {
                        isSortingEnabled = dialog.isSortingEnabled();
                        ConfigureWorkingSetAssignementAction.this.fWorkingSetModel.setWorkingSets(dialog.getAllWorkingSets(), isSortingEnabled, dialog.getSelection());
                    }
                    WorkingSetModelAwareSelectionDialog.this.recalculateCheckedState(dialog.getNewlyAddedWorkingSets());
                }
            });
        }

        protected void buttonPressed(int buttonId) {
            if (buttonId == 0) {
                this.fSettings.put(SETTINGS_SHOW_VISIBLE_ONLY, this.fShowVisibleOnly);
            }
            super.buttonPressed(buttonId);
        }

        private void recalculateCheckedState(List<IWorkingSet> addedWorkingSets) {
            HashSet<IWorkingSet> checkedWorkingSets = new HashSet<IWorkingSet>();
            GrayedCheckedModelElement[] elements = this.fModel.getChecked();
            int i = 0;
            while (i < elements.length) {
                checkedWorkingSets.add(elements[i].getWorkingSet());
                ++i;
            }
            if (addedWorkingSets != null) {
                checkedWorkingSets.addAll(addedWorkingSets);
            }
            this.fModel = ConfigureWorkingSetAssignementAction.createGrayedCheckedModel(this.fElements, ConfigureWorkingSetAssignementAction.this.getAllWorkingSets(), checkedWorkingSets);
            this.fTableViewer.setInput((Object)this.fModel);
            this.fTableViewer.refresh();
            this.fTableViewer.setCheckedElements((Object[])this.fModel.getChecked());
            this.fTableViewer.setGrayedElements((Object[])this.fModel.getGrayed());
        }

        protected void cancelPressed() {
            IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
            int i = 0;
            while (i < this.fCreatedWorkingSets.size()) {
                manager.removeWorkingSet(this.fCreatedWorkingSets.get(i));
                ++i;
            }
            super.cancelPressed();
        }

        private class Filter
        extends ViewerFilter {
            private Filter() {
            }

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                GrayedCheckedModelElement model = (GrayedCheckedModelElement)element;
                IWorkingSet set = model.getWorkingSet();
                return this.accept(set);
            }

            private boolean accept(IWorkingSet set) {
                if (!ConfigureWorkingSetAssignementAction.isValidWorkingSet(set)) {
                    return false;
                }
                PackageExplorerPart activePart = ConfigureWorkingSetAssignementAction.this.getActivePackageExplorer();
                if (ConfigureWorkingSetAssignementAction.this.fWorkingSetModel == null || activePart != null && activePart.getRootMode() == 1) {
                    return true;
                }
                return !WorkingSetModelAwareSelectionDialog.this.fShowVisibleOnly || ConfigureWorkingSetAssignementAction.this.fWorkingSetModel.isActiveWorkingSet(set);
            }
        }

        private final class GrayedCheckModelElementSorter
        extends ViewerSorter {
            private GrayedCheckModelElementSorter() {
            }

            public int compare(Viewer viewer, Object e1, Object e2) {
                GrayedCheckedModelElement w1 = (GrayedCheckedModelElement)e1;
                GrayedCheckedModelElement w2 = (GrayedCheckedModelElement)e2;
                return Collator.getInstance().compare(w1.getWorkingSet().getLabel(), w2.getWorkingSet().getLabel());
            }
        }
    }
}

