/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths;

import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class ArchiveFileFilter
extends ViewerFilter {
    public static final String JARZIP_FILTER_STRING = "*.jar,*.zip";
    public static final String[] JAR_ZIP_FILTER_EXTENSIONS = new String[]{"*.jar;*.zip"};
    public static final String[] ALL_ARCHIVES_FILTER_EXTENSIONS = new String[]{"*.jar;*.zip", "*.*"};
    private static final String[] fgArchiveExtensions = new String[]{"jar", "zip"};
    private List<IResource> fExcludes;
    private boolean fRecursive;
    private boolean fAllowAllArchives;

    public ArchiveFileFilter(List<IResource> excludedFiles, boolean recusive, boolean allowAllArchives) {
        this.fExcludes = excludedFiles;
        this.fRecursive = recusive;
        this.fAllowAllArchives = allowAllArchives;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean select(Viewer viewer, Object parent, Object element) {
        if (element instanceof IFile) {
            if (this.fExcludes == null) return ArchiveFileFilter.isArchivePath(((IFile)element).getFullPath(), this.fAllowAllArchives);
            if (!this.fExcludes.contains(element)) return ArchiveFileFilter.isArchivePath(((IFile)element).getFullPath(), this.fAllowAllArchives);
            return false;
        }
        if (!(element instanceof IContainer)) return false;
        if (!this.fRecursive) {
            return true;
        }
        if (element instanceof IProject && !((IProject)element).isOpen()) {
            return false;
        }
        try {
            IResource[] resources = ((IContainer)element).members();
            int i = 0;
            while (true) {
                if (i >= resources.length) {
                    return false;
                }
                if (this.select(viewer, parent, resources[i])) {
                    return true;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            JavaPlugin.log(e.getStatus());
        }
        return false;
    }

    public static boolean isArchivePath(IPath path, boolean allowAllAchives) {
        if (allowAllAchives) {
            return true;
        }
        String ext = path.getFileExtension();
        if (ext != null && ext.length() != 0) {
            return ArchiveFileFilter.isArchiveFileExtension(ext);
        }
        return false;
    }

    public static boolean isArchiveFileExtension(String ext) {
        int i = 0;
        while (i < fgArchiveExtensions.length) {
            if (ext.equalsIgnoreCase(fgArchiveExtensions[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

