/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.browsing;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.internal.ui.browsing.IPackagesViewViewer;
import org.eclipse.jdt.internal.ui.browsing.LogicalPackage;
import org.eclipse.jdt.internal.ui.browsing.LogicalPackagesProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;

@Deprecated
class PackageViewerWrapper
extends StructuredViewer {
    private StructuredViewer fViewer;
    private ListenerList<Object> fListenerList = new ListenerList(1);
    private ListenerList<ISelectionChangedListener> fSelectionChangedListenerList;
    private ListenerList<ISelectionChangedListener> fPostSelectionChangedListenerList = new ListenerList(1);

    public PackageViewerWrapper() {
        this.fSelectionChangedListenerList = new ListenerList(1);
    }

    public void setViewer(StructuredViewer viewer) {
        Assert.isNotNull((Object)viewer);
        StructuredViewer oldViewer = this.fViewer;
        this.fViewer = viewer;
        if (this.fViewer.getContentProvider() != null) {
            super.setContentProvider(this.fViewer.getContentProvider());
        }
        this.transferFilters(oldViewer);
        this.transferListeners();
    }

    StructuredViewer getViewer() {
        return this.fViewer;
    }

    private void transferFilters(StructuredViewer oldViewer) {
        if (oldViewer != null) {
            ViewerFilter[] filters = oldViewer.getFilters();
            int i = 0;
            while (i < filters.length) {
                ViewerFilter filter = filters[i];
                this.fViewer.addFilter(filter);
                ++i;
            }
        }
    }

    private void transferListeners() {
        ISelectionChangedListener listener;
        Object object;
        Object[] listeners = this.fPostSelectionChangedListenerList.getListeners();
        int i = 0;
        while (i < listeners.length) {
            object = listeners[i];
            listener = (ISelectionChangedListener)object;
            this.fViewer.addPostSelectionChangedListener(listener);
            ++i;
        }
        listeners = this.fSelectionChangedListenerList.getListeners();
        i = 0;
        while (i < listeners.length) {
            object = listeners[i];
            listener = (ISelectionChangedListener)object;
            this.fViewer.addSelectionChangedListener(listener);
            ++i;
        }
        listeners = this.fListenerList.getListeners();
        i = 0;
        while (i < listeners.length) {
            object = listeners[i];
            if (object instanceof IOpenListener) {
                listener = (IOpenListener)object;
                this.addOpenListener((IOpenListener)listener);
            } else if (object instanceof HelpListener) {
                listener = (HelpListener)object;
                this.addHelpListener((HelpListener)listener);
            } else if (object instanceof IDoubleClickListener) {
                listener = (IDoubleClickListener)object;
                this.addDoubleClickListener((IDoubleClickListener)listener);
            }
            ++i;
        }
    }

    public void setSelection(ISelection selection, boolean reveal) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)selection;
            IContentProvider provider = this.getContentProvider();
            if (provider instanceof LogicalPackagesProvider) {
                LogicalPackagesProvider fprovider = (LogicalPackagesProvider)provider;
                Object object = sel.getFirstElement();
                if (object instanceof IPackageFragment) {
                    IPackageFragment pkgFragment = (IPackageFragment)object;
                    LogicalPackage logicalPkg = fprovider.findLogicalPackage(pkgFragment);
                    object = logicalPkg != null ? logicalPkg : pkgFragment;
                }
                if (object != null) {
                    this.fViewer.setSelection((ISelection)new StructuredSelection(object), reveal);
                } else {
                    this.fViewer.setSelection((ISelection)StructuredSelection.EMPTY, reveal);
                }
            }
        } else {
            this.fViewer.setSelection(selection, reveal);
        }
    }

    public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
        this.fPostSelectionChangedListenerList.add((Object)listener);
        this.fViewer.addPostSelectionChangedListener(listener);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionChangedListenerList.add((Object)listener);
        this.fViewer.addSelectionChangedListener(listener);
    }

    public void addDoubleClickListener(IDoubleClickListener listener) {
        this.fViewer.addDoubleClickListener(listener);
        this.fListenerList.add((Object)listener);
    }

    public void addOpenListener(IOpenListener listener) {
        this.fViewer.addOpenListener(listener);
        this.fListenerList.add((Object)listener);
    }

    public void addHelpListener(HelpListener listener) {
        this.fViewer.addHelpListener(listener);
        this.fListenerList.add((Object)listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.fViewer.removeSelectionChangedListener(listener);
        this.fSelectionChangedListenerList.remove((Object)listener);
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
        this.fViewer.removePostSelectionChangedListener(listener);
        this.fPostSelectionChangedListenerList.remove((Object)listener);
    }

    public void removeHelpListener(HelpListener listener) {
        this.fListenerList.remove((Object)listener);
        this.fViewer.removeHelpListener(listener);
    }

    public void removeDoubleClickListener(IDoubleClickListener listener) {
        this.fViewer.removeDoubleClickListener(listener);
        this.fListenerList.remove((Object)listener);
    }

    public void removeOpenListener(IOpenListener listener) {
        this.fViewer.removeOpenListener(listener);
        this.fListenerList.remove((Object)listener);
    }

    public Control getControl() {
        return this.fViewer.getControl();
    }

    public void addFilter(ViewerFilter filter) {
        this.fViewer.addFilter(filter);
    }

    public void setFilters(ViewerFilter ... filters) {
        this.fViewer.setFilters(filters);
    }

    public ViewerFilter[] getFilters() {
        return this.fViewer.getFilters();
    }

    public void refresh() {
        this.fViewer.refresh();
    }

    public void removeFilter(ViewerFilter filter) {
        this.fViewer.removeFilter(filter);
    }

    public ISelection getSelection() {
        return this.fViewer.getSelection();
    }

    public void refresh(boolean updateLabels) {
        this.fViewer.refresh(updateLabels);
    }

    public void refresh(Object element, boolean updateLabels) {
        this.fViewer.refresh(element, updateLabels);
    }

    public void refresh(Object element) {
        this.fViewer.refresh(element);
    }

    public void resetFilters() {
        this.fViewer.resetFilters();
    }

    public void reveal(Object element) {
        this.fViewer.reveal(element);
    }

    public void setContentProvider(IContentProvider contentProvider) {
        this.fViewer.setContentProvider(contentProvider);
    }

    public void setSorter(ViewerSorter sorter) {
        this.fViewer.setSorter(sorter);
    }

    public void setComparator(ViewerComparator comparator) {
        this.fViewer.setComparator(comparator);
    }

    public void setUseHashlookup(boolean enable) {
        this.fViewer.setUseHashlookup(enable);
    }

    public Widget testFindItem(Object element) {
        return this.fViewer.testFindItem(element);
    }

    public void update(Object element, String[] properties) {
        this.fViewer.update(element, properties);
    }

    public void update(Object[] elements, String[] properties) {
        this.fViewer.update(elements, properties);
    }

    public IContentProvider getContentProvider() {
        return this.fViewer.getContentProvider();
    }

    public Object getInput() {
        return this.fViewer.getInput();
    }

    public IBaseLabelProvider getLabelProvider() {
        return this.fViewer.getLabelProvider();
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        this.fViewer.setLabelProvider(labelProvider);
    }

    public Object getData(String key) {
        return this.fViewer.getData(key);
    }

    public Item scrollDown(int x, int y) {
        return this.fViewer.scrollDown(x, y);
    }

    public Item scrollUp(int x, int y) {
        return this.fViewer.scrollUp(x, y);
    }

    public void setData(String key, Object value) {
        this.fViewer.setData(key, value);
    }

    public void setSelection(ISelection selection) {
        this.fViewer.setSelection(selection);
    }

    public boolean equals(Object obj) {
        return this.fViewer.equals(obj);
    }

    public int hashCode() {
        return this.fViewer.hashCode();
    }

    public String toString() {
        return this.fViewer.toString();
    }

    public void setViewerInput(Object input) {
        this.fViewer.setInput(input);
    }

    protected Widget doFindInputItem(Object element) {
        return ((IPackagesViewViewer)this.fViewer).doFindInputItem(element);
    }

    protected Widget doFindItem(Object element) {
        return ((IPackagesViewViewer)this.fViewer).doFindItem(element);
    }

    protected void doUpdateItem(Widget item, Object element, boolean fullMap) {
        ((IPackagesViewViewer)this.fViewer).doUpdateItem(item, element, fullMap);
    }

    protected List getSelectionFromWidget() {
        return ((IPackagesViewViewer)this.fViewer).getSelectionFromWidget();
    }

    protected void internalRefresh(Object element) {
        ((IPackagesViewViewer)this.fViewer).internalRefresh(element);
    }

    protected void setSelectionToWidget(List l, boolean reveal) {
        ((IPackagesViewViewer)this.fViewer).setSelectionToWidget(l, reveal);
    }

    public ViewerComparator getComparator() {
        return this.fViewer.getComparator();
    }

    public IElementComparer getComparer() {
        return this.fViewer.getComparer();
    }

    public ViewerSorter getSorter() {
        return this.fViewer.getSorter();
    }

    public void setComparer(IElementComparer comparer) {
        this.fViewer.setComparer(comparer);
    }

    public void addDragSupport(int operations, Transfer[] transferTypes, DragSourceListener listener) {
        this.fViewer.addDragSupport(operations, transferTypes, listener);
    }

    public void addDropSupport(int operations, Transfer[] transferTypes, DropTargetListener listener) {
        this.fViewer.addDropSupport(operations, transferTypes, listener);
    }

    public Widget[] testFindItems(Object element) {
        return this.fViewer.testFindItems(element);
    }
}

