/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jdt.core.dom.rewrite.ITrackedNodePosition;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalPositionGroup;

public class LinkedProposalModel {
    private Map<String, LinkedProposalPositionGroup> fPositionGroups;
    private LinkedProposalPositionGroup.PositionInformation fEndPosition;

    public void addPositionGroup(LinkedProposalPositionGroup positionGroup) {
        if (positionGroup == null) {
            throw new IllegalArgumentException("positionGroup must not be null");
        }
        if (this.fPositionGroups == null) {
            this.fPositionGroups = new HashMap<String, LinkedProposalPositionGroup>();
        }
        this.fPositionGroups.put(positionGroup.getGroupId(), positionGroup);
    }

    public LinkedProposalPositionGroup getPositionGroup(String groupId, boolean createIfNotExisting) {
        LinkedProposalPositionGroup group;
        LinkedProposalPositionGroup linkedProposalPositionGroup = group = this.fPositionGroups != null ? this.fPositionGroups.get(groupId) : null;
        if (createIfNotExisting && group == null) {
            group = new LinkedProposalPositionGroup(groupId);
            this.addPositionGroup(group);
        }
        return group;
    }

    public Iterator<LinkedProposalPositionGroup> getPositionGroupIterator() {
        if (this.fPositionGroups == null) {
            return new Iterator<LinkedProposalPositionGroup>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public LinkedProposalPositionGroup next() {
                    return null;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return this.fPositionGroups.values().iterator();
    }

    public void setEndPosition(LinkedProposalPositionGroup.PositionInformation position) {
        this.fEndPosition = position;
    }

    public void setEndPosition(ITrackedNodePosition position) {
        this.setEndPosition(LinkedProposalPositionGroup.createPositionInformation(position, 1));
    }

    public LinkedProposalPositionGroup.PositionInformation getEndPosition() {
        return this.fEndPosition;
    }

    public boolean hasLinkedPositions() {
        return this.fPositionGroups != null && !this.fPositionGroups.isEmpty();
    }

    public void clear() {
        this.fPositionGroups = null;
        this.fEndPosition = null;
    }
}

