/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.codemanipulation.tostringgeneration;

import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.StringConverter;

public class ToStringGenerationSettings
extends CodeGenerationSettings {
    public static final String SETTINGS_SELECTED_TEMPLATE = "ToStringTemplateSelected";
    public static final String SETTINGS_STRINGSTYLE = "StringStyle";
    public static final String SETTINGS_SKIPNULLS = "SkipNull";
    public static final String SETTINGS_IGNOREDEFAULT = "IgnoreDefault";
    public static final String SETTINGS_LIMITELEMENTS = "LimitElements";
    public static final String SETTINGS_LIMITVALUE = "LimitValue";
    public static final String SETTINGS_TEMPLATE_NAMES = "ToStringTemplateNames";
    public static final String SETTINGS_TEMPLATES = "ToStringTemplates";
    public static final String SETTINGS_CUSTOMBUILDER_CLASS = "CustomBuilderClass";
    public static final String SETTINGS_CUSTOMBUILDER_LABEL = "CustomBuilderLabel";
    public static final String SETTINGS_CUSTOMBUILDER_APPENDMETHOD = "CustomBuilderAppendMethod";
    public static final String SETTINGS_CUSTOMBUILDER_RESULTMETHOD = "CustomBuilderResultMethod";
    public static final String SETTINGS_CUSTOMBUILDER_CHAINCALLS = "CustomBuilderChainCalls";
    public int stringFormatTemplateNumber;
    public String stringFormatTemplate;
    public int toStringStyle;
    public boolean skipNulls;
    public boolean customArrayToString;
    public boolean limitElements;
    public int limitValue;
    public boolean useBlocks;
    public boolean is50orHigher;
    public boolean is60orHigher;
    public CustomBuilderSettings customBuilderSettings;
    private IDialogSettings dialogSettings;

    public ToStringGenerationSettings(IDialogSettings dialogSettings) {
        this.dialogSettings = dialogSettings;
        this.limitElements = this.asBoolean(dialogSettings.get(SETTINGS_LIMITELEMENTS), false);
        this.customArrayToString = this.asBoolean(dialogSettings.get(SETTINGS_IGNOREDEFAULT), true);
        this.toStringStyle = ToStringGenerationSettings.asInt(dialogSettings.get(SETTINGS_STRINGSTYLE), 0);
        this.limitValue = ToStringGenerationSettings.asInt(dialogSettings.get(SETTINGS_LIMITVALUE), 10);
        this.skipNulls = this.asBoolean(dialogSettings.get(SETTINGS_SKIPNULLS), false);
        this.stringFormatTemplateNumber = ToStringGenerationSettings.asInt(dialogSettings.get(SETTINGS_SELECTED_TEMPLATE), 0);
        this.customBuilderSettings = new CustomBuilderSettings();
        this.customBuilderSettings.className = ToStringGenerationSettings.asString(dialogSettings.get(SETTINGS_CUSTOMBUILDER_CLASS), "");
        this.customBuilderSettings.variableName = ToStringGenerationSettings.asString(dialogSettings.get(SETTINGS_CUSTOMBUILDER_LABEL), "builder");
        this.customBuilderSettings.appendMethod = ToStringGenerationSettings.asString(dialogSettings.get(SETTINGS_CUSTOMBUILDER_APPENDMETHOD), "append");
        this.customBuilderSettings.resultMethod = ToStringGenerationSettings.asString(dialogSettings.get(SETTINGS_CUSTOMBUILDER_RESULTMETHOD), "toString");
        this.customBuilderSettings.chainCalls = this.asBoolean(dialogSettings.get(SETTINGS_CUSTOMBUILDER_CHAINCALLS), false);
    }

    public ToStringGenerationSettings() {
    }

    public void writeDialogSettings() {
        this.dialogSettings.put(SETTINGS_LIMITELEMENTS, this.limitElements);
        this.dialogSettings.put(SETTINGS_IGNOREDEFAULT, this.customArrayToString);
        this.dialogSettings.put(SETTINGS_STRINGSTYLE, this.toStringStyle);
        this.dialogSettings.put(SETTINGS_LIMITVALUE, this.limitValue);
        this.dialogSettings.put(SETTINGS_SKIPNULLS, this.skipNulls);
        this.dialogSettings.put(SETTINGS_SELECTED_TEMPLATE, this.stringFormatTemplateNumber);
    }

    public CustomBuilderSettings getCustomBuilderSettings() {
        CustomBuilderSettings result = new CustomBuilderSettings();
        result.className = this.customBuilderSettings.className;
        result.variableName = this.customBuilderSettings.variableName;
        result.appendMethod = this.customBuilderSettings.appendMethod;
        result.resultMethod = this.customBuilderSettings.resultMethod;
        result.chainCalls = this.customBuilderSettings.chainCalls;
        return result;
    }

    public void writeCustomBuilderSettings(CustomBuilderSettings customBuilderSettings1) {
        this.dialogSettings.put(SETTINGS_CUSTOMBUILDER_CLASS, customBuilderSettings1.className);
        this.dialogSettings.put(SETTINGS_CUSTOMBUILDER_LABEL, customBuilderSettings1.variableName);
        this.dialogSettings.put(SETTINGS_CUSTOMBUILDER_APPENDMETHOD, customBuilderSettings1.appendMethod);
        this.dialogSettings.put(SETTINGS_CUSTOMBUILDER_RESULTMETHOD, customBuilderSettings1.resultMethod);
        this.dialogSettings.put(SETTINGS_CUSTOMBUILDER_CHAINCALLS, customBuilderSettings1.chainCalls);
        this.customBuilderSettings = customBuilderSettings1;
    }

    private boolean asBoolean(String string, boolean defaultValue) {
        if (string != null) {
            return StringConverter.asBoolean((String)string, (boolean)defaultValue);
        }
        return defaultValue;
    }

    private static int asInt(String string, int defaultValue) {
        if (string != null) {
            return StringConverter.asInt((String)string, (int)defaultValue);
        }
        return defaultValue;
    }

    private static String asString(String string, String defaultValue) {
        if (string != null) {
            return string;
        }
        return defaultValue;
    }

    public static class CustomBuilderSettings {
        public String className;
        public String variableName;
        public String appendMethod;
        public String resultMethod;
        public boolean chainCalls;
    }
}

