/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.logging.aeri.core.util;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.epp.logging.aeri.core.SystemControl;
import org.eclipse.epp.logging.aeri.core.l10n.LogMessages;
import org.eclipse.jdt.annotation.Nullable;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;

public class Logs {
    public static IStatus toStatus(ILogMessage msg, Object ... args) {
        return Logs.toStatus(msg, null, args);
    }

    public static IStatus toStatus(ILogMessage msg, @Nullable Throwable t, Object ... args) {
        String message;
        block2: {
            Preconditions.checkNotNull((Object)msg);
            message = null;
            try {
                message = MessageFormat.format(msg.message(), args);
            }
            catch (Exception e) {
                ILog log;
                message = msg.message();
                Bundle bundle = FrameworkUtil.getBundle(Logs.class);
                if (bundle == null || (log = Platform.getLog((Bundle)bundle)) == null) break block2;
                String format = MessageFormat.format("Failed to format '{0}': {1}", msg.message(), e.getMessage());
                Status error = new Status(4, bundle.getSymbolicName(), format, (Throwable)e);
                log.log((IStatus)error);
            }
        }
        return new Status(msg.severity(), msg.bundle().getSymbolicName(), msg.code(), message, t);
    }

    public static void log(ILogMessage msg) {
        Logs.log(msg, null);
    }

    public static void log(ILogMessage msg, Throwable t) {
        Logs.log(msg, t, null);
    }

    public static void log(ILogMessage msg, Object ... args) {
        Logs.log(msg, LogTraceException.newTrace(), args);
    }

    public static void log(ILogMessage msg, Throwable t, Object ... args) {
        try {
            IStatus status = Logs.toStatus(msg, t, args);
            Bundle bundle = msg.bundle();
            ILog log = Platform.getLog((Bundle)bundle);
            log.log(status);
        }
        catch (Exception exception) {}
    }

    public static Bundle getBundle(Class<?> bundleClazz) {
        Bundle res = FrameworkUtil.getBundle(bundleClazz);
        if (res != null) {
            return res;
        }
        String fakeSymbolicName = bundleClazz.getPackage().getName();
        return new FakeBundle(fakeSymbolicName);
    }

    public static ILog getLog(@Nullable Bundle bundle) {
        if (bundle == null) {
            return new SystemOutLog();
        }
        return Platform.getLog((Bundle)bundle);
    }

    public static String toString(IStatus status) {
        StringBuilder sb = new StringBuilder();
        Logs.appendSeverityAndMessage(status, sb);
        Logs.appendException(status, sb);
        if (status.isMultiStatus()) {
            Logs.appendChildren(status, sb);
        }
        return sb.toString();
    }

    private static void appendSeverityAndMessage(IStatus status, StringBuilder sb) {
        sb.append(Logs.toSeverity(status)).append(':').append(' ').append(status.getMessage());
    }

    private static String toSeverity(IStatus status) {
        switch (status.getSeverity()) {
            case 8: {
                return "CANCEL";
            }
            case 4: {
                return "ERROR";
            }
            case 2: {
                return "WARNING";
            }
            case 1: {
                return "INFO";
            }
            case 0: {
                return "OK";
            }
        }
        throw new RuntimeException("Unreachable");
    }

    private static void appendException(IStatus status, StringBuilder sb) {
        if (status.getException() != null) {
            sb.append(' ').append(status.getException());
        }
    }

    private static void appendChildren(IStatus status, StringBuilder sb) {
        IStatus[] iStatusArray = status.getChildren();
        int n = iStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus child = iStatusArray[n2];
            sb.append('\n').append(Logs.toString(child));
            ++n2;
        }
    }

    public static void debug(String message, Object ... args) {
        Logs.debug(message, null, args);
    }

    public static void debug(String message, Throwable throwable, Object ... args) {
        if (SystemControl.isDebug()) {
            LogMessages log = new LogMessages(1, 404, message);
            Logs.log((ILogMessage)log, throwable, args);
        }
    }

    public static void warn(String message, Object ... args) {
        Logs.warn(message, null, args);
    }

    public static void warn(String message, Throwable throwable, Object ... args) {
        LogMessages log = new LogMessages(2, 404, message);
        Logs.log((ILogMessage)log, throwable, args);
    }

    public static abstract class DefaultLogMessage
    implements ILogMessage {
        private int severity;
        private int code;
        private String message;

        public DefaultLogMessage(int severity, int code, String message) {
            Preconditions.checkArgument((code > 0 ? 1 : 0) != 0, (Object)"The error code cannot be '0'");
            Preconditions.checkNotNull((Object)message);
            this.severity = severity;
            this.code = code;
            this.message = message;
        }

        @Override
        public int severity() {
            return this.severity;
        }

        @Override
        public int code() {
            return this.code;
        }

        @Override
        public String message() {
            return this.message;
        }

        @Override
        public abstract Bundle bundle();
    }

    private static final class FakeBundle
    implements Bundle {
        private String symbolicName;

        public FakeBundle(String fakeBundleId) {
            this.symbolicName = fakeBundleId;
        }

        public int compareTo(Bundle arg0) {
            return 0;
        }

        public void update(InputStream input) throws BundleException {
        }

        public void update() throws BundleException {
        }

        public void uninstall() throws BundleException {
        }

        public void stop(int options) throws BundleException {
        }

        public void stop() throws BundleException {
        }

        public void start(int options) throws BundleException {
        }

        public void start() throws BundleException {
        }

        public Class<?> loadClass(String name) throws ClassNotFoundException {
            return null;
        }

        public boolean hasPermission(Object permission) {
            return false;
        }

        public Version getVersion() {
            return null;
        }

        public String getSymbolicName() {
            return this.symbolicName;
        }

        public int getState() {
            return 0;
        }

        public Map<X509Certificate, List<X509Certificate>> getSignerCertificates(int signersType) {
            return null;
        }

        public ServiceReference<?>[] getServicesInUse() {
            return null;
        }

        public Enumeration<URL> getResources(String name) throws IOException {
            return null;
        }

        public URL getResource(String name) {
            return null;
        }

        public ServiceReference<?>[] getRegisteredServices() {
            return null;
        }

        public String getLocation() {
            return null;
        }

        public long getLastModified() {
            return 0L;
        }

        public Dictionary<String, String> getHeaders(String locale) {
            return null;
        }

        public Dictionary<String, String> getHeaders() {
            return null;
        }

        public Enumeration<String> getEntryPaths(String path) {
            return null;
        }

        public URL getEntry(String path) {
            return null;
        }

        public File getDataFile(String filename) {
            return null;
        }

        public long getBundleId() {
            return 0L;
        }

        public BundleContext getBundleContext() {
            return null;
        }

        public Enumeration<URL> findEntries(String path, String filePattern, boolean recurse) {
            return null;
        }

        public <A> A adapt(Class<A> type) {
            return null;
        }
    }

    public static interface ILogMessage {
        public int severity();

        public int code();

        public String message();

        public Bundle bundle();
    }

    private static final class LogTraceException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private LogTraceException() {
        }

        static LogTraceException newTrace() {
            LogTraceException res = new LogTraceException();
            res.fillInStackTrace();
            return res;
        }
    }

    private static final class SystemOutLog
    implements ILog {
        private SystemOutLog() {
        }

        public void removeLogListener(ILogListener listener) {
        }

        public void log(IStatus status) {
            System.out.println(status);
        }

        public Bundle getBundle() {
            return null;
        }

        public void addLogListener(ILogListener listener) {
        }
    }
}

